/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.invoker.entity;

import com.becon.opencelium.backend.enums.PageParam;
import com.becon.opencelium.backend.enums.PageParamAction;
import com.becon.opencelium.backend.invoker.entity.PageParamRule;
import com.becon.opencelium.backend.invoker.entity.Pagination;
import com.becon.opencelium.backend.utility.MediaTypeUtility;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class Pagination
implements Cloneable {
    private List<PageParamRule> pageParamRules;
    private int currentSize;
    private boolean isLastResultEmpty;

    public Pagination(List<PageParamRule> pageParamRules) {
        this.pageParamRules = pageParamRules;
    }

    public List<PageParamRule> getPageParamRules() {
        return this.pageParamRules;
    }

    public String getParamValue(PageParam param) {
        return this.findParam(param).getValue();
    }

    public void changeParamValue(PageParam param, String newValue) {
        this.findParam(param).setValue(newValue);
    }

    public PageParamRule findParam(PageParam param) {
        return this.pageParamRules.stream().filter(p -> p.getParam() == param).findFirst().orElseThrow(() -> new RuntimeException("Parameter \"" + param + "\" not found in pagination"));
    }

    public boolean existsParam(PageParam param) {
        return this.pageParamRules.stream().filter(p -> p.getParam() == param).findFirst().orElse(null) != null;
    }

    public boolean hasMore() {
        String url;
        String value;
        String result;
        if (this.isLastResultEmpty) {
            return false;
        }
        this.currentSize = this.getCurrentSize();
        if (this.existsParam(PageParam.HAS_MORE) && (result = this.findParam(PageParam.HAS_MORE).getValue()) != null && !result.isEmpty()) {
            return Boolean.parseBoolean(result);
        }
        if (this.existsParam(PageParam.SIZE) && (value = this.getParamValue(PageParam.SIZE)) != null) {
            int size = Integer.parseInt(value);
            return this.currentSize < size;
        }
        if (this.existsParam(PageParam.CURSOR) && ((result = this.findParam(PageParam.CURSOR).getValue()) == null || result.isEmpty())) {
            return false;
        }
        if (this.existsParam(PageParam.LINK) && (url = this.getParamValue(PageParam.LINK)) != null && !url.isEmpty()) {
            try {
                URI uri = new URI(url);
                return !uri.getRawQuery().contains("null");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public int getCurrentSize() {
        PageParamRule paramRule = this.findParam(PageParam.RESULT);
        String payload = paramRule.getValue();
        String jsonPath = paramRule.getRefPath();
        this.currentSize = (Integer)JsonPath.parse((String)payload).read(jsonPath + ".length()", new Predicate[0]);
        return this.currentSize;
    }

    public void updateParamValues(ResponseEntity<?> response, Class<?> responseType) {
        String body;
        boolean needConversion = true;
        if (response.getHeaders().getContentType() != null && !MediaTypeUtility.isJsonCompatible((MediaType)response.getHeaders().getContentType())) {
            needConversion = false;
        } else if (responseType.equals(String.class)) {
            needConversion = false;
        }
        if (needConversion) {
            try {
                body = new ObjectMapper().writer().withDefaultPrettyPrinter().writeValueAsString(response.getBody());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            body = (String)response.getBody();
        }
        this.updateParamValues(new ResponseEntity((Object)body, (MultiValueMap)response.getHeaders(), response.getStatusCode()));
    }

    private void updateParamValues(ResponseEntity<String> response) {
        HttpRepository httpRepository = new HttpRepository(response);
        this.pageParamRules.stream().filter(paramRule -> paramRule.getRef() != null).filter(paramRule -> paramRule.getRef().split("\\.", 2)[0].equals("response")).forEach(paramRule -> {
            Object value;
            try {
                value = httpRepository.findValueByPath(paramRule.getRef());
            }
            catch (PathNotFoundException ex) {
                value = null;
            }
            if (paramRule.getParam().equals((Object)PageParam.RESULT)) {
                this.isLastResultEmpty = Pagination.isEmptyJsonArray((String)value);
                if (paramRule.getValue() == null || paramRule.getValue().isEmpty()) {
                    paramRule.setValue((String)response.getBody());
                    return;
                }
                String path = paramRule.getRefPath();
                String result = Pagination.mergeArrayIntoObject((String)paramRule.getValue(), (String)value, (String)path);
                paramRule.setValue(result);
                return;
            }
            if (paramRule.getParam().equals((Object)PageParam.PAGE) && paramRule.getAction().equals((Object)PageParamAction.INCREMENT)) {
                value = "" + (Integer.parseInt((String)value) + 1);
            }
            if (paramRule.getParam().equals((Object)PageParam.OFFSET) && paramRule.getAction().equals((Object)PageParamAction.INCREMENT)) {
                int limit = Integer.parseInt(this.findParam(PageParam.LIMIT).getValue());
                value = "" + (Integer.parseInt((String)value) + limit);
            }
            paramRule.setValue((String)value);
        });
        this.pageParamRules.stream().filter(paramRule -> paramRule.getRef() == null).forEach(paramRule -> {
            Object value = paramRule.getValue();
            if (paramRule.getParam().equals((Object)PageParam.PAGE) && paramRule.getAction().equals((Object)PageParamAction.INCREMENT)) {
                value = "" + (Integer.parseInt((String)value) + 1);
            }
            if (paramRule.getParam().equals((Object)PageParam.OFFSET) && paramRule.getAction().equals((Object)PageParamAction.INCREMENT)) {
                int limit = Integer.parseInt(this.findParam(PageParam.LIMIT).getValue());
                value = "" + (Integer.parseInt((String)value) + limit);
            }
            paramRule.setValue((String)value);
        });
    }

    public Pagination clone() {
        Pagination clone;
        try {
            clone = (Pagination)super.clone();
        }
        catch (CloneNotSupportedException e) {
            clone = new Pagination(this.pageParamRules.stream().map(PageParamRule::clone).collect(Collectors.toList()));
        }
        clone.pageParamRules = this.pageParamRules.stream().map(PageParamRule::clone).collect(Collectors.toList());
        return clone;
    }

    private static boolean isEmptyJsonArray(String jsonArray) {
        if ("[]".equals(jsonArray)) {
            return true;
        }
        try {
            ArrayNode arrNode = (ArrayNode)new ObjectMapper().readTree(jsonArray);
            return arrNode.isEmpty();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String mergeArrayIntoObject(String obj, String arr, String jsonPath) {
        try {
            String jsonPointer = Pagination.convertJSONPathToPointer((String)jsonPath);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(obj);
            ArrayNode arrNode = (ArrayNode)mapper.readTree(arr);
            JsonNode dataNode = rootNode.at(jsonPointer);
            if (!(dataNode instanceof ArrayNode)) {
                throw new IllegalArgumentException("Path does not point to an array node");
            }
            ((ArrayNode)dataNode).addAll(arrNode);
            return rootNode.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String convertJSONPathToPointer(String jsonPath) {
        if (jsonPath == null || jsonPath.isEmpty()) {
            return "";
        }
        String jsonPointer = jsonPath.trim().substring(1).replaceAll("\\.", "/");
        jsonPointer = jsonPointer.replaceAll("\\[(\\d+)\\]", "/$1");
        return jsonPointer;
    }
}

