/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.invoker;

import com.becon.opencelium.backend.invoker.entity.Invoker;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class InvokerContainer {
    private Map<String, Invoker> invokers;

    public InvokerContainer(Map<String, Invoker> invokers) {
        this.invokers = invokers;
    }

    public Map<String, Invoker> getInvokers() {
        return this.invokers;
    }

    public Invoker getByName(String name) {
        if (!this.invokers.containsKey(name)) {
            for (Invoker invoker : this.invokers.values()) {
                if (!invoker.getName().equals(name)) continue;
                return invoker;
            }
            throw new RuntimeException("Invoker " + name + " from DB not found in invoker folder");
        }
        return (Invoker)this.invokers.get(name);
    }

    public boolean existsByName(String name) {
        return this.invokers.get(name) != null;
    }

    public void updateAll(Map<String, Invoker> invokers) {
        this.invokers = invokers;
    }

    public void add(String name, Invoker invoker) {
        this.invokers.put(name, invoker);
    }

    public void remove(String name) {
        this.invokers.remove(name);
    }
}

