/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.gc.connection;

import com.becon.opencelium.backend.gc.base.Criteria;
import com.becon.opencelium.backend.gc.base.GCRunner;
import com.becon.opencelium.backend.gc.base.GarbageCollector;
import com.becon.opencelium.backend.gc.base.RunGCEvent;
import com.becon.opencelium.backend.gc.base.strategy.StrategyConfig;
import com.becon.opencelium.backend.gc.base.strategy.TriggerStrategyFactory;
import com.becon.opencelium.backend.gc.connection.ConnectionForGC;
import com.becon.opencelium.backend.gc.connection.ConnectionGC;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ConnectionGCRunner
extends GCRunner<ConnectionForGC> {
    private final Criteria<ConnectionForGC> criteria = this.setCriteria();
    private final boolean on;
    private static final String DEFAULT_STRATEGY_STRING = "periodic";
    private static final String DEFAULT_GC_IS_ON_STRING = "false";

    public ConnectionGCRunner(ConnectionGC connectionGC, Environment env) {
        super((GarbageCollector)connectionGC, null);
        this.on = Boolean.parseBoolean(env.getProperty("opencelium.gc.connection.isOn", DEFAULT_GC_IS_ON_STRING));
        String strategy = env.getProperty("opencelium.gc.connection.strategy", DEFAULT_STRATEGY_STRING);
        String cron = env.getProperty("opencelium.gc.connection.cron");
        long fixedDelay = Long.parseLong(env.getProperty("opencelium.gc.connection.fixedDelay", "-1"));
        long initialDelay = Long.parseLong(env.getProperty("opencelium.gc.connection.initialDelay", "-1"));
        StrategyConfig strategyConfig = new StrategyConfig(strategy, cron, fixedDelay, initialDelay);
        this.trigger = TriggerStrategyFactory.getStrategy((StrategyConfig)strategyConfig);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void startGC() {
        if (this.on) {
            this.garbageCollector.start(this.criteria);
            this.trigger.startTrigger();
        }
    }

    public void runGC() {
        this.garbageCollector.sweep();
    }

    public void stopGC() {
        this.trigger.shutdown();
        this.garbageCollector.stop();
    }

    @EventListener
    private void triggerListener(RunGCEvent<ConnectionForGC> event) {
        this.runGC();
    }

    private Criteria<ConnectionForGC> setCriteria() {
        return Criteria.builder().and(c -> c.getConnection().getTitle() != null).and(c -> !c.getConnection().getTitle().matches("!\\*test_connection_[0-9]{13}_operator_test")).build();
    }
}

