/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.gc.connection;

import com.becon.opencelium.backend.database.mysql.service.ConnectionHistoryService;
import com.becon.opencelium.backend.gc.base.Criteria;
import com.becon.opencelium.backend.gc.base.GarbageCollector;
import com.becon.opencelium.backend.gc.connection.ConnectionForGC;
import com.becon.opencelium.backend.gc.connection.ConnectionPool;
import com.becon.opencelium.backend.gc.connection.service.ConnectionGCService;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class ConnectionGC
implements GarbageCollector<ConnectionForGC> {
    private static final Logger log = LoggerFactory.getLogger((String)"GC");
    private Criteria<ConnectionForGC> criteria;
    private final AtomicBoolean ready = new AtomicBoolean(false);
    private final ConnectionPool pool;
    private final ConnectionGCService connectionGCService;
    private final ScheduledThreadPoolExecutor taskScheduler;
    private static final long RUNNING_DELAY_FOR_NEW_POOL = 60000L;
    private static final long RUNNING_DELAY_FOR_YOUNG_POOL = 60000L;
    private static final long RUNNING_DELAY_FOR_OLD_POOL = 120000L;
    private static final long WAITING_FOR_READY_TIMEOUT = 60000L;
    private static final long DEFAULT_THREAD_POOL_RUNNING_DELAY = 60000L;

    public ConnectionGC(ConnectionGCService connectionGCService, @Qualifier(value="connectionHistoryServiceImp") ConnectionHistoryService connectionHistoryService) {
        this.connectionGCService = connectionGCService;
        this.pool = new ConnectionPool(connectionHistoryService, log);
        this.taskScheduler = new ScheduledThreadPoolExecutor(5);
        this.taskScheduler.setThreadFactory((ThreadFactory)new CustomizableThreadFactory("GarbageCollector[Connection]-"));
    }

    public void start(Criteria<ConnectionForGC> criteria) {
        this.criteria = criteria;
        List allConnections = this.connectionGCService.getAllConnections();
        List<ConnectionForGC> forGC = allConnections.stream().filter(c -> !criteria.test(c)).toList();
        this.pool.initialize(forGC.stream().map(c -> c.getConnection().getId()).toList());
        this.startInnerTasks();
        this.ready.set(true);
        log.info("GarbageCollector[Connection] is ready to use");
    }

    private void startInnerTasks() {
        this.taskScheduler.scheduleWithFixedDelay(() -> this.locateNewConnections(), 60000L, 60000L, TimeUnit.MILLISECONDS);
        this.taskScheduler.scheduleWithFixedDelay(() -> this.newGC(), 60000L, 60000L, TimeUnit.MILLISECONDS);
        this.taskScheduler.scheduleWithFixedDelay(() -> this.youngGC(), 60000L, 60000L, TimeUnit.MILLISECONDS);
        this.taskScheduler.scheduleWithFixedDelay(() -> this.oldGC(), 120000L, 120000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locateNewConnections() {
        ConnectionGCService connectionGCService = this.connectionGCService;
        synchronized (connectionGCService) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                List allConnectionIds = this.pool.getAllInPool();
                List connections = allConnectionIds.isEmpty() ? this.connectionGCService.getAllConnections() : this.connectionGCService.getAllConnectionsNotContains(allConnectionIds);
                if (connections == null || connections.isEmpty()) {
                    return;
                }
                for (ConnectionForGC connection : connections) {
                    if (this.criteria.test((Object)connection)) continue;
                    this.pool.allocate(connection.getConnection().getId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newGC() {
        ConnectionGCService connectionGCService = this.connectionGCService;
        synchronized (connectionGCService) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                List newElements = this.pool.getNewElements();
                for (Long id : newElements) {
                    if (this.connectionGCService.exists(id)) {
                        ConnectionForGC connection = this.connectionGCService.getById(id);
                        if (this.criteria.test((Object)connection)) {
                            this.pool.evictFromNewPool((Object)id);
                            log.info("Connection[id = {}] is unmarked by GarbageCollector. Because it matches the criteria.", (Object)id);
                            this.pool.logTotalElements();
                            continue;
                        }
                        this.pool.reconsiderNewPool(id);
                        continue;
                    }
                    this.pool.evictFromNewPool((Object)id);
                    log.info("Connection[id = {}] is unmarked by GarbageCollector. Because it is not exist in db.", (Object)id);
                    this.pool.logTotalElements();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void youngGC() {
        ConnectionGCService connectionGCService = this.connectionGCService;
        synchronized (connectionGCService) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                List youngElements = this.pool.getYoungElements();
                for (Long id : youngElements) {
                    if (this.connectionGCService.exists(id)) {
                        ConnectionForGC connection = this.connectionGCService.getById(id);
                        if (this.criteria.test((Object)connection)) {
                            this.pool.evictFromYoungPool((Object)id);
                            log.info("Connection[id = {}] is unmarked by GarbageCollector. Because it matches the criteria.", (Object)id);
                            this.pool.logTotalElements();
                            continue;
                        }
                        this.pool.reconsiderYoungPool(id);
                        continue;
                    }
                    this.pool.evictFromYoungPool((Object)id);
                    log.info("Connection[id = {}] is unmarked by GarbageCollector. Because it is not exist in db.", (Object)id);
                    this.pool.logTotalElements();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void oldGC() {
        ConnectionGCService connectionGCService = this.connectionGCService;
        synchronized (connectionGCService) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                List oldElements = this.pool.getOldElements();
                for (Long id : oldElements) {
                    if (this.connectionGCService.exists(id)) {
                        ConnectionForGC connection = this.connectionGCService.getById(id);
                        if (this.criteria.test((Object)connection)) {
                            this.pool.evictFromOldPool((Object)id);
                            log.info("Connection[id = {}] is unmarked by GarbageCollector. Because it matches the criteria.", (Object)id);
                            this.pool.logTotalElements();
                            continue;
                        }
                        this.pool.reconsiderOldPool(id);
                        continue;
                    }
                    this.pool.evictFromOldPool((Object)id);
                    log.info("Connection[id = {}] is unmarked by GarbageCollector. Because it is not exist in db.", (Object)id);
                    this.pool.logTotalElements();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sweep() {
        if (!this.ready.get()) {
            try {
                Thread.sleep(60000L);
                if (!this.ready.get()) {
                    return;
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
        ConnectionGCService connectionGCService = this.connectionGCService;
        synchronized (connectionGCService) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                List elementsToBeDeleted = this.pool.getElementsToBeDeleted();
                for (Long id : elementsToBeDeleted) {
                    if (!this.connectionGCService.exists(id)) {
                        log.info("Connection[id = {}] is unmarked by GarbageCollector. Because it is not exist in db.", (Object)id);
                        this.pool.logTotalElements();
                        continue;
                    }
                    ConnectionForGC connection = this.connectionGCService.getById(id);
                    if (!this.criteria.test((Object)connection)) {
                        this.connectionGCService.deleteById(id);
                        log.info("Connection[id = {}] is deleted by GarbageCollector", (Object)id);
                        this.pool.logTotalElements();
                        continue;
                    }
                    log.info("Connection[id = {}] is unmarked by GarbageCollector. Because it matches the criteria", (Object)id);
                    this.pool.logTotalElements();
                }
            }
        }
    }

    public void changeCriteria(Criteria<ConnectionForGC> newCriteria) {
        this.criteria = newCriteria;
    }

    public void stop() {
        this.taskScheduler.shutdownNow();
        this.ready.set(false);
        log.info("GarbageCollector[Connection] has stopped");
    }
}

