/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.gc.base;

import com.becon.opencelium.backend.gc.base.Pool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public abstract class Pool<T> {
    protected Map<T, PoolObj> newPool = new ConcurrentHashMap();
    protected Map<T, PoolObj> youngPool = new ConcurrentHashMap();
    protected Map<T, PoolObj> oldPool = new ConcurrentHashMap();
    protected List<T> toDeletePool = new ArrayList();
    protected static final long NEW_POOL_LIFE_TIME = 120000L;
    protected static final long YOUNG_POOL_LIFE_TIME = 240000L;
    protected static final long OLD_POOL_LIFE_TIME = 480000L;
    protected static final int YOUNG_POOL_MAX_FAIRNESS = 2;

    public abstract void initialize(List<T> var1);

    public abstract void allocate(T var1);

    public abstract void reconsiderNewPool(T var1);

    public abstract void reconsiderYoungPool(T var1);

    public abstract void reconsiderOldPool(T var1);

    public List<T> getAllInPool() {
        return Stream.concat(Stream.concat(this.newPool.keySet().stream(), this.youngPool.keySet().stream()), Stream.concat(this.toDeletePool.stream(), this.oldPool.keySet().stream())).toList();
    }

    public List<T> getNewElements() {
        return this.newPool.keySet().stream().toList();
    }

    public List<T> getYoungElements() {
        return this.youngPool.keySet().stream().toList();
    }

    public List<T> getOldElements() {
        return this.oldPool.keySet().stream().toList();
    }

    public List<T> getElementsToBeDeleted() {
        List toDelete = this.toDeletePool;
        this.toDeletePool = new ArrayList();
        return toDelete;
    }

    public void evictFromNewPool(T element) {
        this.newPool.remove(element);
    }

    public void evictFromYoungPool(T element) {
        this.youngPool.remove(element);
    }

    public void evictFromOldPool(T element) {
        this.oldPool.remove(element);
    }
}

