/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.supportfile;

import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.service.ConnectionService;
import com.becon.opencelium.backend.database.mysql.service.ConnectorService;
import com.becon.opencelium.backend.enums.SupportFileStatus;
import com.becon.opencelium.backend.execution.socket.WebSocketNotificationService;
import com.becon.opencelium.backend.execution.supportfile.SupportFile;
import com.becon.opencelium.backend.execution.supportfile.SupportFileService;
import com.becon.opencelium.backend.invoker.service.InvokerService;
import com.becon.opencelium.backend.resource.connection.ConnectionDTO;
import com.becon.opencelium.backend.resource.template.TemplateResource;
import com.becon.opencelium.backend.template.service.TemplateService;
import com.becon.opencelium.backend.utility.LogFileUtility;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SupportFileServiceImp
implements SupportFileService {
    private final ConnectionService connectionSqlService;
    private final TemplateService templateService;
    private final ConnectorService connectorSqlService;
    private final InvokerService invokerService;
    private final WebSocketNotificationService notificationService;
    private final String base;
    private final int supportFileSuccessLimit;
    private final int supportFileFailLimit;
    public static final String GET_URL = "/connection/support-file/%d/%s";
    private static final Logger logger = LoggerFactory.getLogger(SupportFileService.class);

    public SupportFileServiceImp(ConnectionService connectionSqlService, TemplateService templateService, ConnectorService connectorSqlService, InvokerService invokerService, WebSocketNotificationService notificationService, Environment env) {
        this.connectionSqlService = connectionSqlService;
        this.templateService = templateService;
        this.connectorSqlService = connectorSqlService;
        this.invokerService = invokerService;
        this.notificationService = notificationService;
        this.base = (String)env.getProperty("opencelium.support.file.directory", String.class, (Object)"src/main/resources/support-files");
        this.supportFileSuccessLimit = (Integer)env.getProperty("opencelium.support.file.limit.success", Integer.class, (Object)1);
        this.supportFileFailLimit = (Integer)env.getProperty("opencelium.support.file.limit.fail", Integer.class, (Object)5);
    }

    @PostConstruct
    public void setup() {
        try {
            LogFileUtility.create((String)this.base);
            LogFileUtility.create((String)"./logs");
            logger.info("Base folders have been setup for support and log files.");
        }
        catch (IOException e) {
            logger.error("Failed to setup base folder for support and log files.");
        }
    }

    @Transactional(readOnly=true)
    public List<SupportFile> supportFileList() {
        Path path = LogFileUtility.toPath((String)this.base, (String[])new String[0]);
        ArrayList<SupportFile> result = new ArrayList<SupportFile>();
        try (Stream<Path> files = Files.list(path);){
            files.forEach(file -> {
                String fileName = file.getFileName().toString();
                if (Files.isDirectory(file, new LinkOption[0]) && fileName.matches("\\d+")) {
                    String message;
                    SupportFileStatus status;
                    String connectionTitle;
                    Long connectionId = Long.parseLong(fileName);
                    List urls = this.getZipUrls(connectionId, file);
                    if (this.connectionSqlService.existsById(connectionId)) {
                        Connection connection = this.connectionSqlService.getById(connectionId);
                        connectionTitle = connection.getTitle();
                        status = SupportFileStatus.CONNECTION_FOUND;
                        message = "Connection is found.";
                    } else {
                        connectionTitle = null;
                        status = SupportFileStatus.CONNECTION_IS_MISSING;
                        message = "Connection not found.";
                    }
                    urls.forEach(url -> result.add(new SupportFile(connectionId, connectionTitle, url, status, message)));
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public List<SupportFile> connectionSupportFileList(Long connectionId) {
        Path path = LogFileUtility.toPath((String)this.base, (String[])new String[]{connectionId.toString()});
        ArrayList<SupportFile> result = new ArrayList<SupportFile>();
        if (Files.isDirectory(path, new LinkOption[0])) {
            String message;
            SupportFileStatus status;
            String connectionTitle;
            List urls = this.getZipUrls(connectionId, path);
            if (this.connectionSqlService.existsById(connectionId)) {
                Connection connection = this.connectionSqlService.getById(connectionId);
                connectionTitle = connection.getTitle();
                status = SupportFileStatus.CONNECTION_FOUND;
                message = "Connection is found.";
            } else {
                connectionTitle = null;
                status = SupportFileStatus.CONNECTION_IS_MISSING;
                message = "Connection not found.";
            }
            urls.forEach(url -> result.add(new SupportFile(connectionId, connectionTitle, url, status, message)));
        }
        return result;
    }

    public File getSupportFile(Long connectionId, String zipFileName) {
        Path path = LogFileUtility.toPath((String)this.base, (String[])new String[]{connectionId.toString(), zipFileName});
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return path.toFile();
        }
        throw new RuntimeException("Support file with name ='" + zipFileName + "' not found");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File getSupportFile(Long connectionId) {
        String filePattern = "*_" + connectionId + "_s_*.zip";
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(LogFileUtility.toPath((String)this.base, (String[])new String[]{connectionId.toString()}), filePattern);){
            Iterator<Path> iterator = stream.iterator();
            if (!iterator.hasNext()) throw new RuntimeException("Support file for successful execution not found for connectionId = " + connectionId);
            Path path = iterator.next();
            File file = path.toFile();
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Transactional(readOnly=true)
    public void collectFiles(Long connectionId, long executionId, String timestamp, String type) {
        int fileLimit;
        String zipFilename = LogFileUtility.toFilename((String)timestamp, (long)connectionId, (String)type, (long)executionId, (String)"zip");
        Path zipFilePath = LogFileUtility.toPath((String)this.base, (String[])new String[]{connectionId.toString(), zipFilename});
        try {
            Files.createDirectories(zipFilePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Failed to create support file directory connectionId = '" + connectionId + "'");
            throw new RuntimeException(e);
        }
        String connectionTitle = null;
        try {
            try (FileOutputStream fos = new FileOutputStream(zipFilePath.toFile());
                 ZipOutputStream zipOutputStream = new ZipOutputStream(fos);){
                ConnectionDTO dto = this.connectionSqlService.getFullConnection(connectionId);
                TemplateResource template = this.templateService.getByConnectionId(connectionId);
                connectionTitle = template.getName();
                this.addToZip(zipOutputStream, (Object)template, "connection_template.json");
                int fromConnectorId = dto.getFromConnector().getConnectorId();
                Connector fromConnector = this.connectorSqlService.getById(Integer.valueOf(fromConnectorId));
                File fromInvoker = this.invokerService.findFileByInvokerName(fromConnector.getInvoker());
                this.addToZip(zipOutputStream, fromInvoker, fromConnector.getInvoker() + ".xml");
                int toConnectorId = dto.getToConnector().getConnectorId();
                if (fromConnectorId != toConnectorId) {
                    Connector toConnector = this.connectorSqlService.getById(Integer.valueOf(toConnectorId));
                    File toInvoker = this.invokerService.findFileByInvokerName(toConnector.getInvoker());
                    this.addToZip(zipOutputStream, toInvoker, toConnector.getInvoker() + ".xml");
                }
                Path filePath = LogFileUtility.toPath((String)"./logs", (String[])new String[]{LogFileUtility.toFilename((String)timestamp, (long)connectionId, (String)"u", (long)executionId, (String)"log")});
                this.addToZip(zipOutputStream, filePath.toFile(), LogFileUtility.toFilename((String)timestamp, (long)connectionId, (String)type, (long)executionId, (String)"log"));
                LogFileUtility.delete((Path)filePath);
                String filename = LogFileUtility.toFilename((String)timestamp, (long)connectionId, (String)type, (long)executionId, (String)"zip");
                String message = "Support file successfully generated.";
                SupportFile notification = new SupportFile(connectionId, connectionTitle, filename, SupportFileStatus.SUPPORT_FILE_GENERATED, message);
                this.notificationService.send("/execution/support-file", (Object)notification);
            }
            fileLimit = "s".equals(type) ? this.supportFileSuccessLimit : this.supportFileFailLimit;
        }
        catch (Exception e) {
            try {
                String message = "Support file generation failed: " + e.getMessage();
                SupportFile notification = new SupportFile(connectionId, connectionTitle, null, SupportFileStatus.SUPPORT_FILE_FAILED, message);
                this.notificationService.send("/execution/support-file", (Object)notification);
                logger.error("Failed to create support file for connectionId = '" + connectionId + "'");
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                int fileLimit2 = "s".equals(type) ? this.supportFileSuccessLimit : this.supportFileFailLimit;
                LogFileUtility.enforceLimit((String)this.base, (Long)connectionId, (String)type, (int)fileLimit2);
                throw throwable;
            }
        }
        LogFileUtility.enforceLimit((String)this.base, (Long)connectionId, (String)type, (int)fileLimit);
    }

    public void deleteSupportFile(String zipFilename) {
        String dateRemoved = zipFilename.substring(17);
        String connectionId = dateRemoved.substring(0, dateRemoved.indexOf(95));
        Path zipPath = LogFileUtility.toPath((String)this.base, (String[])new String[]{connectionId, zipFilename});
        try {
            LogFileUtility.delete((Path)zipPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getZipUrls(Long connectionId, Path directory) {
        ArrayList<String> arrayList;
        block8: {
            ArrayList<String> names = new ArrayList<String>();
            DirectoryStream<Path> zips = Files.newDirectoryStream(directory, "*.zip");
            try {
                zips.forEach(zip -> {
                    if (Files.isRegularFile(zip, new LinkOption[0])) {
                        names.add(String.format(GET_URL, connectionId, zip.getFileName().toString()));
                    }
                });
                arrayList = names;
                if (zips == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (zips != null) {
                        try {
                            zips.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            zips.close();
        }
        return arrayList;
    }

    private void addToZip(ZipOutputStream zipOutputStream, Object object, String zipEntryName) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        byte[] jsonBytes = objectMapper.writeValueAsBytes(object);
        ZipEntry zipEntry = new ZipEntry(zipEntryName);
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(jsonBytes);
        zipOutputStream.closeEntry();
    }

    private void addToZip(ZipOutputStream zipOutputStream, File file, String zipEntryName) throws IOException {
        if (file == null || !file.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            int length;
            ZipEntry zipEntry = new ZipEntry(zipEntryName);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) > 0) {
                zipOutputStream.write(buffer, 0, length);
            }
            zipOutputStream.closeEntry();
        }
    }
}

