/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.socket;

import com.becon.opencelium.backend.execution.socket.WebSocketNotificationService;
import com.becon.opencelium.backend.execution.socket.WebSocketUserSubscriptionRegistry;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.stereotype.Component;

@Component
public class WebSocketNotificationQueue {
    private final Map<String, Queue<Object>> destinationMessages = new ConcurrentHashMap();
    private final WebSocketUserSubscriptionRegistry subscriptionRegistry;
    private final WebSocketNotificationService notificationService;

    public WebSocketNotificationQueue(WebSocketUserSubscriptionRegistry subscriptionRegistry, WebSocketNotificationService notificationService) {
        this.subscriptionRegistry = subscriptionRegistry;
        this.notificationService = notificationService;
    }

    public void addMessage(String destination, Object message) {
        this.destinationMessages.computeIfAbsent(destination, dest -> new ConcurrentLinkedQueue()).offer(message);
        while (this.subscriptionRegistry.hasSubscription(destination) && this.hasMessage(destination)) {
            this.notificationService.send(destination, this.getMessage(destination));
        }
    }

    public Object getMessage(String destination) {
        Queue messages = (Queue)this.destinationMessages.get(destination);
        return messages != null ? messages.poll() : null;
    }

    public boolean hasMessage(String destination) {
        Queue queue = (Queue)this.destinationMessages.get(destination);
        return queue != null && !queue.isEmpty();
    }

    public void check(String destination) {
        while (this.subscriptionRegistry.hasSubscription(destination) && this.hasMessage(destination)) {
            this.notificationService.send(destination, this.getMessage(destination));
        }
    }
}

