/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.oc721;

import com.becon.opencelium.backend.enums.PageParam;
import com.becon.opencelium.backend.enums.execution.DataType;
import com.becon.opencelium.backend.execution.ExecutionManager;
import com.becon.opencelium.backend.execution.oc721.Extractor;
import com.becon.opencelium.backend.execution.oc721.Loop;
import com.becon.opencelium.backend.execution.oc721.Operation;
import com.becon.opencelium.backend.execution.oc721.ReferenceExtractor;
import com.becon.opencelium.backend.resource.execution.ResponseEx;
import com.becon.opencelium.backend.utility.MediaTypeUtility;
import com.becon.opencelium.backend.utility.ReferenceUtility;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReferenceExtractor
implements Extractor {
    private final ExecutionManager executionManager;

    public ReferenceExtractor(ExecutionManager executionManager) {
        this.executionManager = executionManager;
    }

    public Object extractValue(String ref) {
        Object result = null;
        try {
            if (ref.matches("#[a-zA-Z0-9]{6}\\.(\\(response\\)|\\(request\\))\\..+") || ref.matches("\\{%#[a-zA-Z0-9]{6}\\.(\\(response\\)|\\(request\\))\\..+\\%}")) {
                ref = ReferenceUtility.extractDirectRef((String)ref);
                result = this.extractFromOperation(ref);
            } else if (ref.matches("#\\{%[0-9a-fA-F]{24}%\\}")) {
                String bindId = ref.replace("#{%", "").replace("%}", "");
                result = this.executionManager.executeScript(bindId);
            } else if (ref.matches("\\$\\{(.*?)\\}")) {
                result = this.extractFromWebhook(ref);
            } else if (ref.matches("@\\{([^}]+)\\}")) {
                String param = ref.replace("@{", "").replace("}", "");
                result = this.executionManager.getPaginationParamValue(PageParam.fromString((String)param));
            } else if (ref.matches("\\{(?!%)(.*?)(?<!%)\\}")) {
                String refValue = ref.replace("{", "").replace("}", "");
                Integer ctorId = null;
                if (refValue.startsWith("#")) {
                    ctorId = Integer.valueOf(refValue.substring(1, refValue.indexOf(".")));
                    refValue = refValue.substring(refValue.indexOf(".") + 1);
                }
                result = this.executionManager.getRequestData(ctorId).getOrDefault(refValue, ref);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Reference = " + ref, e);
        }
    }

    private Object extractFromWebhook(String ref) {
        Map webhookVars = this.executionManager.getWebhookVars();
        if (webhookVars == null || webhookVars.isEmpty()) {
            return null;
        }
        DataType type = DataType.UNDEFINED;
        if (ref.contains(":")) {
            type = DataType.fromString((String)ref.split(":")[1].replace("}", ""));
            ref = ref.split(":")[0].concat("}");
        }
        Object value = null;
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(ref);
        if (matcher.find()) {
            String paths = matcher.group().replace("${", "").replace("}", "");
            value = this.getFromJSON((Object)webhookVars, paths);
        }
        return this.mapToType(value, type);
    }

    private Object mapToType(Object value, DataType type) {
        if (value == null) {
            return null;
        }
        String stringValue = value.toString();
        return switch (1.$SwitchMap$com$becon$opencelium$backend$enums$execution$DataType[type.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> Long.parseLong(stringValue);
            case 2 -> Boolean.parseBoolean(stringValue);
            case 3 -> Double.parseDouble(stringValue);
            case 4 -> stringValue.replace("[", "").replace("]", "").replace("'", "");
            case 5 -> {
                String cleanedString = stringValue.replace("[", "").replace("]", "").replace("\"", "").replace("'", "").trim();
                if (cleanedString.isEmpty()) {
                    yield Collections.emptyList();
                }
                yield Arrays.asList(cleanedString.split("\\s*,\\s*"));
            }
            case 6, 7 -> value;
        };
    }

    private Object extractFromOperation(String ref) {
        String part;
        HttpEntity entity;
        String color = ref.substring(0, 7);
        Operation operation = (Operation)this.executionManager.findOperationByColor(color).orElseThrow(() -> new RuntimeException("There is no Operation with '" + color + "'"));
        if ("[*]".equals(ref.substring(19, 22))) {
            if (ref.length() == 22) {
                TreeMap responses = new TreeMap(ReferenceExtractor.getComparator());
                operation.getResponses().forEach((K, V) -> responses.put(K, ResponseEx.of((ResponseEntity)V)));
                return responses;
            }
            String part2 = ref.substring(23);
            if (part2.equals("status")) {
                TreeMap statuses = new TreeMap(ReferenceExtractor.getComparator());
                operation.getResponses().forEach((K, V) -> statuses.put(K, V.getStatusCode().value()));
                return statuses;
            }
            if (part2.equals("header")) {
                TreeMap headers = new TreeMap(ReferenceExtractor.getComparator());
                operation.getResponses().forEach((K, V) -> headers.put(K, V.getHeaders()));
                return headers;
            }
            if (part2.equals("body")) {
                TreeMap bodies = new TreeMap(ReferenceExtractor.getComparator());
                operation.getResponses().forEach((K, V) -> bodies.put(K, V.getBody()));
                return bodies;
            }
        }
        String key = this.executionManager.generateKey(operation.getLoopDepth());
        if ("status".equals(ref.substring(19, 25))) {
            return ((ResponseEntity)operation.getResponses().get(key)).getStatusCode().value();
        }
        String exchangeType = ReferenceUtility.extractExchangeType((String)ref);
        String path = ref.substring(ref.indexOf(36) + 2);
        if (exchangeType.equals("response")) {
            entity = (HttpEntity)operation.getResponses().get(key);
            part = ref.substring(19, ref.indexOf(36) - 1);
        } else {
            entity = (HttpEntity)operation.getRequests().get(key);
            part = ref.substring(18, ref.indexOf(36) - 1);
        }
        if ("header".equals(part)) {
            return entity.getHeaders().get((Object)path);
        }
        Object body = entity.getBody();
        MediaType mediaType = entity.getHeaders().getContentType();
        if (MediaTypeUtility.isJsonCompatible((MediaType)mediaType)) {
            return this.getFromJSON(body, path);
        }
        if (MediaTypeUtility.isXmlCompatible((MediaType)mediaType)) {
            return this.getFromXML(body, path);
        }
        return ReferenceExtractor.bodyToString((Object)body);
    }

    public static String bodyToString(Object body) {
        if (body instanceof String) {
            String result = (String)body;
            return result;
        }
        try {
            return new ObjectMapper().writer().withDefaultPrettyPrinter().writeValueAsString(body);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object getFromJSON(Object body, String paths) {
        ArrayList result = body;
        int partCount = 0;
        for (String path : ReferenceUtility.splitPaths((String)paths)) {
            Loop loop;
            Loop loop2;
            String match;
            ++partCount;
            if (path.isEmpty()) continue;
            path = path.replace("[]", "[*]");
            Pattern pattern = Pattern.compile("\\['(.*?)\\']~");
            Matcher matcher = pattern.matcher(path);
            if (matcher.find()) {
                match = matcher.group(1);
                if (Loop.isIterator((String)match)) {
                    loop2 = this.getLoopByIterator(match);
                    return loop2.getValue();
                }
                if ("*".equals(match)) {
                    Object currentBody = this.getFromJSON((Object)body, ReferenceUtility.getPointerToBody((String)paths, (int)partCount, (String)matcher.group(0)));
                    return this.getFieldNames(currentBody);
                }
                return match;
            }
            pattern = Pattern.compile("\\['(.*?)\\']");
            matcher = pattern.matcher(path);
            while (matcher.find()) {
                String fieldName;
                match = matcher.group(1);
                if (Loop.isIterator((String)match)) {
                    loop = this.getLoopByIterator(match);
                    fieldName = loop.getValue();
                } else {
                    fieldName = match;
                }
                path = path.replace("['" + match + "']", "['" + fieldName + "']");
            }
            pattern = Pattern.compile("\\[([a-z0-9*]+)\\]~");
            matcher = pattern.matcher(path);
            while (matcher.find()) {
                int index;
                match = matcher.group(1);
                if (Loop.isIterator((String)match)) {
                    loop2 = this.getLoopByIterator(match);
                    return loop2.getValue();
                }
                if ("*".equals(match)) {
                    loop2 = this.getLoopByReference(paths);
                    ArrayList strs = new ArrayList();
                    Collections.addAll(strs, ((String)((Object)result)).split(loop2.getDelimiter()));
                    result = strs;
                    continue;
                }
                try {
                    index = Integer.parseInt(match);
                }
                catch (Exception e) {
                    throw new RuntimeException("Wrong index is supplied to a SPLIT STRING operator, 'index' = " + match);
                }
                loop = this.getLoopByReference(paths);
                return ((String)((Object)result)).split(loop.getDelimiter())[index];
            }
            pattern = Pattern.compile("\\[([a-z])\\]");
            matcher = pattern.matcher(path);
            while (matcher.find()) {
                String iterator = matcher.group(1);
                loop2 = this.getLoopByIterator(iterator);
                path = path.replace("[" + iterator + "]", "[" + loop2.getValue() + "]");
            }
            String jsonPath = (result instanceof List && !path.startsWith("[") ? "$[*]." : "$.") + path;
            result = JsonPath.read((String)ReferenceExtractor.bodyToString((Object)result), (String)jsonPath, (Predicate[])new Predicate[0]);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Object getFromXML(Object body, String paths) {
        paths = paths.replaceFirst("\\$", "");
        Object xpathQuery = "/";
        boolean hasLoop = !this.executionManager.getLoops().isEmpty();
        for (String string : ReferenceUtility.splitPaths((String)paths)) {
            void var8_19;
            if (string.isEmpty()) continue;
            String string2 = string.contains(":") ? string.split(":")[1] : string;
            Pattern pattern = Pattern.compile("\\[([a-z,*]+)\\]");
            Matcher m = pattern.matcher(string2);
            boolean hasIndex = false;
            String iterator = "";
            while (m.find()) {
                hasIndex = true;
                iterator = m.group(1);
            }
            if ((string2.contains("[]") || hasIndex) && hasLoop) {
                void var8_16;
                String string3 = string2.replace("[]", "");
                if (hasIndex) {
                    String string4 = string3.replace("[" + iterator + "]", "");
                }
                String string5 = (String)var8_16 + "[" + (this.getLoopByIterator(iterator).getIndex() + 1) + "]";
            } else if ((string2.contains("[]") || string2.contains("[*]")) && !hasLoop) {
                String string6 = string2.contains("[*]") ? string2 : string2.replace("[]", "") + "[*]";
            }
            xpathQuery = (String)xpathQuery + "/" + (String)var8_19;
        }
        xpathQuery = ((String)xpathQuery).replace("/__oc__value", "");
        xpathQuery = ((String)xpathQuery).replace("/__oc__attributes", "");
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            List<String> cpart = Arrays.asList(((String)xpathQuery).split("/"));
            String lastElem = cpart.get(cpart.size() - 1);
            if (!(lastElem.contains("@") || lastElem.contains("[*]") || lastElem.contains("[]"))) {
                xpathQuery = (String)xpathQuery + "/text()";
            }
            String string = (String)body;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xmlDocument = builder.parse(new InputSource(new StringReader(string)));
            NodeList nodeList = (NodeList)xpath.compile((String)xpathQuery).evaluate(xmlDocument, XPathConstants.NODESET);
            ArrayList<String> result = new ArrayList<String>();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Node node = nodeList.item(j);
                result.add(node.getNodeValue());
            }
            if (result.isEmpty()) {
                return "";
            }
            if (result.size() == 1) {
                return result.get(0);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Loop getLoopByIterator(String iterator) {
        return this.executionManager.getLoops().stream().filter(loop -> Objects.equals(loop.getIterator(), iterator)).findFirst().orElseThrow(() -> new RuntimeException("Wrong 'iterator' value is supplied"));
    }

    private Loop getLoopByReference(String reference) {
        return this.executionManager.getLoops().stream().filter(loop -> ReferenceUtility.equals((String)loop.getRef(), (String)reference)).findFirst().orElseThrow(() -> new RuntimeException("Wrong 'reference' value is supplied"));
    }

    private List<String> getFieldNames(Object body) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ObjectMapper mapper = new ObjectMapper();
            String jsonObject = mapper.writeValueAsString(body);
            Iterator fieldNames = mapper.readTree(jsonObject).fieldNames();
            while (fieldNames.hasNext()) {
                result.add((String)fieldNames.next());
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private static Comparator<String> getComparator() {
        return (idx1, idx2) -> {
            String[] arr1 = idx1.split(", ");
            String[] arr2 = idx2.split(", ");
            for (int i = 0; i < arr1.length && i < arr2.length; ++i) {
                if (Objects.equals(arr1[i], arr2[i])) continue;
                return Integer.parseInt(arr1[i]) - Integer.parseInt(arr2[i]);
            }
            return arr1.length - arr2.length;
        };
    }
}

