/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.service;

import com.becon.opencelium.backend.database.mongodb.entity.LogDataMng;
import com.becon.opencelium.backend.database.mongodb.repository.MetaDataLogRepository;
import com.becon.opencelium.backend.execution.logger.dto.LogDataDTO;
import com.becon.opencelium.backend.execution.logger.enums.LogDetailLevel;
import com.becon.opencelium.backend.execution.logger.enums.PhaseCategory;
import com.becon.opencelium.backend.execution.logger.enums.PhaseType;
import com.becon.opencelium.backend.execution.logger.keys.LogLineKey;
import com.becon.opencelium.backend.execution.logger.mapper.LogDataMapper;
import com.becon.opencelium.backend.execution.logger.parser.FlexiblePatternLogParser;
import com.becon.opencelium.backend.execution.logger.parser.ParsedLogLineBuilder;
import com.becon.opencelium.backend.execution.logger.parser.entity.ParsedLogLine;
import com.becon.opencelium.backend.execution.logger.service.LogDataService;
import com.becon.opencelium.backend.execution.logger.service.LogDataServiceImp;
import com.becon.opencelium.backend.execution.logger.tracker.ExecutionTrackerImpl;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LogDataServiceImp
implements LogDataService {
    private static final Set<LogLineKey> EXCLUDED_KEYS = Set.of(LogLineKey.TIMESTAMP, LogLineKey.LOG_LEVEL, LogLineKey.MESSAGE, LogLineKey.SEGMENT, LogLineKey.PHASE, LogLineKey.INDEX_PATH, LogLineKey.FLOWCHART_ID);
    private static final Sort SORT_ASCENDING = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"createdAt"});
    private static final Sort SORT_DESCENDING = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdAt"});
    @Autowired
    private MetaDataLogRepository metaDataLogRepository;
    @Autowired
    private FlexiblePatternLogParser flexiblePatternLogParser;
    @Autowired
    private LogDataMapper logDataMapper;
    @Autowired
    private ParsedLogLineBuilder parsedLogLineBuilder;

    public List<LogDataDTO> getChildrenById(String elementId, String loopIndex) {
        String id = this.findElementId(elementId);
        LogDataMng entity = this.findByIdElseThrow(id);
        List children = switch (1.$SwitchMap$com$becon$opencelium$backend$execution$logger$enums$PhaseCategory[entity.getType().ordinal()]) {
            case 1 -> this.executionChildren(entity);
            case 2 -> this.flowchartChildren(entity);
            case 3 -> this.ifChildren(entity);
            case 4 -> this.loopChildren(entity, loopIndex);
            default -> List.of();
        };
        Comparator byIndexPathNumeric = (a, b) -> LogDataServiceImp.compareIndexPath((String)a.getIndexPath(), (String)b.getIndexPath());
        Comparator<LogDataMng> byStartOffset = Comparator.comparing(LogDataMng::getStartOffset, Comparator.nullsLast(Long::compareTo));
        return children.stream().sorted(byIndexPathNumeric.thenComparing(byStartOffset)).map(arg_0 -> ((LogDataMapper)this.logDataMapper).toDto(arg_0)).toList();
    }

    private static int compareIndexPath(String a, String b) {
        List la = LogDataServiceImp.parseIndexPath((String)a);
        List lb = LogDataServiceImp.parseIndexPath((String)b);
        int n = Math.min(la.size(), lb.size());
        for (int i = 0; i < n; ++i) {
            int c = Integer.compare((Integer)la.get(i), (Integer)lb.get(i));
            if (c == 0) continue;
            return c;
        }
        return Integer.compare(la.size(), lb.size());
    }

    private static List<Integer> parseIndexPath(String s) {
        if (s == null || s.isBlank()) {
            return List.of();
        }
        String[] parts = s.split("\\D+");
        ArrayList<Integer> out = new ArrayList<Integer>(parts.length);
        for (String p : parts) {
            if (p.isEmpty()) continue;
            out.add(Integer.parseInt(p));
        }
        return out;
    }

    private String findElementId(String elementId) {
        return this.metaDataLogRepository.findByExecutionIdAndType(elementId, PhaseCategory.EXECUTION.name()).map(LogDataMng::getId).orElse(elementId);
    }

    public LogDataDTO getDetailsById(String elementId) {
        LogDataMng entity = this.findByIdElseThrow(elementId);
        PhaseCategory type = entity.getType();
        String executionId = entity.getExecutionId();
        Long connectionId = entity.getConnectionId();
        String flowchartId = entity.getFlowId();
        long startOffset = entity.getStartOffset();
        long endOffset = entity.getEndOffset();
        ArrayList lines = new ArrayList();
        if (type == PhaseCategory.FLOWCHART) {
            return this.logDataMapper.toDto(entity);
        }
        if (type == PhaseCategory.OPERATION) {
            lines.addAll(this.flexiblePatternLogParser.readLines(executionId, startOffset, endOffset));
        } else {
            String indexPath = entity.getIndexPath();
            String safeParent = Pattern.quote(indexPath);
            String regex = "^" + safeParent + "_[0-9]+(_[0-9]+)*$";
            Optional firstChild = this.metaDataLogRepository.findFirstByExecutionIdAndFlowIdAndIndexPathRegex(executionId, flowchartId, regex, SORT_ASCENDING);
            Optional lastChild = this.metaDataLogRepository.findFirstByExecutionIdAndFlowIdAndIndexPathRegex(executionId, flowchartId, regex, SORT_DESCENDING);
            if (firstChild.isPresent() && lastChild.isPresent()) {
                long firstChildStartOffset = ((LogDataMng)firstChild.get()).getStartOffset();
                long lastChildEndOffset = ((LogDataMng)lastChild.get()).getEndOffset();
                lines.addAll(this.flexiblePatternLogParser.readLines(executionId, startOffset, firstChildStartOffset));
                lines.addAll(this.flexiblePatternLogParser.readLines(executionId, lastChildEndOffset, endOffset));
            } else {
                lines.addAll(this.flexiblePatternLogParser.readLines(executionId, startOffset, endOffset));
            }
        }
        LogDataMng collected = this.collect(lines, executionId, connectionId, flowchartId);
        collected.setId(entity.getId());
        collected.setConnectionId(entity.getConnectionId());
        collected.setExecutionId(entity.getExecutionId());
        collected.setFlowId(entity.getFlowId());
        collected.setConnectorName(entity.getConnectorName());
        collected.setStatus(entity.getStatus());
        collected.setIndexPath(entity.getIndexPath());
        collected.setLogLineType(entity.getLogLineType());
        collected.setType(entity.getType());
        collected.setError(entity.getError());
        return this.logDataMapper.toDto(collected);
    }

    public void saveNewBlock(LogDataMng block) {
        block.setCreatedAt(Instant.now());
        this.metaDataLogRepository.save((Object)block);
    }

    public void updateExistingBlock(LogDataMng block) {
        Optional existing = this.findExistingBlock(block);
        if (existing.isEmpty()) {
            block.setCreatedAt(Instant.now());
            this.metaDataLogRepository.save((Object)block);
            return;
        }
        block.setId(((LogDataMng)existing.get()).getId());
        block.setCreatedAt(((LogDataMng)existing.get()).getCreatedAt());
        this.metaDataLogRepository.save((Object)block);
    }

    public void save(LogDataMng block) {
        switch (1.$SwitchMap$com$becon$opencelium$backend$execution$logger$enums$PhaseStatus[block.getStatus().ordinal()]) {
            case 1: {
                this.saveNewBlock(block);
                break;
            }
            case 2: 
            case 3: {
                this.updateExistingBlock(block);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected status: " + block.getStatus());
            }
        }
    }

    public Optional<LogDataDTO> toDto(LogDataMng logDataMng) {
        return Optional.of(this.logDataMapper.toDto(logDataMng));
    }

    public LogDataMng fromParsedLogLine(ParsedLogLine line, String executionId, Long connectionId, String flowchartId) {
        LogDataMng doc = new LogDataMng();
        doc.setExecutionId(executionId);
        doc.setConnectionId(connectionId);
        doc.setFlowId(flowchartId);
        doc.setIndexPath((String)line.getProperties().get(LogLineKey.INDEX_PATH));
        doc.setStartOffset(line.getStartOffset());
        doc.setEndOffset(Long.valueOf(line.getEndOffset()));
        doc.setLogLineType(line.getType());
        doc.setType(PhaseCategory.fromValue((PhaseType)((PhaseType)line.getStage())));
        LinkedHashMap props = new LinkedHashMap();
        for (Map.Entry entry : line.getProperties().entrySet()) {
            if (EXCLUDED_KEYS.contains(entry.getKey())) continue;
            props.put(((LogLineKey)entry.getKey()).name(), entry.getValue());
        }
        doc.setProperties(props);
        doc.setCreatedAt(Instant.now());
        return doc;
    }

    private Optional<LogDataMng> findExistingBlock(LogDataMng block) {
        if (block.getProperties().containsKey(LogLineKey.LOOP_INDEX.getSrcName())) {
            return this.metaDataLogRepository.findByExecutionConnectionFlowIdIndexPathAndLoopIndex(block.getConnectionId(), block.getExecutionId(), block.getFlowId(), block.getIndexPath(), block.getProperties().get(LogLineKey.LOOP_INDEX.getSrcName()).toString());
        }
        return this.metaDataLogRepository.findByConnectionIdAndExecutionIdAndFlowIdAndIndexPath(block.getConnectionId(), block.getExecutionId(), block.getFlowId(), block.getIndexPath());
    }

    private LogDataMng findByIdElseThrow(String phaseId) {
        return (LogDataMng)this.metaDataLogRepository.findById((Object)phaseId).or(() -> this.metaDataLogRepository.findByExecutionIdAndType(phaseId, PhaseCategory.EXECUTION.name())).or(() -> this.metaDataLogRepository.findByFlowIdAndType(phaseId, PhaseCategory.FLOWCHART.name())).orElseThrow(() -> new RuntimeException("LogData element not found with specified id = " + phaseId));
    }

    private LogDataMng collect(List<String> lines, String executionId, Long connectionId, String flowchartId) {
        String line;
        ParsedLogLine parsed;
        ExecutionTrackerImpl tracker = new ExecutionTrackerImpl(executionId, connectionId.toString(), flowchartId, LogDetailLevel.DETAILED);
        Optional result = Optional.empty();
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext() && !(result = tracker.buildLogData(parsed = this.parsedLogLineBuilder.build(line = iterator.next()))).isPresent()) {
        }
        return result.orElseGet(LogDataMng::new);
    }

    private List<LogDataMng> executionChildren(LogDataMng entity) {
        String executionId = entity.getExecutionId();
        return this.metaDataLogRepository.findChildren(executionId, PhaseCategory.FLOWCHART.name(), SORT_ASCENDING);
    }

    private List<LogDataMng> flowchartChildren(LogDataMng entity) {
        String executionId = entity.getExecutionId();
        String flowchartId = entity.getFlowId();
        String regex = "^[0-9]+$";
        return this.metaDataLogRepository.findChildren(executionId, flowchartId, regex, SORT_ASCENDING);
    }

    private List<LogDataMng> ifChildren(LogDataMng entity) {
        String executionId = entity.getExecutionId();
        String flowchartId = entity.getFlowId();
        String indexPath = entity.getIndexPath();
        String regex = "^" + Pattern.quote(indexPath) + "_[0-9]+$";
        String nearestLoopIndex = entity.getProperties().getOrDefault("loopIndex", "");
        if (nearestLoopIndex.isBlank()) {
            return this.metaDataLogRepository.findChildren(executionId, flowchartId, regex, SORT_ASCENDING);
        }
        return this.metaDataLogRepository.findChildren(executionId, flowchartId, regex, nearestLoopIndex, SORT_ASCENDING);
    }

    private List<LogDataMng> loopChildren(LogDataMng entity, String loopIndex) {
        String executionId = entity.getExecutionId();
        String flowchartId = entity.getFlowId();
        String indexPath = entity.getIndexPath();
        String regex = "^" + Pattern.quote(indexPath) + "_[0-9]+$";
        String nearestLoopIndex = entity.getProperties().getOrDefault("loopIndex", "");
        String currentLoopIndex = nearestLoopIndex.isBlank() ? loopIndex : nearestLoopIndex + "," + loopIndex;
        return this.metaDataLogRepository.findChildren(executionId, flowchartId, regex, currentLoopIndex, SORT_ASCENDING);
    }
}

