/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.msg;

import com.becon.opencelium.backend.enums.LogType;
import com.becon.opencelium.backend.execution.logger.LogMessage;
import com.becon.opencelium.backend.execution.logger.msg.ConnectorLog;
import com.becon.opencelium.backend.execution.logger.msg.MethodData;
import java.util.List;
import java.util.stream.Stream;

public class ExecutionLog
implements LogMessage {
    private String message;
    private LogType type = LogType.INFO;
    private List<String> stackTrace;
    private MethodData methodData;
    private ConnectorLog connector;

    public ExecutionLog() {
    }

    public ExecutionLog(String message) {
        this.message = message;
    }

    public ExecutionLog(Exception e) {
        this.message = e.getMessage();
        this.stackTrace = Stream.of(e.getStackTrace()).map(StackTraceElement::toString).toList();
    }

    public String getMessage() {
        return this.message;
    }

    public <M> void setMessage(M m) {
        if (m instanceof Exception) {
            this.message = ((Exception)m).getMessage();
            this.stackTrace = Stream.of(((Exception)m).getStackTrace()).map(StackTraceElement::toString).toList();
        } else {
            this.message = m == null ? "" : m.toString();
        }
    }

    public <M, T extends LogType> void setMessage(M m, T type) {
        this.type = type;
        this.setMessage(m);
    }

    public List<String> getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(List<String> stackTrace) {
        this.stackTrace = stackTrace;
    }

    public LogType getType() {
        return this.type;
    }

    public <T extends LogType> void setType(T type) {
        this.type = type;
    }

    public MethodData getMethodData() {
        return this.methodData;
    }

    public void setMethodData(MethodData methodData) {
        this.methodData = methodData;
    }

    public ConnectorLog getConnector() {
        return this.connector;
    }

    public void setConnector(ConnectorLog connector) {
        this.connector = connector;
    }
}

