/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.mapper;

import com.becon.opencelium.backend.database.mongodb.entity.LogDataError;
import com.becon.opencelium.backend.database.mongodb.entity.LogDataMng;
import com.becon.opencelium.backend.execution.logger.dto.ErrorInfoDTO;
import com.becon.opencelium.backend.execution.logger.dto.LogDataDTO;
import com.becon.opencelium.backend.execution.logger.keys.LogLineKey;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class LogDataMapper {
    public LogDataDTO toDto(LogDataMng src) {
        String key;
        LogDataDTO dto = new LogDataDTO();
        dto.setId(src.getId());
        dto.setExecutionId(src.getExecutionId());
        dto.setFlowId(src.getFlowId());
        dto.setIndexPath(src.getIndexPath());
        dto.setStatus(src.getStatus());
        dto.setType(src.getType());
        dto.setConnectorName(src.getConnectorName());
        Map allProps = src.getProperties();
        Map allSegments = src.getSegments();
        LinkedHashMap baseProps = new LinkedHashMap();
        LinkedHashMap baseSegments = new LinkedHashMap();
        for (Map.Entry entry : allProps.entrySet()) {
            key = (String)entry.getKey();
            baseProps.put(key, entry.getValue());
        }
        for (Map.Entry entry : allSegments.entrySet()) {
            key = (String)entry.getKey();
            baseSegments.put(key, entry.getValue());
        }
        dto.setError(this.buildErrorInfo(src.getError()));
        dto.setProperties(baseProps);
        dto.setSegment(baseSegments);
        return dto;
    }

    public Optional<LogDataDTO> toDto(Optional<LogDataMng> logData) {
        return logData.map(arg_0 -> this.toDto(arg_0));
    }

    private Map<String, String> convertProperties(Map<LogLineKey, Object> props) {
        if (props == null || props.isEmpty()) {
            return Collections.emptyMap();
        }
        return props.entrySet().stream().filter(e -> e.getKey() != null).collect(Collectors.toMap(e -> ((LogLineKey)e.getKey()).getSrcName(), e -> e.getValue() != null ? e.getValue().toString() : "", (v1, v2) -> v2, LinkedHashMap::new));
    }

    private ErrorInfoDTO buildErrorInfo(LogDataError logDataError) {
        if (logDataError == null) {
            return null;
        }
        ErrorInfoDTO err = new ErrorInfoDTO();
        err.setOriginOfErrorPath(logDataError.getErrorOfOriginPath());
        err.setMessage(logDataError.getMessage());
        err.setStackTrace(logDataError.getStackTrace());
        return err;
    }
}

