/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import com.becon.opencelium.backend.execution.logger.LogLineDispatcher;
import com.becon.opencelium.backend.execution.logger.LogMessage;
import com.becon.opencelium.backend.execution.socket.WebSocketNotificationService;
import com.becon.opencelium.backend.quartz.QuartzJobScheduler;
import com.becon.opencelium.backend.utility.ApplicationContextUtility;
import com.becon.opencelium.backend.utility.LogFileUtility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcLogger<T extends LogMessage> {
    private final boolean debugMode;
    private final boolean webSocket;
    private final boolean supportFile;
    private final T logEntity;
    private final WebSocketNotificationService socketNotificationService;
    private final LogLineDispatcher logLineDispatcher;
    private final long connectionId;
    private final Path filepath;
    private final Logger logger;

    public OcLogger(QuartzJobScheduler.TriggerType triggerType, boolean debugMode, T logEntity, long connectionId, String timestamp, long executionId) {
        this.debugMode = debugMode;
        this.webSocket = QuartzJobScheduler.TriggerType.EXECUTION_TEST == triggerType;
        this.supportFile = QuartzJobScheduler.TriggerType.SUPPORT_FILE == triggerType;
        this.socketNotificationService = (WebSocketNotificationService)ApplicationContextUtility.getBean(WebSocketNotificationService.class);
        this.logLineDispatcher = new LogLineDispatcher();
        this.connectionId = connectionId;
        this.logEntity = logEntity;
        LogFileUtility.deleteByExecutionId((long)executionId);
        String loggerId = String.format("%d-%d", executionId, connectionId);
        String filename = LogFileUtility.toFilename((String)timestamp, (long)connectionId, (String)"u", (long)executionId, (String)"log");
        this.filepath = LogFileUtility.toPath((String)"./logs", (String[])new String[]{filename});
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        FileAppender fileAppender = new FileAppender();
        fileAppender.setName("FileAppender-" + loggerId);
        fileAppender.setContext((Context)context);
        fileAppender.setFile(this.filepath.toString());
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)context);
        encoder.setPattern("%d{dd-MM-yyyy HH:mm:ss.SSS} - %msg%n");
        encoder.setCharset(StandardCharsets.UTF_8);
        encoder.start();
        fileAppender.setEncoder((Encoder)encoder);
        fileAppender.start();
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)loggerId);
        logger.addAppender((Appender)fileAppender);
        logger.setAdditive(false);
        this.logger = logger;
    }

    public void close() {
        Logger logger = this.logger;
        if (logger instanceof ch.qos.logback.classic.Logger) {
            ch.qos.logback.classic.Logger classicLogger = (ch.qos.logback.classic.Logger)logger;
            classicLogger.iteratorForAppenders().forEachRemaining(appender -> {
                if (appender instanceof FileAppender) {
                    appender.stop();
                }
            });
            classicLogger.detachAndStopAllAppenders();
        }
        if (!this.debugMode && !this.supportFile) {
            try {
                LogFileUtility.delete((Path)this.filepath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public T getLogEntity() {
        return (T)this.logEntity;
    }

    public void logAndSend(String message) {
        Consumer<String> printStrategy = arg_0 -> ((Logger)this.logger).info(arg_0);
        this.logAndSend(printStrategy, (Object)message);
    }

    public void logAndSend(Exception e) {
        String stackTrace = this.getStackTraceAsString((Throwable)e);
        String logMessage = "segment=EXCEPTION data=" + stackTrace;
        Consumer<String> printStrategy = arg_0 -> ((Logger)this.logger).info(arg_0);
        this.logAndSend(printStrategy, (Object)logMessage);
    }

    private <E> void logAndSend(Consumer<E> t, E message) {
        if (!this.debugMode && !this.supportFile) {
            return;
        }
        long startOffset = this.getStartOffset();
        t.accept(message);
        long endOffset = this.getStartOffset();
        Optional logData = this.logLineDispatcher.dispatch(message.toString(), startOffset, endOffset);
        if (this.webSocket && logData.isPresent()) {
            this.socketNotificationService.send(this.connectionId, (Object)logData);
        }
    }

    private long getStartOffset() {
        try {
            return this.evaluateUsingFiles();
        }
        catch (IOException e) {
            return this.evaluateUsingRAF();
        }
    }

    private long evaluateUsingFiles() throws IOException {
        return Files.size(this.filepath);
    }

    private long evaluateUsingRAF() {
        long l;
        RandomAccessFile raf = new RandomAccessFile(this.filepath.toFile(), "r");
        try {
            l = raf.length();
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        raf.close();
        return l;
    }

    private String getStackTraceAsString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

