/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.builder;

import com.becon.opencelium.backend.enums.execution.DataType;
import com.becon.opencelium.backend.enums.execution.ParamLocation;
import com.becon.opencelium.backend.execution.builder.BodyBuilder;
import com.becon.opencelium.backend.execution.builder.HeadersBuilder;
import com.becon.opencelium.backend.execution.builder.OperationCarrier;
import com.becon.opencelium.backend.execution.builder.URIBuilder;
import com.becon.opencelium.backend.resource.execution.OperationDTO;
import com.becon.opencelium.backend.resource.execution.ParameterDTO;
import com.becon.opencelium.backend.resource.execution.ParameterDTOUtil;
import com.becon.opencelium.backend.resource.execution.RequestBodyDTO;
import com.becon.opencelium.backend.resource.execution.SchemaDTO;
import com.becon.opencelium.backend.resource.execution.SchemaDTOUtil;
import com.becon.opencelium.backend.utility.MediaTypeUtility;
import com.becon.opencelium.backend.utility.ReferenceUtility;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class RequestEntityBuilder {
    private final OperationDTO operation;
    private final Function<String, Object> references;
    private URIBuilder URIBuilder;
    private HeadersBuilder headersBuilder;
    private BodyBuilder bodyBuilder;

    public RequestEntityBuilder(OperationDTO operation, Function<String, Object> references) {
        this.operation = operation;
        this.references = references;
    }

    public static OperationCarrier start() {
        return new OperationCarrier();
    }

    public RequestEntityBuilder withCustomURL(URIBuilder URIBuilder2) {
        this.URIBuilder = URIBuilder2;
        return this;
    }

    public RequestEntityBuilder withCustomHeaders(HeadersBuilder headersBuilder) {
        this.headersBuilder = headersBuilder;
        return this;
    }

    public RequestEntityBuilder withCustomBody(BodyBuilder bodyBuilder) {
        this.bodyBuilder = bodyBuilder;
        return this;
    }

    public RequestEntity<Object> createRequest() {
        URI url = Objects.nonNull(this.URIBuilder) ? this.URIBuilder.build(this.operation, this.references) : this.defaultURLBuilder();
        HttpMethod method = this.defaultMethod();
        HttpHeaders headers = Objects.nonNull(this.headersBuilder) ? this.headersBuilder.build(this.operation, this.references) : this.defaultHeadersBuilder();
        Object body = Objects.nonNull(this.bodyBuilder) ? this.bodyBuilder.build(this.operation, this.references) : this.defaultBodyBuilder(headers.getContentType());
        return new RequestEntity(body, (MultiValueMap)headers, method, url);
    }

    private HttpMethod defaultMethod() {
        if (this.operation.getHttpMethod() == null) {
            throw new RuntimeException("Http method should be supplied");
        }
        return this.operation.getHttpMethod();
    }

    private URI defaultURLBuilder() {
        String rawUrl = this.operation.getPath();
        for (ParameterDTO parameter : this.getParamsByLocation(ParamLocation.PATH)) {
            ParameterDTO copiedParameter = ParameterDTOUtil.copy((ParameterDTO)parameter);
            String ref = copiedParameter.getSchema().getValue();
            this.replaceRefs(copiedParameter.getSchema());
            String value = ParameterDTOUtil.toString((ParameterDTO)copiedParameter);
            if (!ref.contains("url")) {
                value = RequestEntityBuilder.safeEncode((String)value);
            }
            rawUrl = rawUrl.replace(ref, value);
        }
        for (ParameterDTO parameter : this.getParamsByLocation(ParamLocation.QUERY)) {
            String rawQuery = ParameterDTOUtil.toString((ParameterDTO)parameter);
            ParameterDTO copiedParameter = ParameterDTOUtil.copy((ParameterDTO)parameter);
            this.replaceRefs(copiedParameter.getSchema());
            String query = RequestEntityBuilder.safeEncode((String)ParameterDTOUtil.toString((ParameterDTO)copiedParameter));
            rawUrl = rawUrl.replace(rawQuery, query);
        }
        return URI.create(rawUrl);
    }

    private HttpHeaders defaultHeadersBuilder() {
        HttpHeaders headers = new HttpHeaders();
        this.getParamsByLocation(ParamLocation.HEADER).stream().map(ParameterDTOUtil::copy).peek(parameter -> this.replaceRefs(parameter.getSchema())).forEach(parameter -> headers.add(parameter.getName(), ParameterDTOUtil.toString((ParameterDTO)parameter)));
        this.getParamsByLocation(ParamLocation.COOKIE).stream().map(ParameterDTOUtil::copy).peek(parameter -> this.replaceRefs(parameter.getSchema())).forEach(parameter -> headers.add("Cookie", ParameterDTOUtil.toString((ParameterDTO)parameter)));
        String cookies = String.join((CharSequence)"; ", (Iterable)headers.getOrDefault((Object)"Cookie", List.of()));
        if (!cookies.isEmpty()) {
            headers.put("Cookie", List.of(cookies));
        }
        return headers;
    }

    private Object defaultBodyBuilder(MediaType contentType) {
        RequestBodyDTO body = this.operation.getRequestBody();
        if (body == null) {
            return null;
        }
        if (MediaTypeUtility.isFormUrlencodedCompatible((MediaType)contentType) && !"CheckMK".equals(this.operation.getInvoker())) {
            return this.toFormUrlencoded(body.getSchema());
        }
        SchemaDTO copiedSchema = SchemaDTOUtil.copy((SchemaDTO)body.getSchema());
        this.replaceRefs(copiedSchema);
        MediaType bodyContent = body.getContent();
        String requestBody = MediaTypeUtility.isTextPlainCompatible((MediaType)bodyContent) ? SchemaDTOUtil.toText((SchemaDTO)copiedSchema) : (MediaTypeUtility.isXmlCompatible((MediaType)bodyContent) ? SchemaDTOUtil.toXML((SchemaDTO)copiedSchema) : SchemaDTOUtil.toJSON((SchemaDTO)copiedSchema));
        if ("CheckMK".equals(this.operation.getInvoker()) && requestBody != null && !requestBody.isEmpty() && MediaTypeUtility.isFormUrlencodedCompatible((MediaType)contentType)) {
            LinkedMultiValueMap request = new LinkedMultiValueMap();
            request.add((Object)"request", (Object)requestBody);
            return request;
        }
        return requestBody;
    }

    private MultiValueMap<String, Object> toFormUrlencoded(SchemaDTO schema) {
        if (schema == null) {
            return null;
        }
        if (schema.getType() == DataType.OBJECT) {
            LinkedMultiValueMap formData = new LinkedMultiValueMap();
            Map properties = schema.getProperties();
            if (properties == null) {
                return formData;
            }
            for (Map.Entry property : properties.entrySet()) {
                String value;
                String string = value = property.getValue() == null ? null : ((SchemaDTO)property.getValue()).getValue();
                if (value != null && ReferenceUtility.containsRef((String)value)) {
                    value = this.references.apply(value);
                }
                formData.add((Object)((String)property.getKey()), (Object)value);
            }
            return formData;
        }
        throw new RuntimeException("Unsupported DataType for 'application/x-www-form-urlencoded', type = " + schema.getType());
    }

    private static String safeEncode(String query) {
        if (query == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (c == '%' && i + 2 < query.length() && Character.digit(query.charAt(i + 1), 16) != -1 && Character.digit(query.charAt(i + 2), 16) != -1) {
                sb.append('%').append(query.charAt(i + 1)).append(query.charAt(i + 2));
                i += 2;
                continue;
            }
            if (Character.isWhitespace(c)) {
                sb.append("%20");
                continue;
            }
            if ("\"<>{}|\\^`".indexOf(c) >= 0) {
                sb.append('%').append(String.format("%02X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void replaceRefs(SchemaDTO schema) {
        if (schema == null) {
            return;
        }
        String value = schema.getValue();
        if (ReferenceUtility.containsRef((String)value)) {
            SchemaDTO referencedSchema = SchemaDTOUtil.fromObject(this.references.apply(value));
            if (referencedSchema == null) {
                schema.setValue(null);
            } else if (this.isReferencedPrimary(schema.getType(), referencedSchema.getType(), value)) {
                schema.setType(referencedSchema.getType());
                schema.setValue(referencedSchema.getValue());
                schema.setItems(referencedSchema.getItems());
                schema.setProperties(referencedSchema.getProperties());
                schema.setXml(referencedSchema.getXml());
            } else {
                DataType requiredType = schema.getType();
                DataType availableType = referencedSchema.getType();
                schema.setValue(null);
                schema.setItems(null);
                schema.setXml(null);
                schema.setProperties(null);
                if (requiredType == DataType.ARRAY) {
                    schema.setItems(List.of(referencedSchema));
                } else if (requiredType == DataType.OBJECT) {
                    schema.setProperties(Map.of(referencedSchema.getValue(), referencedSchema));
                } else if (availableType.isPrimitive()) {
                    schema.setValue(referencedSchema.getValue());
                } else {
                    throw new RuntimeException(String.format("SchemaDTO cannot be converted from %s type to %s type", availableType, requiredType));
                }
            }
            return;
        }
        List items = schema.getItems();
        if (schema.getType() == DataType.ARRAY && items != null) {
            items.forEach(arg_0 -> this.replaceRefs(arg_0));
        }
        Map properties = schema.getProperties();
        if (schema.getType() == DataType.OBJECT && properties != null) {
            properties.forEach((name, schemaDTO) -> this.replaceRefs(schemaDTO));
        }
    }

    private boolean isReferencedPrimary(DataType actual, DataType referenced, String ref) {
        if (actual == DataType.UNDEFINED || actual == referenced) {
            return true;
        }
        if (ref.matches("#[a-zA-Z0-9]{6}\\.(\\(response\\)|\\(request\\))\\..+") || ref.matches("#\\{%[0-9a-fA-F]{24}%\\}")) {
            return true;
        }
        return ref.matches("\\$\\{(.*?)\\}") && ref.contains(":");
    }

    private List<ParameterDTO> getParamsByLocation(ParamLocation location) {
        if (CollectionUtils.isEmpty((Collection)this.operation.getParameters())) {
            return new ArrayList<ParameterDTO>();
        }
        return this.operation.getParameters().stream().filter(Objects::nonNull).filter(p -> p.getIn() == location).filter(p -> p.getSchema() != null).collect(Collectors.toList());
    }
}

