/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution;

import com.becon.opencelium.backend.enums.PageParam;
import com.becon.opencelium.backend.enums.RelationalOperator;
import com.becon.opencelium.backend.execution.ExecutionManager;
import com.becon.opencelium.backend.execution.oc721.Connector;
import com.becon.opencelium.backend.execution.oc721.Enhancement;
import com.becon.opencelium.backend.execution.oc721.EnhancementService;
import com.becon.opencelium.backend.execution.oc721.EnhancementServiceImpl;
import com.becon.opencelium.backend.execution.oc721.Extractor;
import com.becon.opencelium.backend.execution.oc721.FieldBind;
import com.becon.opencelium.backend.execution.oc721.Loop;
import com.becon.opencelium.backend.execution.oc721.Operation;
import com.becon.opencelium.backend.execution.oc721.ReferenceExtractor;
import com.becon.opencelium.backend.invoker.entity.Pagination;
import com.becon.opencelium.backend.scriptengine.LanguageType;
import com.becon.opencelium.backend.scriptengine.ScriptEngine;
import com.becon.opencelium.backend.scriptengine.ScriptExecutionManager;
import com.becon.opencelium.backend.scriptengine.ScriptExecutionManagerProvider;
import com.becon.opencelium.backend.utility.ReferenceUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExecutionManagerImpl
implements ExecutionManager {
    private final Map<String, Object> webhookVars;
    private final Extractor refExtractor;
    private final EnhancementService enhancementService;
    private final List<Loop> loops = new ArrayList();
    private final Connector connectorFrom;
    private final Connector connectorTo;
    private final List<FieldBind> fieldBind;
    private final List<Operation> operations = new ArrayList();
    private final ScriptExecutionManager scriptExecutionManager;
    private Integer currentCtorId;
    private Pagination pagination;

    public ExecutionManagerImpl(Map<String, Object> webhookVars, Connector connectorFrom, Connector connectorTo, List<FieldBind> fieldBind) {
        this.webhookVars = webhookVars;
        this.connectorFrom = connectorFrom;
        this.connectorTo = connectorTo;
        this.fieldBind = fieldBind;
        this.refExtractor = new ReferenceExtractor((ExecutionManager)this);
        this.enhancementService = new EnhancementServiceImpl((ExecutionManager)this);
        this.scriptExecutionManager = ScriptExecutionManagerProvider.get();
    }

    public Map<String, Object> getWebhookVars() {
        return this.webhookVars;
    }

    public List<Loop> getLoops() {
        return this.loops;
    }

    public String generateKey(int loopDepth) {
        if (loopDepth == 0 || this.loops.isEmpty()) {
            return "#";
        }
        return this.loops.stream().limit(loopDepth).map(loop -> {
            if (loop.getOperator() == RelationalOperator.FOR) {
                return String.valueOf(loop.getIndex());
            }
            return loop.getValue();
        }).collect(Collectors.joining(", "));
    }

    public Map<String, String> getRequestData(Integer ctorId) {
        Integer n = ctorId = ctorId == null ? this.currentCtorId : ctorId;
        if (Objects.equals(ctorId, this.connectorFrom.getId())) {
            return this.connectorFrom.getRequiredData();
        }
        if (Objects.equals(ctorId, this.connectorTo.getId())) {
            return this.connectorTo.getRequiredData();
        }
        throw new RuntimeException("Non existing connector id 'ctorId' = " + ctorId);
    }

    public Optional<Operation> findOperationByColor(String color) {
        return this.operations.stream().filter(operation -> operation.getColor().equals(color)).findFirst();
    }

    public Object executeScript(String bindId) {
        Enhancement enhancement = this.fieldBind.stream().filter(fb -> Objects.equals(bindId, fb.getBindId())).map(FieldBind::getEnhance).findFirst().orElseThrow(() -> new RuntimeException("Non existing fieldBind id 'bindId' = " + bindId));
        ScriptEngine scriptEngine = (ScriptEngine)this.scriptExecutionManager.resolveEngine(LanguageType.getByCode((String)enhancement.getLang())).orElseThrow(() -> new RuntimeException("No engine is available for '%s' language".formatted(enhancement.getLang())));
        if (!scriptEngine.isUp()) {
            throw new RuntimeException("Currently, an engine is not up for '%s' language".formatted(enhancement.getLang()));
        }
        scriptEngine.validate(enhancement.getScript());
        return scriptEngine.execute(enhancement.getScript(), enhancement.getArgs(), arg_0 -> this.getValue(arg_0));
    }

    public Object getValue(String value) {
        if (value == null) {
            return null;
        }
        List references = ReferenceUtility.extractRefs((String)value);
        if (!(references.isEmpty() || references.size() == 1 && Objects.equals(value, references.get(0)))) {
            for (String ref : references) {
                Object val = this.refExtractor.extractValue(ref);
                val = val == null ? "" : val.toString();
                value = value.replace(ref, (String)val);
            }
            return value;
        }
        return this.refExtractor.extractValue(value);
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    public List<Operation> getAllOperations() {
        return this.operations;
    }

    public void setCurrentCtorId(Integer ctorId) {
        this.currentCtorId = ctorId;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public String getPaginationParamValue(PageParam pageParam) {
        return this.pagination.getParamValue(pageParam);
    }
}

