/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution;

import com.becon.opencelium.backend.enums.LogType;
import com.becon.opencelium.backend.enums.OpType;
import com.becon.opencelium.backend.enums.PageParam;
import com.becon.opencelium.backend.enums.RelationalOperator;
import com.becon.opencelium.backend.execution.ExecutionManager;
import com.becon.opencelium.backend.execution.builder.RequestEntityBuilder;
import com.becon.opencelium.backend.execution.logger.OcLogger;
import com.becon.opencelium.backend.execution.logger.msg.ConnectorLog;
import com.becon.opencelium.backend.execution.logger.msg.ExecutionLog;
import com.becon.opencelium.backend.execution.logger.msg.MethodData;
import com.becon.opencelium.backend.execution.masking.MaskingService;
import com.becon.opencelium.backend.execution.oc721.Connector;
import com.becon.opencelium.backend.execution.oc721.Loop;
import com.becon.opencelium.backend.execution.oc721.Operation;
import com.becon.opencelium.backend.invoker.entity.Pagination;
import com.becon.opencelium.backend.ocel.ExpressionProcessor;
import com.becon.opencelium.backend.ocel.ExpressionProcessorFactory;
import com.becon.opencelium.backend.ocel.ProcessorType;
import com.becon.opencelium.backend.resource.execution.ConnectorEx;
import com.becon.opencelium.backend.resource.execution.OperationDTO;
import com.becon.opencelium.backend.resource.execution.OperatorEx;
import com.becon.opencelium.backend.resource.execution.ResponseDTO;
import com.becon.opencelium.backend.utility.MediaTypeUtility;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConnectorExecutor {
    private final ExpressionProcessor expressionProcessor;
    private final Connector connector;
    private final ExecutionManager executionManager;
    private final RestTemplate restTemplate;
    private final List<Object> executables;
    private final OcLogger<ExecutionLog> logger;
    private final MaskingService masking;
    private final String flowId;
    private final int connectorId;
    private final String connectorName;
    private final String direction;
    private final Stack<String> endPhases = new Stack();

    public ConnectorExecutor(ConnectorEx connectorEx, ExecutionManager executionManager, RestTemplate restTemplate, OcLogger<ExecutionLog> logger, MaskingService masking, String direction) {
        this.expressionProcessor = ExpressionProcessorFactory.get((ProcessorType)ProcessorType.POSTFIX);
        this.executionManager = executionManager;
        this.restTemplate = restTemplate;
        this.logger = logger;
        this.masking = masking;
        this.executables = new ArrayList();
        if (Objects.nonNull(connectorEx.getMethods())) {
            connectorEx.getMethods().forEach(o -> {
                o.setInvoker(connectorEx.getInvoker());
                this.executables.add(o);
            });
        }
        if (Objects.nonNull(connectorEx.getOperators())) {
            this.executables.addAll(connectorEx.getOperators());
        }
        this.executables.sort(ConnectorExecutor.getComparator());
        this.connector = Connector.fromEx((ConnectorEx)connectorEx);
        this.flowId = connectorEx.getFchartId();
        this.connectorId = connectorEx.getId();
        this.connectorName = connectorEx.getName();
        this.direction = direction;
    }

    public void start() {
        ((ExecutionLog)this.logger.getLogEntity()).setType(LogType.INFO);
        ((ExecutionLog)this.logger.getLogEntity()).setConnector(new ConnectorLog(this.connectorName, "source".equals(this.direction) ? "CONN1" : "CONN2"));
        this.logger.logAndSend(String.format("phase=FLOWCHART_START flowId=%s connectorId=%d connectorName=%s direction=%s", this.flowId, this.connectorId, this.connectorName, this.direction));
        this.endPhases.push(String.format("phase=FLOWCHART_END flowId=%s connectorId=%d connectorName=%s direction=%s", this.flowId, this.connectorId, this.connectorName, this.direction));
        try {
            this.executionManager.setCurrentCtorId(this.connector.getId());
            int headPointer = 0;
            while (headPointer < this.executables.size()) {
                int tailPointer = this.getTailPointer(headPointer);
                this.execute(headPointer, tailPointer);
                headPointer = tailPointer + 1;
            }
        }
        catch (RuntimeException e) {
            this.logger.logAndSend((Exception)e);
            throw e;
        }
        finally {
            while (!this.endPhases.isEmpty()) {
                this.logger.logAndSend((String)this.endPhases.pop());
            }
        }
    }

    private void execute(int headPointer, int tailPointer) {
        if (headPointer > tailPointer) {
            return;
        }
        int tail = this.getTailPointer(headPointer);
        String index = ConnectorExecutor.getIndex(this.executables.get(headPointer));
        Object e = this.executables.get(headPointer);
        if (e instanceof OperationDTO) {
            OperationDTO operation = (OperationDTO)e;
            ((ExecutionLog)this.logger.getLogEntity()).setMethodData(new MethodData(operation.getOperationId()));
            this.logger.logAndSend(String.format("phase=OPERATION_START indexPath=%s name=\"%s\" %s", index, operation.getName(), this.getLoopData()));
            this.endPhases.push(String.format("phase=OPERATION_END indexPath=%s name=\"%s\" %s", index, operation.getName(), this.getLoopData()));
            if (headPointer != tail) {
                throw new RuntimeException("Methods cannot have body");
            }
            this.executeOperation(operation);
            this.logger.logAndSend((String)this.endPhases.pop());
            ((ExecutionLog)this.logger.getLogEntity()).setMethodData(null);
        } else {
            e = this.executables.get(headPointer);
            if (e instanceof OperatorEx) {
                OperatorEx operator = (OperatorEx)e;
                if (Objects.equals(operator.getType(), "if")) {
                    boolean result;
                    this.logger.logAndSend(String.format("phase=IF_START indexPath=%s expression=(%s) %s", index, operator.getExpression(), this.getLoopData()));
                    this.endPhases.push(String.format("phase=IF_END indexPath=%s %s", index, this.getLoopData()));
                    try {
                        result = (Boolean)this.expressionProcessor.evaluate(operator.getExpression(), arg_0 -> ((ExecutionManager)this.executionManager).getValue(arg_0), this.logger, this.masking);
                        this.logger.logAndSend("segment=IF_RESULT data=" + result);
                    }
                    catch (RuntimeException e2) {
                        this.logger.logAndSend("segment=IF_RESULT data=unknown");
                        throw e2;
                    }
                    if (result) {
                        this.execute(headPointer + 1, tail);
                    }
                    this.logger.logAndSend((String)this.endPhases.pop());
                } else {
                    int i;
                    int length;
                    Loop loop = Loop.fromEx((OperatorEx)operator);
                    Object referencedList = this.executionManager.getValue(loop.getRef());
                    List<String> list = new ArrayList();
                    if (!ObjectUtils.isEmpty((Object)referencedList)) {
                        if (loop.getOperator() == RelationalOperator.FOR) {
                            length = ((List)referencedList).size();
                            for (i = 0; i < length; ++i) {
                                list.add(String.valueOf(i));
                            }
                        } else if (loop.getOperator() == RelationalOperator.FOR_IN) {
                            list = (List)referencedList;
                        } else {
                            String[] strs = ((String)referencedList).split(loop.getDelimiter());
                            Collections.addAll(list, strs);
                        }
                    }
                    length = list.size();
                    this.logger.logAndSend(String.format("phase=LOOP_START indexPath=%s expression=(%s) size=%d iterator=\"%s\" %s", index, loop.getRef(), length, loop.getIterator(), this.getLoopData()));
                    this.logger.logAndSend(String.format("segment=LOOP_REF ref=(%s) data=%s", loop.getRef(), list.stream().collect(Collectors.joining(", ", "[", "]"))));
                    this.endPhases.push(String.format("phase=LOOP_END indexPath=%s %s", index, this.getLoopData()));
                    this.executionManager.getLoops().add(loop);
                    for (i = 0; i < length; ++i) {
                        loop.setIndex(i);
                        loop.setValue((String)list.get(i));
                        this.execute(headPointer + 1, tail);
                    }
                    this.executionManager.getLoops().remove(loop);
                    this.logger.logAndSend((String)this.endPhases.pop());
                }
            } else {
                throw new RuntimeException("Wrong type is supplied");
            }
        }
        this.execute(tail + 1, tailPointer);
    }

    private void executeOperation(OperationDTO dto) {
        ResponseEntity responseEntity;
        Class responseType;
        RequestEntity requestEntity;
        BiFunction<String, String, String> toRef = (type, part) -> dto.getOperationId() + ".(" + type + ")." + part;
        Pagination pagination = null;
        if (dto.getOperationType() == OpType.PAGINATION) {
            Pagination pagination2 = pagination = dto.getPagination() != null ? dto.getPagination() : this.connector.getPagination();
            if (pagination != null) {
                pagination = pagination.clone();
            }
        }
        this.executionManager.setPagination(pagination);
        boolean hasMore = false;
        long duration = 0L;
        do {
            String nextElemLink;
            requestEntity = RequestEntityBuilder.start().forOperation(dto).usingReferences(arg_0 -> ((ExecutionManager)this.executionManager).getValue(arg_0)).createRequest();
            URI uri = requestEntity.getUrl();
            if (pagination != null && pagination.existsParam(PageParam.LINK) && (nextElemLink = pagination.findParam(PageParam.LINK).getValue()) != null && !nextElemLink.isEmpty()) {
                try {
                    uri = new URI(nextElemLink);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            this.logger.logAndSend(String.format("segment=REQUEST url=%s http_method=%s", this.masking.applyMask((Object)uri, toRef.apply("request", "url")), requestEntity.getMethod()));
            this.logger.logAndSend(String.format("segment=REQUEST_HEADER data=%s", this.masking.applyMask((Object)requestEntity.getHeaders(), toRef.apply("request", "header"))));
            this.logger.logAndSend(String.format("segment=REQUEST_PAYLOAD data=%s", this.masking.applyMask(requestEntity.getBody(), toRef.apply("request", "body"))));
            HttpEntity httpEntity = new HttpEntity(requestEntity.getBody(), (MultiValueMap)requestEntity.getHeaders());
            responseType = this.getResponseType(dto);
            long startTime = System.currentTimeMillis();
            responseEntity = this.restTemplate.exchange(uri, requestEntity.getMethod(), httpEntity, responseType);
            duration += System.currentTimeMillis() - startTime;
            if (pagination == null) continue;
            pagination.updateParamValues(responseEntity, responseType);
            hasMore = pagination.hasMore();
        } while (hasMore);
        if (responseType.equals(byte[].class)) {
            byte[] fileBytes = (byte[])responseEntity.getBody();
            String base64Encoded = Base64.getEncoder().encodeToString(fileBytes);
            responseEntity = new ResponseEntity((Object)base64Encoded, (MultiValueMap)responseEntity.getHeaders(), responseEntity.getStatusCode());
        }
        if (pagination != null) {
            String paginatedBody = pagination.findParam(PageParam.RESULT).getValue();
            responseEntity = new ResponseEntity((Object)paginatedBody, (MultiValueMap)responseEntity.getHeaders(), responseEntity.getStatusCode());
            pagination = null;
            this.executionManager.setPagination(pagination);
        }
        this.logger.logAndSend(String.format("segment=RESPONSE status=%d duration=%dms", responseEntity.getStatusCode().value(), duration));
        this.logger.logAndSend(String.format("segment=RESPONSE_HEADER data=%s", this.masking.applyMask((Object)responseEntity.getHeaders(), toRef.apply("response", "header"))));
        this.logger.logAndSend(String.format("segment=RESPONSE_PAYLOAD data=%s", this.masking.applyMask(responseEntity.getBody(), toRef.apply("response", "body"))));
        Operation operation = this.executionManager.findOperationByColor(dto.getOperationId()).orElseGet(() -> {
            int loopDepth = this.executionManager.getLoops().size();
            Operation newOperation = Operation.fromDTO((OperationDTO)dto, (int)loopDepth);
            this.executionManager.addOperation(newOperation);
            return newOperation;
        });
        String key = this.executionManager.generateKey(operation.getLoopDepth());
        operation.addRequest(key, requestEntity);
        operation.addResponse(key, responseEntity);
    }

    private Class<?> getResponseType(OperationDTO dto) {
        MediaType mediaType = MediaType.APPLICATION_JSON;
        for (ResponseDTO response : dto.getResponses()) {
            if (!"success".equals(response.getStatus())) continue;
            mediaType = response.getContent();
        }
        if (MediaTypeUtility.isJsonCompatible((MediaType)mediaType)) {
            return Object.class;
        }
        if (MediaTypeUtility.isBinaryCompatible((MediaType)mediaType)) {
            return byte[].class;
        }
        return String.class;
    }

    private int getTailPointer(int headPointer) {
        String index = ConnectorExecutor.getIndex(this.executables.get(headPointer)) + "_";
        ++headPointer;
        while (headPointer < this.executables.size() && ConnectorExecutor.getIndex(this.executables.get(headPointer)).startsWith(index)) {
            ++headPointer;
        }
        return headPointer - 1;
    }

    public String getLoopData() {
        List loops = this.executionManager.getLoops();
        if (loops.isEmpty()) {
            return "";
        }
        String loopIterator = loops.stream().map(Loop::getIterator).collect(Collectors.joining(","));
        String loopIndex = loops.stream().map(loop -> String.valueOf(loop.getIndex())).collect(Collectors.joining(","));
        return String.format("loopIterator=\"%s\" loopIndex=\"%s\"", loopIterator, loopIndex);
    }

    private static Comparator<Object> getComparator() {
        return (o1, o2) -> {
            String[] arr1 = ConnectorExecutor.getIndex((Object)o1).split("_");
            String[] arr2 = ConnectorExecutor.getIndex((Object)o2).split("_");
            for (int i = 0; i < arr1.length && i < arr2.length; ++i) {
                if (Objects.equals(arr1[i], arr2[i])) continue;
                return Integer.parseInt(arr1[i]) - Integer.parseInt(arr2[i]);
            }
            return arr1.length - arr2.length;
        };
    }

    private static String getIndex(Object o) {
        if (o instanceof OperationDTO) {
            return ((OperationDTO)o).getExecOrder();
        }
        if (o instanceof OperatorEx) {
            return ((OperatorEx)o).getIndex();
        }
        throw new RuntimeException("getIndex() is only applicable to OperationDTO and OperatorEX");
    }
}

