/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.exception.handler;

import com.becon.opencelium.backend.exception.GeneralServiceException;
import com.becon.opencelium.backend.ocel.exception.InvalidExpressionException;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import java.time.Instant;
import java.util.Date;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
public class GlobalExceptionHandler {
    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.BAD_GATEWAY)
    public ResponseEntity<ErrorResource> handleNoHandlerFoundException(NoHandlerFoundException ex) {
        ErrorResource errorResource = new ErrorResource((Exception)ex, HttpStatus.BAD_GATEWAY);
        return ResponseEntity.badRequest().body((Object)errorResource);
    }

    @ExceptionHandler(value={InvalidExpressionException.class})
    public ResponseEntity<ErrorResource> handleInvalidExpressionException(InvalidExpressionException ex) {
        ErrorResource errorResource = new ErrorResource();
        errorResource.setMessage(ex.getMessage());
        errorResource.setError(ex.getErrorCode().getCode());
        errorResource.setTimestamp(Date.from(Instant.now()));
        errorResource.setStatus(HttpStatus.BAD_REQUEST);
        return ResponseEntity.badRequest().body((Object)errorResource);
    }

    @ExceptionHandler(value={GeneralServiceException.class})
    public ResponseEntity<ErrorResource> handleGeneralException(GeneralServiceException ex) {
        ErrorResource errorResource = new ErrorResource();
        errorResource.setMessage(ex.getMessage());
        errorResource.setError(ex.getError());
        errorResource.setTimestamp(Date.from(Instant.now()));
        errorResource.setStatus(ex.getStatus());
        return ResponseEntity.status((HttpStatusCode)ex.getStatus()).body((Object)errorResource);
    }
}

