/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.OnlineSyncHistory;
import com.becon.opencelium.backend.database.mysql.repository.OnlineSyncHistoryRepository;
import com.becon.opencelium.backend.database.mysql.service.OnlineSyncHistoryService;
import com.becon.opencelium.backend.resource.OnlineSyncHistoryDTO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class OnlineSyncHistoryServiceImpl
implements OnlineSyncHistoryService {
    private final OnlineSyncHistoryRepository repository;
    private static final String DEFAULT_USERNAME = "OC Autosync";

    public OnlineSyncHistoryServiceImpl(OnlineSyncHistoryRepository repository) {
        this.repository = repository;
    }

    public List<OnlineSyncHistoryDTO> findAll(String user, String service, LocalDateTime startTime, LocalDateTime endTime) {
        return this.repository.filterHistory(user, service, startTime, endTime).stream().map(history -> {
            OnlineSyncHistoryDTO dto = new OnlineSyncHistoryDTO();
            dto.setUser(history.getUsername());
            dto.setService(history.getService());
            dto.setDetails(history.getDetails());
            dto.setTimestamp(history.getCreatedAt().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            return dto;
        }).toList();
    }

    public void save(String username, String service, List<String> details) {
        OnlineSyncHistory entity = new OnlineSyncHistory();
        entity.setUsername(username);
        entity.setService(service);
        entity.setDetails(String.join((CharSequence)", ", details));
        this.repository.save((Object)entity);
    }

    public void save(String service, List<String> details) {
        this.save(DEFAULT_USERNAME, service, details);
    }
}

