/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.configuration.LdapProperties;
import com.becon.opencelium.backend.database.mysql.service.LdapVerificationService;
import com.becon.opencelium.backend.resource.LdapConfigDTO;
import com.becon.opencelium.backend.resource.LdapVerificationMessageDTO;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.AuthenticatedLdapEntryContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.core.support.LookupAttemptingCallback;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LdapVerificationServiceImpl
implements LdapVerificationService {
    @Autowired
    private LdapProperties properties;
    private static final Logger logger = LoggerFactory.getLogger(LdapVerificationService.class);

    public void validateAndLog(Object principal, Object credentials) {
        if (this.properties.isShowLogs().contains("OFF")) {
            return;
        }
        LdapConfigDTO config = new LdapConfigDTO();
        config.setUrls(this.properties.getUrls());
        config.setUserDN(this.properties.getUserSearchBase());
        config.setGroupDN(this.properties.getGroupSearchBase());
        config.setUsername(this.properties.getUsername());
        config.setPassword(this.properties.getPassword());
        config.setTimeout(this.properties.getTimeout());
        config.setUserSearchFilter(this.properties.getUserSearchFilter());
        config.setGroupSearchFilter(this.properties.getGroupSearchFilter());
        try {
            this.validateTimeout(config.getTimeout());
            logger.info(this.checkHost(config.getUrls(), config.getTimeout()));
            logger.info(this.checkAdminCredentials(config.getUrls(), config.getUsername(), config.getPassword(), config.getTimeout(), true));
            logger.info(this.validateLoginPrincipal(config, principal));
            logger.info(this.validateLoginCredential(config, principal, credentials, true));
        }
        catch (Throwable th) {
            logger.warn(th.getMessage());
        }
    }

    public List<LdapVerificationMessageDTO> collectMessages(LdapConfigDTO config) {
        ArrayList<LdapVerificationMessageDTO> messages = new ArrayList<LdapVerificationMessageDTO>();
        String title = null;
        try {
            title = "Timeout";
            this.validateTimeout(config.getTimeout());
            title = "Host";
            String message = this.checkHost(config.getUrls(), config.getTimeout());
            messages.add(LdapVerificationMessageDTO.of((String)title, (String)message));
            title = "User credentials";
            message = this.checkAdminCredentials(config.getUrls(), config.getUsername(), config.getPassword(), config.getTimeout(), true);
            messages.add(LdapVerificationMessageDTO.of((String)title, (String)message));
            title = "Found entries";
            message = this.countUsers(config);
            messages.add(LdapVerificationMessageDTO.of((String)title, (String)message));
            messages.add(new LdapVerificationMessageDTO("STATUS CODE", "To distinguish success or fail"));
        }
        catch (RuntimeException e) {
            messages.add(LdapVerificationMessageDTO.of((String)title, (String)e.getMessage()));
        }
        return messages;
    }

    private void validateTimeout(String timeout) {
        if (timeout == null) {
            throw new RuntimeException("'timeout' in Ldap configuration should be not null");
        }
    }

    private String checkHost(String url, String timeout) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        try {
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", url);
            env.put("java.naming.security.authentication", "none");
            env.put("com.sun.jndi.ldap.connect.timeout", timeout);
            env.put("com.sun.jndi.ldap.read.timeout", timeout);
            InitialDirContext ctx = new InitialDirContext(env);
            ctx.close();
            return "Host = '" + url + "' is reachable";
        }
        catch (NamingException e) {
            throw new RuntimeException("Host = '" + url + "' is not reachable");
        }
    }

    private String checkAdminCredentials(String url, String username, String password, String timeout, boolean hidePassword) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        try {
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", url);
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", username);
            env.put("java.naming.security.credentials", password);
            env.put("com.sun.jndi.ldap.connect.timeout", timeout);
            env.put("com.sun.jndi.ldap.read.timeout", timeout);
            InitialDirContext ctx = new InitialDirContext(env);
            ctx.close();
            return "username = '" + username + "' and password = '" + (hidePassword ? "[PROTECTED]" : password) + "' has access to host = '" + url + "'";
        }
        catch (NamingException e) {
            throw new RuntimeException("username = '" + username + "' and password = '" + (hidePassword ? "[PROTECTED]" : password) + "' does not have access to host = '" + url + "'");
        }
    }

    private String countUsers(LdapConfigDTO config) {
        LdapTemplate ldapTemplate = LdapVerificationServiceImpl.createLdapTemplate((LdapConfigDTO)config);
        try {
            List users = ldapTemplate.search(config.getUserDN(), "(objectClass=person)", Attributes::clone);
            return "Found " + users.size() + " users under userDN = '" + config.getUserDN() + "'";
        }
        catch (NameNotFoundException e) {
            throw new RuntimeException("Could not count users under userDN = '" + config.getUserDN() + "'");
        }
    }

    private String validateLoginPrincipal(LdapConfigDTO config, Object principal) {
        LdapQuery query;
        LdapTemplate ldapTemplate = LdapVerificationServiceImpl.createLdapTemplate((LdapConfigDTO)config);
        List users = ldapTemplate.search(query = LdapQueryBuilder.query().base(config.getUserDN()).filter(config.getUserSearchFilter(), new Object[]{principal}), Attributes::clone);
        if (users == null || users.isEmpty()) {
            throw new RuntimeException("Principal = '" + principal + "' does not exist under userDN = '" + config.getUserDN() + "'");
        }
        if (users.size() == 1) {
            return "One record with principal = '" + principal + "' under userDN = '" + config.getUserDN() + "'";
        }
        return users.size() + " records with principal = '" + principal + "' under userDN = '" + config.getUserDN() + "'";
    }

    private String validateLoginCredential(LdapConfigDTO config, Object principal, Object credential, boolean hidePassword) {
        LdapTemplate ldapTemplate = LdapVerificationServiceImpl.createLdapTemplate((LdapConfigDTO)config);
        try {
            LdapQuery query = LdapQueryBuilder.query().base(config.getUserDN()).filter(config.getUserSearchFilter(), new Object[]{principal});
            ldapTemplate.authenticate(query, (String)credential, (AuthenticatedLdapEntryContextMapper)new LookupAttemptingCallback());
            return "principal = '" + principal + "' and credential = '" + (hidePassword ? "[PROTECTED]" : credential) + "' is valid under userDN = '" + config.getUserDN() + "'";
        }
        catch (Exception e) {
            throw new RuntimeException("principal = '" + principal + "' and credential = '" + (hidePassword ? "[PROTECTED]" : credential) + "' is not valid under userDN = '" + config.getUserDN() + "'");
        }
    }

    private static LdapTemplate createLdapTemplate(LdapConfigDTO config) {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(config.getUrls());
        contextSource.setBase("");
        contextSource.setUserDn(config.getUsername());
        contextSource.setPassword(config.getPassword());
        contextSource.afterPropertiesSet();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("com.sun.jndi.ldap.connect.timeout", config.getTimeout());
        env.put("com.sun.jndi.ldap.read.timeout", config.getTimeout());
        contextSource.setBaseEnvironmentProperties(env);
        return new LdapTemplate((ContextSource)contextSource);
    }
}

