/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.api.ApiType;
import com.becon.opencelium.backend.api.factory.ApiFactory;
import com.becon.opencelium.backend.api.module.InvokerModule;
import com.becon.opencelium.backend.api.serviceportal.ServicePortal;
import com.becon.opencelium.backend.database.mysql.entity.InvokerSync;
import com.becon.opencelium.backend.database.mysql.repository.InvokerSyncRepository;
import com.becon.opencelium.backend.database.mysql.service.InvokerSyncService;
import com.becon.opencelium.backend.database.mysql.service.OnlineSyncHistoryService;
import com.becon.opencelium.backend.invoker.service.InvokerService;
import com.becon.opencelium.backend.utility.crypto.HmacUtility;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class InvokerSyncServiceImp
implements InvokerSyncService {
    private final InvokerModule invokerModule;
    private final InvokerService invokerService;
    private final InvokerSyncRepository invokerSyncRepository;
    private final OnlineSyncHistoryService onlineSyncHistoryService;
    private static final Path INVOKER_FILES_PATH = Paths.get("runtime/invoker/", new String[0]);
    private static final String SERVICE = "Invoker File";
    private static final Logger logger = LoggerFactory.getLogger(InvokerSyncServiceImp.class);

    public InvokerSyncServiceImp(InvokerService invokerService, InvokerSyncRepository invokerSyncRepository, OnlineSyncHistoryService onlineSyncHistoryService, ApiFactory apiFactory) {
        this.invokerService = invokerService;
        this.invokerSyncRepository = invokerSyncRepository;
        this.onlineSyncHistoryService = onlineSyncHistoryService;
        this.invokerModule = ((ServicePortal)apiFactory.get(ApiType.SERVICE_PORTAL).features()).invoker();
    }

    @Transactional
    public void updateSync(String invokerName) {
        File invokerFile = this.invokerService.findFileByInvokerName(invokerName);
        Path filepath = invokerFile.toPath();
        try {
            byte[] xmlBytes = Files.readAllBytes(filepath);
            String ocFileName = filepath.getFileName().toString();
            String contentHmac = HmacUtility.encode((byte[])xmlBytes);
            InvokerSync sync = new InvokerSync();
            Optional optionalSync = this.invokerSyncRepository.findByInvokerName(invokerName);
            if (optionalSync.isPresent()) {
                sync = (InvokerSync)optionalSync.get();
                sync.setOcInvokerFileName(ocFileName);
                sync.setInvokerContentHmac(contentHmac);
                sync.setManuallyModified(false);
            } else {
                sync.setInvokerName(invokerName);
                sync.setOcInvokerFileName(ocFileName);
                sync.setSpInvokerFileName(ocFileName);
                sync.setInvokerContentHmac(contentHmac);
                sync.setManuallyModified(false);
            }
            this.saveOrUpdate(sync);
        }
        catch (Exception e) {
            logger.warn("Failed to update content hmac for invoker = " + invokerName, (Throwable)e);
        }
    }

    public void delete(String invokerName) {
        this.invokerSyncRepository.findByInvokerName(invokerName).ifPresent(arg_0 -> ((InvokerSyncRepository)this.invokerSyncRepository).delete(arg_0));
    }

    public boolean isManuallyModified(String invokerName) {
        return this.invokerSyncRepository.findByInvokerName(invokerName).map(InvokerSync::isManuallyModified).orElse(false);
    }

    @Transactional
    public void forceSync(String invokerName) {
        InvokerSync sync = (InvokerSync)this.invokerSyncRepository.findByInvokerName(invokerName).orElseThrow(() -> new RuntimeException("Invoker with name = '" + invokerName + "' not found."));
        byte[] xmlBytes = (byte[])this.invokerModule.getInvokerFileByName(sync.getSpInvokerFileName()).getBody();
        Objects.requireNonNull(xmlBytes);
        try {
            String ocFileName = sync.getOcInvokerFileName();
            String contentHmac = this.saveOrUpdateInvokerFile(xmlBytes, ocFileName);
            sync.setInvokerContentHmac(contentHmac);
            sync.setManuallyModified(false);
            this.saveOrUpdate(sync);
            this.onlineSyncHistoryService.save(this.getCurrentUsername(), "Invoker File", List.of(ocFileName));
        }
        catch (Exception e) {
            logger.warn("Failed to force sync invoker file", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Transactional(noRollbackFor={Exception.class})
    public void syncInvokers() {
        this.recalculateSyncData();
        byte[] zipBytes = (byte[])this.invokerModule.getAllInvokerFiles().getBody();
        Objects.requireNonNull(zipBytes);
        ArrayList<String> details = new ArrayList<String>();
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zipBytes));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getName().endsWith(".xml")) {
                    byte[] xmlBytes = zis.readAllBytes();
                    String invokerName = InvokerSyncServiceImp.extractInvokerName((byte[])xmlBytes);
                    String spFileName = entry.getName();
                    InvokerSync sync = new InvokerSync();
                    Optional optionalSync = this.invokerSyncRepository.findByInvokerName(invokerName);
                    if (optionalSync.isPresent()) {
                        sync = (InvokerSync)optionalSync.get();
                        if (!sync.isManuallyModified()) {
                            contentHmac = this.saveOrUpdateInvokerFile(xmlBytes, sync.getOcInvokerFileName());
                            details.add(sync.getOcInvokerFileName());
                            sync.setInvokerContentHmac(contentHmac);
                        }
                    } else {
                        contentHmac = this.saveOrUpdateInvokerFile(xmlBytes, spFileName);
                        details.add(spFileName);
                        sync.setInvokerName(invokerName);
                        sync.setOcInvokerFileName(spFileName);
                        sync.setInvokerContentHmac(contentHmac);
                        sync.setManuallyModified(false);
                    }
                    sync.setSpInvokerFileName(spFileName);
                    this.saveOrUpdate(sync);
                }
                zis.closeEntry();
            }
            this.invokerService.refresh();
        }
        catch (Exception e) {
            logger.warn("Failed to sync invoker files", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.onlineSyncHistoryService.save("Invoker File", details);
        }
    }

    @EventListener(value={ApplicationReadyEvent.class})
    void init() {
        this.recalculateSyncData();
    }

    private void saveOrUpdate(InvokerSync sync) {
        this.invokerSyncRepository.save((Object)sync);
    }

    private void recalculateSyncData() {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(INVOKER_FILES_PATH, "*.xml");){
            for (Path entry : stream) {
                byte[] xmlBytes = Files.readAllBytes(entry);
                String invokerName = InvokerSyncServiceImp.extractInvokerName((byte[])xmlBytes);
                String ocFileName = entry.getFileName().toString();
                String contentHmac = HmacUtility.encode((byte[])xmlBytes);
                InvokerSync sync = new InvokerSync();
                Optional optionalSync = this.invokerSyncRepository.findByInvokerName(invokerName);
                if (optionalSync.isPresent()) {
                    sync = (InvokerSync)optionalSync.get();
                    boolean isContentChanged = !Objects.equals(contentHmac, sync.getInvokerContentHmac());
                    sync.setManuallyModified(isContentChanged);
                    sync.setOcInvokerFileName(ocFileName);
                } else {
                    sync.setInvokerName(invokerName);
                    sync.setOcInvokerFileName(ocFileName);
                    sync.setSpInvokerFileName(ocFileName);
                    sync.setInvokerContentHmac(contentHmac);
                    sync.setManuallyModified(false);
                }
                this.saveOrUpdate(sync);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to calculate sync data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static String extractInvokerName(byte[] xmlBytes) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlBytes);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(inputStream);
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        String expression = "//invoker/name";
        return xpath.evaluate(expression, doc);
    }

    private String saveOrUpdateInvokerFile(byte[] xmlBytes, String ocFileName) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new ByteArrayInputStream(xmlBytes));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        Path filePath = Paths.get("runtime/invoker/", ocFileName);
        byte[] backupBytes = null;
        if (Files.exists(filePath, new LinkOption[0])) {
            backupBytes = Files.readAllBytes(filePath);
        }
        try (FileOutputStream output = new FileOutputStream(filePath.toFile());){
            StreamResult result = new StreamResult(output);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            if (backupBytes != null) {
                Files.write(filePath, backupBytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            throw e;
        }
        byte[] updatedXmlBytes = Files.readAllBytes(filePath);
        return HmacUtility.encode((byte[])updatedXmlBytes);
    }

    public String getCurrentUsername() {
        Object object;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && (object = authentication.getPrincipal()) instanceof UserDetails) {
            UserDetails userDetails = (UserDetails)object;
            return userDetails.getUsername();
        }
        return null;
    }
}

