/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.ExtraOps;
import com.becon.opencelium.backend.database.mysql.entity.Subscription;
import com.becon.opencelium.backend.database.mysql.repository.ExtraOpsRepository;
import com.becon.opencelium.backend.database.mysql.service.ExtraOpsService;
import com.becon.opencelium.backend.subscription.dto.EncryptedExtraOpsFile;
import com.becon.opencelium.backend.subscription.dto.ExtraOpsDTO;
import com.becon.opencelium.backend.subscription.dto.LicenseKey;
import com.becon.opencelium.backend.subscription.enums.ExtraOpsStatus;
import com.becon.opencelium.backend.subscription.quartz.ExtraOpsJob;
import com.becon.opencelium.backend.subscription.utility.LicenseKeyUtility;
import com.becon.opencelium.backend.subscription.utility.MonthPeriod;
import com.becon.opencelium.backend.utility.crypto.CryptoUtil;
import com.becon.opencelium.backend.utility.crypto.HmacUtility;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.transaction.Transactional;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExtraOpsServiceImp
implements ExtraOpsService {
    private final ExtraOpsRepository extraOpsRepository;
    private final Scheduler scheduler;
    Logger logger = LoggerFactory.getLogger(ExtraOpsServiceImp.class);

    public ExtraOpsServiceImp(ExtraOpsRepository extraOpsRepository, Scheduler scheduler) {
        this.extraOpsRepository = extraOpsRepository;
        this.scheduler = scheduler;
    }

    public EncryptedExtraOpsFile decrypt(String encryptedExtraOpsDTO) {
        try {
            byte[] decryptData = CryptoUtil.decrypt((String)encryptedExtraOpsDTO, (String)"MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAnj2andeiYdgRAp1jkLej/xgslVEN+qodRNjguHNBV2gKHim9VXCvakAZveUqXN7/L7R+wlDrlnjLDWV5cN4aWDQFPKK0YcH+A1oSI7m/SbBaeyQSwH5PT/kYG0AU3C1FItoshhDKDhvSMk5iUJc66ZXRg4xBH9x3jOfKHRrvJlLRx8NX+WLPJNLpVog/an2lmDqWw2AsJYgf8p18baCavHKil39e8gDNizAQhQdC1yEK4RLgtsmGFGnrhCjNaZ/+NriYE4D/CK71QT4d//eF4LNgBqIGEPRb4ekt9qUH2T6F5XqiR90BFRLTyMv0ASos+k25GQqHS7WRjUHUOu0F1UL9POtjLCVj39q9U9ip6G3UYTNJ7gF6wUpzwmqQuLID4Bx3YOT7GeaiPc2AdlQlT5MbFSBMqHXcsScHfEQU2IPb2iYowLoKH7nqrCHOtR83/CDbzKKCHm0R072QmFh+67YPL3U1Vg+zrT4emlEYSM3gdOrcb4Wgm85+sUs3aoWmRPsDITUG+vqAbZ2C/gxgEmlVZzbKgH4NpFIO/eh7oW7cWXyJ+2Fc07T/NRs1UBAR6cjpZBFeVKIgIsWay6sFffOyv1lUM0DRvtM53BgaXV2V5TUbOzKlM+d2jBqlrCeq6TpJVG6FCrJsaaOgSq6Zgt5JLtdbtZqZtnYndk3FT78CAwEAAQ==");
            ObjectMapper objectMapper = new ObjectMapper();
            return (EncryptedExtraOpsFile)objectMapper.readValue(decryptData, EncryptedExtraOpsFile.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void save(ExtraOps extraOps) {
        String hmac = this.constructHmac(extraOps, extraOps.getCurrentOpsUsage());
        if (!hmac.equals(extraOps.getCurrentOpsUsageHmac())) {
            throw new RuntimeException("Current usage was changed manually in Extra Ops");
        }
        hmac = this.constructHmac(extraOps, extraOps.getTotalOpsUsage());
        if (!hmac.equals(extraOps.getTotalOpsUsageHmac())) {
            throw new RuntimeException("Total usage was changed manually in Extra Ops");
        }
        if (!this.extraOpsRepository.existsByStatus(ExtraOpsStatus.ACTIVE) && extraOps.getStatus() != ExtraOpsStatus.CONSUMED && extraOps.getStatus() != ExtraOpsStatus.EXPIRED) {
            extraOps.setStatus(ExtraOpsStatus.ACTIVE);
        }
        this.extraOpsRepository.save((Object)extraOps);
        this.schedulerExpireDateForExtraOps(extraOps.getId().longValue(), extraOps.getEndDate());
    }

    public void delete(Long id) {
        this.extraOpsRepository.deleteById((Object)id);
    }

    public void deleteList(List<Long> ids) {
        this.extraOpsRepository.deleteAllById(ids);
    }

    public Optional<ExtraOps> findById(long extraOpsId) {
        return this.extraOpsRepository.findById((Object)extraOpsId);
    }

    public ExtraOpsDTO toDTO(ExtraOps extraOps) {
        ExtraOpsDTO extraOpsDTO = new ExtraOpsDTO();
        extraOpsDTO.setId(extraOps.getId().longValue());
        extraOpsDTO.setLicenseId(extraOps.getSubscription().getLicenseId());
        extraOpsDTO.setTotalOpsUsage(extraOps.getTotalOpsUsage());
        extraOpsDTO.setCurrentOpsUsage(extraOps.getCurrentOpsUsage());
        extraOpsDTO.setEndDate(this.convertToUnixMillis(extraOps.getEndDate()));
        extraOpsDTO.setActivationDate(this.convertToUnixMillis(extraOps.getStartDate()));
        extraOpsDTO.setGeneratedAt(extraOps.getGeneratedAt());
        extraOpsDTO.setStatus(extraOps.getStatus());
        return extraOpsDTO;
    }

    public ExtraOps toEntityFromEncryption(EncryptedExtraOpsFile encryptedExtraOpsFile, LicenseKey licenseKey) {
        long currentInMillis = System.currentTimeMillis();
        LocalDateTime startDate = Instant.ofEpochMilli(currentInMillis).atZone(ZoneId.of("UTC")).toLocalDateTime();
        MonthPeriod monthPeriod = LicenseKeyUtility.getCurrentMonthPeriod((long)licenseKey.getStartDate());
        LocalDateTime endDate = Instant.ofEpochMilli(monthPeriod.getStartDate()).atZone(ZoneId.of("UTC")).toLocalDateTime();
        String hmacTotal = this.constructHmac(encryptedExtraOpsFile, encryptedExtraOpsFile.getTotalOpsUsage());
        long currentUsage = 0L;
        String hmacCurrent = this.constructHmac(encryptedExtraOpsFile, currentUsage);
        ExtraOps extraOps = new ExtraOps();
        extraOps.setEndDate(endDate);
        extraOps.setStartDate(startDate);
        extraOps.setTotalOpsUsage(encryptedExtraOpsFile.getTotalOpsUsage());
        extraOps.setTotalOpsUsageHmac(hmacTotal);
        extraOps.setCurrentOpsUsage(currentUsage);
        extraOps.setCurrentOpsUsageHmac(hmacCurrent);
        extraOps.setStatus(ExtraOpsStatus.PENDING);
        extraOps.setGeneratedAt(encryptedExtraOpsFile.getGeneratedAt());
        return extraOps;
    }

    public void update(ExtraOps extraOps) {
    }

    @Transactional
    public void updateExtraOpsForSubscription(Subscription sub, long opsUsage) {
        while (opsUsage > 0L) {
            Optional<ExtraOps> extraOpsOptional = sub.getExtraOpsList().stream().filter(e -> e.getStatus() == ExtraOpsStatus.ACTIVE).findFirst();
            if (extraOpsOptional.isEmpty()) {
                extraOpsOptional = sub.getExtraOpsList().stream().filter(e -> e.getStatus() == ExtraOpsStatus.PENDING).min(Comparator.comparing(ExtraOps::getCreatedAt));
            }
            if (extraOpsOptional.isEmpty()) {
                this.logger.warn("No available ExtraOps found for subscription: {}", (Object)sub.getId());
                return;
            }
            Optional optionalExtraOps = this.extraOpsRepository.findAndLockById(extraOpsOptional.get().getId());
            if (optionalExtraOps.isEmpty()) {
                throw new RuntimeException("Extra ops not found during usage update: " + extraOpsOptional.get().getId());
            }
            ExtraOps extraOps = (ExtraOps)optionalExtraOps.get();
            String expectedHmac = this.constructHmac(extraOps, extraOps.getCurrentOpsUsage());
            if (!expectedHmac.equals(extraOps.getCurrentOpsUsageHmac())) {
                throw new IllegalStateException("HMAC validation failed for ExtraOps id: " + extraOps.getId());
            }
            long availableOps = extraOps.getTotalOpsUsage() - extraOps.getCurrentOpsUsage();
            if (opsUsage >= availableOps) {
                extraOps.setCurrentOpsUsage(extraOps.getTotalOpsUsage());
                extraOps.setCurrentOpsUsageHmac(this.constructHmac(extraOps, extraOps.getTotalOpsUsage()));
                extraOps.setStatus(ExtraOpsStatus.CONSUMED);
                opsUsage = availableOps - opsUsage;
            } else {
                long operationUsage = extraOps.getCurrentOpsUsage() + opsUsage;
                extraOps.setCurrentOpsUsage(operationUsage);
                extraOps.setCurrentOpsUsageHmac(this.constructHmac(extraOps, operationUsage));
                if (extraOps.getStatus() == ExtraOpsStatus.PENDING) {
                    extraOps.setStatus(ExtraOpsStatus.ACTIVE);
                }
                opsUsage = 0L;
            }
            this.save(extraOps);
        }
    }

    public String constructHmac(ExtraOps extraOps, long usage) {
        return HmacUtility.encode((String)(extraOps.getSubscription().getLicenseId() + extraOps.getGeneratedAt() + usage));
    }

    public String constructHmac(EncryptedExtraOpsFile encryptExtraOps, long usage) {
        return HmacUtility.encode((String)(encryptExtraOps.getLicenseId() + encryptExtraOps.getGeneratedAt() + usage));
    }

    public boolean existsByGeneratedAt(long generatedAt) {
        return this.extraOpsRepository.existsByGeneratedAt(generatedAt);
    }

    private LocalDateTime getLastDayOfMonthFromCurrentTime(long millis) {
        LocalDateTime dateTime = Instant.ofEpochMilli(millis).atZone(ZoneId.of("UTC")).toLocalDateTime();
        LocalDate lastDay = dateTime.toLocalDate().with(TemporalAdjusters.lastDayOfMonth());
        return LocalDateTime.of(lastDay, dateTime.toLocalTime());
    }

    private void schedulerExpireDateForExtraOps(long extraOpsId, LocalDateTime endDate) {
        try {
            Date triggerDate = Date.from(endDate.atZone(ZoneId.of("UTC")).toInstant());
            String jobKey = "ExtraOpsJob-" + extraOpsId;
            String groupKey = "ExtraOpsJobs";
            JobKey jobIdentity = new JobKey(jobKey, groupKey);
            if (this.scheduler.checkExists(jobIdentity)) {
                return;
            }
            JobDetail job = JobBuilder.newJob(ExtraOpsJob.class).withIdentity(jobKey, groupKey).usingJobData("extraOpsId", Long.valueOf(extraOpsId)).build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("ExtraOpsJobTrigger" + extraOpsId, "ExtraOpsJobTriggers").startAt(triggerDate).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule()).build();
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private long convertToUnixMillis(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.of("UTC")).toInstant().toEpochMilli();
    }
}

