/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.constant.props.ConnectorProps;
import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.entity.RequestData;
import com.becon.opencelium.backend.database.mysql.repository.ConnectorRepository;
import com.becon.opencelium.backend.database.mysql.service.ConnectorService;
import com.becon.opencelium.backend.database.mysql.service.RequestDataService;
import com.becon.opencelium.backend.database.mysql.service.RequestDataServiceImp;
import com.becon.opencelium.backend.exception.ConnectorAlreadyExistsException;
import com.becon.opencelium.backend.exception.ConnectorNotFoundException;
import com.becon.opencelium.backend.exception.GeneralServiceException;
import com.becon.opencelium.backend.execution.rdata.RequiredDataService;
import com.becon.opencelium.backend.execution.rdata.RequiredDataServiceImp;
import com.becon.opencelium.backend.invoker.InvokerRequestBuilder;
import com.becon.opencelium.backend.invoker.entity.FunctionInvoker;
import com.becon.opencelium.backend.invoker.entity.Invoker;
import com.becon.opencelium.backend.invoker.entity.RequiredData;
import com.becon.opencelium.backend.invoker.service.InvokerService;
import com.becon.opencelium.backend.resource.connector.ConnectorResource;
import com.becon.opencelium.backend.utility.crypto.Encoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ConnectorServiceImp
implements ConnectorService {
    private final ConnectorProps connectorProps;
    private final ConnectorRepository connectorRepository;
    private final InvokerService invokerService;
    private final Encoder encoder;
    private final RequestDataService requestDataService;
    private final Environment env;

    public ConnectorServiceImp(ConnectorProps connectorProps, ConnectorRepository connectorRepository, @Qualifier(value="invokerServiceImp") InvokerService invokerService, @Qualifier(value="requestDataServiceImp") RequestDataServiceImp requestDataService, Encoder encoder, Environment env) {
        this.connectorProps = connectorProps;
        this.connectorRepository = connectorRepository;
        this.invokerService = invokerService;
        this.encoder = encoder;
        this.requestDataService = requestDataService;
        this.env = env;
    }

    public Optional<Connector> findById(int id) {
        Optional optional = this.connectorRepository.findById((Object)id);
        try {
            optional.ifPresent(arg_0 -> this.decrypt(arg_0));
            return optional;
        }
        catch (RuntimeException e) {
            Connector saved = this.save((Connector)optional.get());
            return Optional.of(saved);
        }
    }

    public Connector getById(Integer id) {
        return (Connector)this.findById(id.intValue()).orElseThrow(() -> new ConnectorNotFoundException(id.intValue()));
    }

    public Connector save(Connector connector) {
        this.encrypt(connector);
        List requestData = connector.getRequestData();
        connector.setRequestData(null);
        Connector saved = (Connector)this.connectorRepository.save((Object)connector);
        requestData.forEach(r -> r.setConnector(saved));
        List savedRD = this.requestDataService.saveAll(requestData);
        saved.setRequestData(savedRD);
        this.decrypt(saved);
        return saved;
    }

    public void saveAll(List<Connector> connectors) {
        connectors.forEach(arg_0 -> this.encrypt(arg_0));
        connectors.forEach(c -> {
            c.getRequestData().forEach(r -> r.setConnector(c));
            this.requestDataService.saveAll(c.getRequestData());
            c.setRequestData(new ArrayList());
        });
        this.connectorRepository.saveAll(connectors);
    }

    public void deleteById(int id) {
        this.connectorRepository.deleteById((Object)id);
    }

    public void deleteByInvoker(String invokerName) {
        this.connectorRepository.deleteByInvoker(invokerName);
    }

    public boolean existsById(int id) {
        return this.connectorRepository.existsById((Object)id);
    }

    public boolean existByTitle(String title) {
        return this.connectorRepository.existsByTitle(title);
    }

    public boolean existByInvoker(String invokerName) {
        return this.connectorRepository.existsByInvoker(invokerName);
    }

    public List<Connector> findAllByInvoker(String invokerName) {
        List list = this.connectorRepository.findAllByInvoker(invokerName);
        if (list != null && !list.isEmpty()) {
            list.forEach(arg_0 -> this.decrypt(arg_0));
        }
        return list;
    }

    public List<Connector> findAll() {
        List list = this.connectorRepository.findAll();
        if (!list.isEmpty()) {
            list.forEach(arg_0 -> this.decrypt(arg_0));
        }
        return list;
    }

    public List<Connector> findAllByTitleContains(String title) {
        List list = this.connectorRepository.findAllByTitleContains(title);
        if (list != null && !list.isEmpty()) {
            list.forEach(arg_0 -> this.decrypt(arg_0));
        }
        return list;
    }

    public Optional<Connector> findAllByTitle(String title) {
        Optional connector = this.connectorRepository.findByTitle(title);
        connector.ifPresent(arg_0 -> this.decrypt(arg_0));
        return connector;
    }

    public Boolean existsMasterPassword() {
        return StringUtils.isNotBlank((CharSequence)this.connectorProps.getMasterPassword());
    }

    public ResponseEntity<?> checkCommunication(Connector connector) {
        InvokerRequestBuilder invokerRequestBuilder = new InvokerRequestBuilder();
        FunctionInvoker function = this.invokerService.getTestFunction(connector.getInvoker());
        List requestData = this.buildRequestData(connector);
        String port = this.env.getProperty("opencelium.rest_template.proxy.port");
        String host = this.env.getProperty("opencelium.rest_template.proxy.host");
        String user = this.env.getProperty("opencelium.rest_template.proxy.username");
        String password = this.env.getProperty("opencelium.rest_template.proxy.password");
        return invokerRequestBuilder.setFunction(function).setRequestData(requestData).setProxyHost(host).setProxyPort(port).setProxyUser(user).setProxyPass(password).setTimeout(connector.getTimeout()).setSslCert(connector.isSslValidation()).sendRequest();
    }

    public ResponseEntity<?> getAuthorization(Connector connector) {
        InvokerRequestBuilder invokerRequestBuilder = new InvokerRequestBuilder();
        FunctionInvoker function = this.invokerService.getAuthFunction(connector.getInvoker());
        return invokerRequestBuilder.setFunction(function).setRequestData(connector.getRequestData()).sendRequest();
    }

    public List<RequestData> buildRequestData(Connector connector) {
        Invoker invoker = this.invokerService.findByName(connector.getInvoker());
        List requiredData = invoker.getRequiredData();
        List requestData = connector.getRequestData();
        requiredData.forEach(rqd -> this.addFieldIfNotExists(requestData, rqd));
        RequiredDataServiceImp requiredDataService = new RequiredDataServiceImp(connector, requestData, invoker.getOperations());
        requestData.forEach(arg_0 -> ConnectorServiceImp.lambda$buildRequestData$5((RequiredDataService)requiredDataService, arg_0));
        return requestData;
    }

    public Connector update(Integer connectorId, ConnectorResource connectorResource) {
        Connector connector = (Connector)this.connectorRepository.findById((Object)connectorId).orElseThrow(() -> new ConnectorNotFoundException(connectorId.intValue()));
        if (this.existByTitle(connectorResource.getTitle()) && !connector.getTitle().equals(connectorResource.getTitle())) {
            throw new ConnectorAlreadyExistsException(connectorResource.getTitle());
        }
        connector.setTitle(connectorResource.getTitle());
        connector.setIcon(connectorResource.getIcon());
        connector.setDescription(connectorResource.getDescription());
        connector.setSslValidation(connectorResource.isSslCert());
        connector.setTimeout(connectorResource.getTimeout());
        this.connectorRepository.save((Object)connector);
        this.decrypt(connector);
        return connector;
    }

    public void updateRequestData(Integer connectorId, Map<String, String> newRequestDataMap) {
        Connector connector = this.getById(connectorId);
        Map<String, RequestData> existingMap = connector.getRequestData().stream().collect(Collectors.toMap(RequestData::getField, rd -> rd));
        for (Map.Entry<String, String> entry : newRequestDataMap.entrySet()) {
            String field = entry.getKey();
            String value = entry.getValue();
            RequestData existing = existingMap.get(field);
            if (existing == null) {
                throw new GeneralServiceException("REQUIRED_DATA_NOT_FOUND", "'%s' required data not found".formatted(field));
            }
            existing.setValue(this.encoder.encrypt(value));
        }
        this.requestDataService.saveAll(connector.getRequestData());
    }

    public void verifyMasterPassword(String masterPassword) {
        if (Objects.isNull(masterPassword)) {
            throw new GeneralServiceException(HttpStatus.BAD_REQUEST, "MASTER_PASSWORD_IS_MISSING_IN_HEADER", "master_password is missing or empty");
        }
        if (StringUtils.isBlank((CharSequence)this.connectorProps.getMasterPassword())) {
            throw new GeneralServiceException(HttpStatus.BAD_REQUEST, "MASTER_PASSWORD_NOT_EXIST", "%s is not set in the application.yml file".formatted("opencelium.connector.master-password"));
        }
        if (!Objects.equals(this.connectorProps.getMasterPassword(), masterPassword)) {
            throw new GeneralServiceException(HttpStatus.BAD_REQUEST, "MASTER_PASSWORD_WRONG", "Invalid master password");
        }
    }

    private void addFieldIfNotExists(List<RequestData> requestData, RequiredData rqd) {
        if (requestData.stream().noneMatch(rqsd -> rqsd.getField().equals(rqd.getName()))) {
            requestData.add(new RequestData(rqd));
        }
    }

    private void encrypt(Connector connector) {
        List requestData = connector.getRequestData();
        if (requestData != null) {
            requestData.forEach(e -> e.setValue(this.encoder.encrypt(e.getValue())));
        }
    }

    private void decrypt(Connector connector) {
        List requestData = connector.getRequestData();
        requestData.forEach(e -> e.setValue(this.encoder.decrypt(e.getValue())));
    }

    private static /* synthetic */ void lambda$buildRequestData$5(RequiredDataService requiredDataService, RequestData rqsd) {
        String value = requiredDataService.getValue(rqsd).orElse(null);
        rqsd.setValue(value);
    }
}

