/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.constant.props.OpenceliumProps;
import com.becon.opencelium.backend.container.Command;
import com.becon.opencelium.backend.container.ConnectionUpdateTracker;
import com.becon.opencelium.backend.database.mongodb.entity.ConnectionMng;
import com.becon.opencelium.backend.database.mongodb.entity.FieldBindingMng;
import com.becon.opencelium.backend.database.mongodb.service.ConnectionMngService;
import com.becon.opencelium.backend.database.mongodb.service.ConnectionMngServiceImp;
import com.becon.opencelium.backend.database.mongodb.service.FieldBindingMngService;
import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.entity.Enhancement;
import com.becon.opencelium.backend.database.mysql.entity.MaskingRule;
import com.becon.opencelium.backend.database.mysql.repository.ConnectionRepository;
import com.becon.opencelium.backend.database.mysql.repository.MaskingRuleRepository;
import com.becon.opencelium.backend.database.mysql.service.CategoryService;
import com.becon.opencelium.backend.database.mysql.service.ConnectionHistoryService;
import com.becon.opencelium.backend.database.mysql.service.ConnectionService;
import com.becon.opencelium.backend.database.mysql.service.ConnectorService;
import com.becon.opencelium.backend.database.mysql.service.EnhancementService;
import com.becon.opencelium.backend.database.mysql.service.SchedulerService;
import com.becon.opencelium.backend.database.mysql.service.WebhookService;
import com.becon.opencelium.backend.enums.Action;
import com.becon.opencelium.backend.exception.ConnectionNotFoundException;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.resource.PatchConnectionDetails;
import com.becon.opencelium.backend.resource.connection.ConnectionDTO;
import com.becon.opencelium.backend.resource.connection.ConnectorDTO;
import com.becon.opencelium.backend.resource.connection.masking.RuleDTO;
import com.becon.opencelium.backend.resource.webhook.WebhookParamDTO;
import com.becon.opencelium.backend.utility.LogFileUtility;
import com.becon.opencelium.backend.utility.patch.PatchHelper;
import com.becon.opencelium.backend.versionmanager.EntityUpdater;
import com.becon.opencelium.backend.versionmanager.EntityVersionManager;
import com.becon.opencelium.backend.versionmanager.backup.MongoDbBackupService;
import com.becon.opencelium.backend.versionmanager.backup.MysqlBackupService;
import com.becon.opencelium.backend.versionmanager.base.Utils;
import com.github.fge.jsonpatch.JsonPatch;
import jakarta.persistence.EntityNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConnectionServiceImp
implements ConnectionService {
    private static final Logger log = LoggerFactory.getLogger(ConnectionServiceImp.class);
    private final ConnectionRepository connectionRepository;
    private final ConnectorService connectorService;
    private final ConnectionMngService connectionMngService;
    private final FieldBindingMngService fieldBindingMngService;
    private final EnhancementService enhancementService;
    private final CategoryService categoryService;
    private final ConnectionHistoryService connectionHistoryService;
    private final SchedulerService schedulerService;
    private final Mapper<Connector, ConnectorDTO> connectorMapper;
    private final Mapper<ConnectionMng, ConnectionDTO> connectionMngMapper;
    private final Mapper<Connection, ConnectionDTO> connectionMapper;
    private final ConnectionUpdateTracker updateTracker;
    private final MaskingRuleRepository ruleRepository;
    private final PatchHelper patchHelper;
    private final WebhookService webhookService;
    private final OpenceliumProps ocProps;
    private final EntityUpdater<ConnectionMng> connectionMngEntityUpdater;
    private final EntityUpdater<Enhancement> enhancementEntityUpdater;
    private final MysqlBackupService mysqlBackupService;
    private final MongoDbBackupService mongoDbBackupService;

    public ConnectionServiceImp(ConnectionRepository connectionRepository, @Qualifier(value="connectorServiceImp") ConnectorService connectorService, @Qualifier(value="connectionMngServiceImp") ConnectionMngServiceImp connectionMngService, @Qualifier(value="fieldBindingMngServiceImp") FieldBindingMngService fieldBindingMngService, @Qualifier(value="enhancementServiceImp") EnhancementService enhancementService, @Qualifier(value="categoryServiceImp") CategoryService categoryService, @Qualifier(value="connectionHistoryServiceImp") ConnectionHistoryService connectionHistoryService, @Qualifier(value="schedulerServiceImp") SchedulerService schedulerService, @Qualifier(value="webhookServiceImp") WebhookService webhookService, PatchHelper patchHelper, Mapper<Connector, ConnectorDTO> connectorMapper, Mapper<ConnectionMng, ConnectionDTO> connectionMngMapper, Mapper<Connection, ConnectionDTO> connectionMapper, ConnectionUpdateTracker updateTracker, MaskingRuleRepository ruleRepository, EntityVersionManager entityVersionManager, OpenceliumProps ocProps, MysqlBackupService mysqlBackupService, MongoDbBackupService mongoDbBackupService) {
        this.connectionRepository = connectionRepository;
        this.connectorService = connectorService;
        this.fieldBindingMngService = fieldBindingMngService;
        this.connectionMngService = connectionMngService;
        this.enhancementService = enhancementService;
        this.categoryService = categoryService;
        this.patchHelper = patchHelper;
        this.connectorMapper = connectorMapper;
        this.connectionMngMapper = connectionMngMapper;
        this.connectionMapper = connectionMapper;
        this.updateTracker = updateTracker;
        this.connectionHistoryService = connectionHistoryService;
        this.schedulerService = schedulerService;
        this.webhookService = webhookService;
        this.ruleRepository = ruleRepository;
        this.ocProps = ocProps;
        this.connectionMngEntityUpdater = entityVersionManager.getUpdater(ConnectionMng.class);
        this.enhancementEntityUpdater = entityVersionManager.getUpdater(Enhancement.class);
        this.mysqlBackupService = mysqlBackupService;
        this.mongoDbBackupService = mongoDbBackupService;
    }

    @Transactional
    public ConnectionMng save(Connection connection, ConnectionMng connectionMng) {
        if (this.existsByName(connection.getTitle())) {
            throw new RuntimeException("TITLE_HAS_ALREADY_TAKEN");
        }
        Connector from = this.connectorService.getById(Integer.valueOf(connection.getToConnector()));
        Connector to = this.connectorService.getById(Integer.valueOf(connection.getFromConnector()));
        connectionMng.getFromConnector().setTitle(from.getTitle());
        connectionMng.getToConnector().setTitle(to.getTitle());
        connectionMng.getFromConnector().setFlowId(UUID.randomUUID().toString());
        connectionMng.getToConnector().setFlowId(UUID.randomUUID().toString());
        if (connection.getCategoryId() != null) {
            this.categoryService.get(connection.getCategoryId());
        }
        List enhancements = connection.getEnhancements();
        connection.setOcVersion(this.ocProps.getVersion());
        connection.setEnhancements(null);
        Connection savedConnection = (Connection)this.connectionRepository.save((Object)connection);
        if (enhancements != null && !enhancements.isEmpty()) {
            enhancements.forEach(enhancement -> enhancement.setConnection(savedConnection));
            enhancements = this.enhancementService.saveAll(enhancements);
            for (int i = 0; i < connectionMng.getFieldBindings().size(); ++i) {
                ((FieldBindingMng)connectionMng.getFieldBindings().get(i)).setEnhancementId(((Enhancement)enhancements.get(i)).getId());
            }
        }
        connectionMng.setConnectionId(savedConnection.getId());
        ConnectionMng savedMng = this.connectionMngService.save(connectionMng);
        this.connectionHistoryService.makeHistoryAndSave(savedConnection, null, Action.CREATE);
        return savedMng;
    }

    @Transactional
    public void update(Connection connection, ConnectionMng connectionMng) {
        Connection sCon = this.getById(connection.getId());
        if (!Objects.equals(sCon.getTitle(), connection.getTitle()) && this.existsByName(connection.getTitle())) {
            throw new RuntimeException("TITLE_HAS_ALREADY_TAKEN");
        }
        ConnectionMng oldMng = this.connectionMngService.getByConnectionId(connection.getId());
        if (connectionMng.getId() == null || !oldMng.getId().equals(connectionMng.getId())) {
            connectionMng.setId(oldMng.getId());
        }
        Connector from = this.connectorService.getById(Integer.valueOf(connection.getToConnector()));
        Connector to = this.connectorService.getById(Integer.valueOf(connection.getFromConnector()));
        connectionMng.getFromConnector().setTitle(from.getTitle());
        connectionMng.getToConnector().setTitle(to.getTitle());
        connectionMng.getFromConnector().setFlowId(oldMng.getFromConnector().getFlowId());
        connectionMng.getToConnector().setFlowId(oldMng.getToConnector().getFlowId());
        if (connection.getCategoryId() != null && !connection.getCategoryId().equals(sCon.getCategoryId())) {
            this.categoryService.get(connection.getCategoryId());
        }
        List enhancements = connection.getEnhancements();
        connection.setEnhancements(null);
        List newFieldBindings = this.getNewEnhancements(oldMng, connectionMng);
        for (FieldBindingMng fb : newFieldBindings) {
            if (fb.getEnhancementId() == null) continue;
            enhancements.stream().filter(e -> fb.getEnhancementId().equals(e.getId())).forEach(en -> en.setId(null));
        }
        List fieldBindingsToDelete = this.getEnhancementsToDelete(oldMng, connectionMng);
        fieldBindingsToDelete.forEach(f -> this.enhancementService.deleteById(f.getEnhancementId()));
        connection.setOcVersion(this.ocProps.getVersion());
        Connection savedConnection = (Connection)this.connectionRepository.save((Object)connection);
        if (enhancements != null && !enhancements.isEmpty()) {
            enhancements.forEach(enhancement -> enhancement.setConnection(savedConnection));
            this.enhancementService.saveAll(enhancements);
            for (int i = 0; i < connectionMng.getFieldBindings().size(); ++i) {
                ((FieldBindingMng)connectionMng.getFieldBindings().get(i)).setEnhancementId(((Enhancement)enhancements.get(i)).getId());
            }
        }
        connectionMng.setConnectionId(savedConnection.getId());
        this.connectionMngService.updateAndBind(oldMng, connectionMng);
    }

    public Long createEmptyConnection() {
        Connection connection = new Connection();
        connection.setOcVersion(this.ocProps.getVersion());
        Connection saved = (Connection)this.connectionRepository.save((Object)connection);
        ConnectionMng connectionMng = new ConnectionMng();
        connectionMng.setConnectionId(saved.getId());
        connectionMng.setVersion(this.ocProps.getVersion());
        this.connectionMngService.saveDirectly(connectionMng);
        this.connectionHistoryService.makeHistoryAndSave(saved, null, Action.CREATE);
        return saved.getId();
    }

    @Transactional
    public void patchUpdate(Long connectionId, JsonPatch patch, PatchConnectionDetails details) {
        ConnectionDTO connectionDTO = this.getFullConnection(connectionId);
        ConnectionDTO patched = this.patchUpdateInternal(connectionDTO, patch, details);
        this.updateTracker.pushAndMakeHistory(connectionDTO, patched, patch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo(Long connectionId) {
        Class<ConnectionUpdateTracker> clazz = ConnectionUpdateTracker.class;
        synchronized (ConnectionUpdateTracker.class) {
            Command command = this.updateTracker.undo(connectionId);
            if (command != null) {
                try {
                    PatchConnectionDetails details = this.patchHelper.describe(command.getJsonPatch());
                    ConnectionDTO connectionDTO = this.getFullConnection(connectionId);
                    this.patchUpdateInternal(connectionDTO, command.getJsonPatch(), details);
                    this.connectionHistoryService.makeHistoryAndSave(new Connection(connectionId.longValue()), command.getJsonPatch(), Action.UNDO);
                }
                catch (Exception e) {
                    this.updateTracker.push(command);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Transactional
    public void deleteById(Long id) {
        ConnectionMng deleted;
        Connection connection = this.getById(id);
        this.deleteSchedules(connection);
        try {
            deleted = this.connectionMngService.delete(id);
        }
        catch (Exception e) {
            this.connectionRepository.deleteById((Object)id);
            return;
        }
        try {
            this.connectionRepository.deleteById((Object)id);
        }
        catch (Exception e) {
            this.connectionMngService.save(deleted);
            throw e;
        }
    }

    @Transactional
    public void deleteAll(List<Connection> connections) {
        if (connections == null) {
            return;
        }
        connections.forEach(c -> this.deleteById(c.getId()));
    }

    @Transactional
    public void deleteAndTrackIt(Long id) {
        ConnectionMng deleted;
        Connection connection = this.getById(id);
        this.deleteSchedules(connection);
        try {
            deleted = this.connectionMngService.delete(id);
        }
        catch (Exception e) {
            this.connectionRepository.deleteById((Object)id);
            return;
        }
        try {
            this.connectionRepository.deleteById((Object)id);
            this.connectionHistoryService.makeHistoryAndSave(connection, null, Action.DELETE);
        }
        catch (Exception e) {
            this.connectionMngService.save(deleted);
            throw e;
        }
    }

    @Transactional
    public void deleteOnlyConnection(Long id) {
        Connection connection = this.getById(id);
        this.deleteSchedules(connection);
        this.connectionRepository.deleteById((Object)id);
    }

    public Connection getById(Long id) {
        return (Connection)this.connectionRepository.findById((Object)id).orElseThrow(() -> new ConnectionNotFoundException(id));
    }

    public List<Connection> findAll() {
        return this.connectionRepository.findAll();
    }

    public List<Connection> findAllByConnectorId(int connectorId) {
        return this.connectionRepository.findAllByConnectorId(connectorId);
    }

    public List<Connection> findAllByNameContains(String name) {
        return this.connectionRepository.findAllByTitleContains(name);
    }

    public List<Connection> getAllConnectionsNotContains(List<Long> ids) {
        return this.connectionRepository.findAllByIdNotIn(ids);
    }

    public boolean existsByName(String name) {
        return this.connectionRepository.existsByTitle(name);
    }

    public boolean existsById(Long id) {
        return this.connectionRepository.existsById((Object)id);
    }

    public ConnectionDTO getFullConnection(Long connectionId) {
        ConnectorDTO temp;
        Connection connection = this.getById(connectionId);
        ConnectionMng connectionMng = this.connectionMngService.getByConnectionId(connectionId);
        ConnectionDTO connectionDTOMng = (ConnectionDTO)this.connectionMngMapper.toDTO((Object)connectionMng);
        ConnectionDTO connectionDTO = (ConnectionDTO)this.connectionMapper.toDTO((Object)connection);
        connectionDTOMng.setTitle(connectionDTO.getTitle());
        connectionDTOMng.setDescription(connectionDTO.getDescription());
        connectionDTOMng.setIcon(connectionDTO.getIcon());
        connectionDTOMng.setBusinessLayout(connectionDTO.getBusinessLayout());
        connectionDTOMng.setCategoryId(connectionDTO.getCategoryId());
        if (connectionDTOMng.getFromConnector() != null) {
            temp = connectionDTOMng.getFromConnector();
            connectionDTOMng.setFromConnector((ConnectorDTO)this.connectorMapper.toDTO((Object)this.connectorService.getById(Integer.valueOf(connection.getFromConnector()))));
            connectionDTOMng.getFromConnector().setOperators(temp.getOperators() == null ? new ArrayList() : temp.getOperators());
            connectionDTOMng.getFromConnector().setMethods(temp.getMethods() == null ? new ArrayList() : temp.getMethods());
        }
        if (connectionDTOMng.getToConnector() != null) {
            temp = connectionDTOMng.getToConnector();
            connectionDTOMng.setToConnector((ConnectorDTO)this.connectorMapper.toDTO((Object)this.connectorService.getById(Integer.valueOf(connection.getToConnector()))));
            connectionDTOMng.getToConnector().setOperators(temp.getOperators() == null ? new ArrayList() : temp.getOperators());
            connectionDTOMng.getToConnector().setMethods(temp.getMethods() == null ? new ArrayList() : temp.getMethods());
        }
        if (connectionDTOMng.getFieldBinding() == null) {
            connectionDTOMng.setFieldBinding(new ArrayList());
        }
        this.fieldBindingMngService.detach(connectionDTOMng);
        return connectionDTOMng;
    }

    public List<Connection> getAllByCategoryId(Integer categoryId) {
        return this.connectionRepository.findAllByCategoryId(categoryId);
    }

    public List<ConnectionDTO> getAllFullConnection() {
        List all = this.findAll();
        ArrayList<ConnectionDTO> res = new ArrayList<ConnectionDTO>();
        for (Connection connection : all) {
            res.add(this.getFullConnection(connection.getId()));
        }
        return res;
    }

    public List<Connection> findAllNotCompleted() {
        List all = this.findAll();
        ArrayList<Connection> res = new ArrayList<Connection>();
        for (Connection connection : all) {
            if (this.connectionMngService.existsByConnectionId(connection.getId())) continue;
            res.add(connection);
        }
        return res;
    }

    public void updateCategory(Connection connection, Integer newCategory) {
        connection.setCategoryId(newCategory);
        this.connectionRepository.save((Object)connection);
    }

    public List<WebhookParamDTO> extractVarsFromJson(String json) throws IOException {
        ArrayList webhookVarList = new ArrayList();
        this.extractVars((Object)json, webhookVarList);
        return webhookVarList.stream().map(arg_0 -> ((WebhookService)this.webhookService).toParamResource(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<MaskingRule> getAllRules(long connectionId) {
        this.throwIfConnectionNotExists(Long.valueOf(connectionId));
        return this.ruleRepository.findRulesByConnectionId(Long.valueOf(connectionId));
    }

    @Transactional(readOnly=true)
    public RuleDTO getOneRule(long connectionId, long ruleId) {
        this.throwIfConnectionNotExists(Long.valueOf(connectionId));
        MaskingRule rule = (MaskingRule)this.ruleRepository.findRuleByConnectionIdAndId(Long.valueOf(connectionId), Long.valueOf(ruleId)).orElseThrow(() -> new EntityNotFoundException("MaskingRule with ruleId = '" + ruleId + "' for connection with id = '" + connectionId + "' non exists."));
        return RuleDTO.fromEntity((MaskingRule)rule);
    }

    @Transactional
    public List<RuleDTO> saveRuleList(long connectionId, List<RuleDTO> dtos) {
        this.throwIfConnectionNotExists(Long.valueOf(connectionId));
        return dtos.stream().map(dto -> this.saveRule(connectionId, dto)).collect(Collectors.toList());
    }

    @Transactional
    public RuleDTO saveRule(long connectionId, RuleDTO dto) {
        Connection connection = this.getById(Long.valueOf(connectionId));
        MaskingRule rule = new MaskingRule();
        rule.setType(dto.getType());
        rule.setExpression(dto.getExpression());
        rule.setConnection(connection);
        return RuleDTO.fromEntity((MaskingRule)((MaskingRule)this.ruleRepository.save((Object)rule)));
    }

    @Transactional
    public RuleDTO updateRule(long connectionId, long ruleId, RuleDTO dto) {
        this.throwIfConnectionNotExists(Long.valueOf(connectionId));
        MaskingRule rule = (MaskingRule)this.ruleRepository.findRuleByConnectionIdAndId(Long.valueOf(connectionId), Long.valueOf(ruleId)).orElseThrow(() -> new EntityNotFoundException("MaskingRule with ruleId = '" + ruleId + "' for connection with id = '" + connectionId + "' non exists."));
        rule.setType(dto.getType());
        rule.setExpression(dto.getExpression());
        return RuleDTO.fromEntity((MaskingRule)rule);
    }

    @Transactional
    public void deleteRuleList(long connectionId) {
        this.throwIfConnectionNotExists(Long.valueOf(connectionId));
        this.ruleRepository.deleteByConnectionId(Long.valueOf(connectionId));
    }

    @Transactional
    public void deleteRule(long connectionId, long ruleId) {
        this.throwIfConnectionNotExists(Long.valueOf(connectionId));
        this.ruleRepository.deleteByConnectionIdAndId(Long.valueOf(connectionId), Long.valueOf(ruleId));
    }

    public void updateConnectionsToCurrentVersion() {
        List ids = this.connectionRepository.findIds();
        boolean gotBackup = false;
        for (Long id : ids) {
            Connection connection = this.getById(id);
            if (Utils.compare((String)this.ocProps.getVersion(), (String)connection.getOcVersion()) <= 0 || this.isTestConnection(connection.getTitle())) continue;
            if (!gotBackup) {
                try {
                    this.mysqlBackupService.backup("enhancement");
                    this.mongoDbBackupService.backup();
                    gotBackup = true;
                }
                catch (Exception e) {
                    log.error("Failed to backup. Skipped updating connections");
                    throw new RuntimeException(e);
                }
            }
            AtomicBoolean connectionChanged = new AtomicBoolean(false);
            ConnectionMng connectionMng = this.connectionMngService.getByConnectionId(connection.getId());
            try {
                this.connectionMngEntityUpdater.updateToCurrentVersion((Object)connectionMng).ifChangedOrElseIfUpdated(x -> {
                    this.connectionMngService.updateWithoutBinding(x);
                    connectionChanged.set(true);
                }, arg_0 -> ((ConnectionMngService)this.connectionMngService).saveDirectly(arg_0));
            }
            catch (Exception e) {
                log.error("Failed to update Connection[id={}, name={}]", new Object[]{connection.getId(), connection.getTitle(), e});
                this.mysqlBackupService.restore("enhancement");
                this.mongoDbBackupService.restore();
                log.warn("Rolled back all changes");
                throw new RuntimeException(e);
            }
            AtomicBoolean anyEnhancementChanged = new AtomicBoolean(false);
            try {
                connection.getEnhancements().forEach(enhancement -> this.enhancementEntityUpdater.updateFrom(enhancement, connection.getOcVersion()).ifChanged(x -> {
                    anyEnhancementChanged.set(true);
                    this.enhancementService.save(enhancement);
                }));
            }
            catch (Exception e) {
                log.error("Failed to update Connection[id={}, name={}]", new Object[]{connection.getId(), connection.getTitle(), e});
                this.mysqlBackupService.restore("enhancement");
                this.mongoDbBackupService.restore();
                log.warn("Rolled back all changes");
                throw new RuntimeException(e);
            }
            log.info("Connection[id={}, name={}] is successfully updated to {} version", new Object[]{connection.getId(), connection.getTitle(), this.ocProps.getVersion()});
        }
        this.connectionRepository.updateVersion(this.ocProps.getVersion());
    }

    public List<String> getLogFileNameListById(long connectionId) {
        return LogFileUtility.getLogFileNameList((Long)connectionId);
    }

    private boolean isTestConnection(String title) {
        return title != null && title.matches("^!\\*test_connection_\\d+_.+");
    }

    private void extractVars(Object json, List<String> varList) {
        block4: {
            block5: {
                block3: {
                    if (!(json instanceof JSONObject)) break block3;
                    JSONObject jsonObject = (JSONObject)json;
                    for (String key : jsonObject.keySet()) {
                        this.extractVars(jsonObject.get((Object)key), varList);
                    }
                    break block4;
                }
                if (!(json instanceof JSONArray)) break block5;
                JSONArray jsonArray = (JSONArray)json;
                for (Object o : jsonArray) {
                    this.extractVars(o, varList);
                }
                break block4;
            }
            if (!(json instanceof String)) break block4;
            String str = (String)json;
            Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
            Matcher matcher = pattern.matcher(str);
            while (matcher.find()) {
                varList.add(matcher.group(1));
            }
        }
    }

    private ConnectionDTO patchUpdateInternal(ConnectionDTO connectionDTO, JsonPatch patch, PatchConnectionDetails details) {
        ConnectionDTO patched = (ConnectionDTO)this.patchHelper.patch(patch, (Object)connectionDTO, ConnectionDTO.class);
        this.doWithConnectorsAfterPatch(connectionDTO);
        this.doWithConnectorsAfterPatch(patched);
        this.connectionMngService.doWithPatchedConnection(connectionDTO, patched, details);
        Connection connection = (Connection)this.connectionMapper.toEntity((Object)patched);
        connection.setEnhancements(null);
        this.connectionRepository.save((Object)connection);
        ConnectionMng connectionMng = (ConnectionMng)this.connectionMngMapper.toEntity((Object)patched);
        this.connectionMngService.saveDirectly(connectionMng);
        return patched;
    }

    private void doWithConnectorsAfterPatch(ConnectionDTO connectionDTO) {
        if (connectionDTO.getFromConnector() != null) {
            ConnectorDTO fromConnector = connectionDTO.getFromConnector();
            if (fromConnector.getConnectorId() == null || !this.connectorService.existsById(fromConnector.getConnectorId().intValue())) {
                connectionDTO.setFromConnector(null);
            } else {
                this.setDefaultValues(fromConnector);
            }
        }
        if (connectionDTO.getToConnector() != null) {
            ConnectorDTO toConnector = connectionDTO.getToConnector();
            if (toConnector.getConnectorId() == null || !this.connectorService.existsById(toConnector.getConnectorId().intValue())) {
                connectionDTO.setFromConnector(null);
            } else {
                this.setDefaultValues(toConnector);
            }
        }
    }

    private void setDefaultValues(ConnectorDTO connectorDTO) {
        connectorDTO.setTitle(null);
        connectorDTO.setSslCert(false);
        connectorDTO.setIcon(null);
        connectorDTO.setInvoker(null);
        connectorDTO.setTimeout(0);
        connectorDTO.setBusinessLayout(null);
    }

    private List<FieldBindingMng> getNewEnhancements(ConnectionMng old, ConnectionMng connectionMng) {
        ArrayList<FieldBindingMng> list = new ArrayList<FieldBindingMng>();
        if (connectionMng.getFieldBindings() != null) {
            if (old.getFieldBindings() == null) {
                connectionMng.getFieldBindings().forEach(f -> f.setId(null));
                return connectionMng.getFieldBindings();
            }
            for (FieldBindingMng fieldBinding : connectionMng.getFieldBindings()) {
                if (fieldBinding.getId() == null) {
                    list.add(fieldBinding);
                    continue;
                }
                if (!old.getFieldBindings().stream().noneMatch(fb -> fb.getId().equals(fieldBinding.getId()))) continue;
                fieldBinding.setId(null);
                list.add(fieldBinding);
            }
        }
        return list;
    }

    private List<FieldBindingMng> getEnhancementsToDelete(ConnectionMng old, ConnectionMng connectionMng) {
        ArrayList<FieldBindingMng> list = new ArrayList<FieldBindingMng>();
        if (old.getFieldBindings() != null) {
            for (FieldBindingMng fb : old.getFieldBindings()) {
                if (connectionMng.getFieldBindings() == null) continue;
                connectionMng.getFieldBindings().stream().filter(f -> fb.getId().equals(f.getId())).findAny().ifPresentOrElse(f -> {}, () -> list.add(fb));
            }
        }
        return list;
    }

    private void deleteSchedules(Connection connection) {
        if (connection == null || connection.getSchedulers() == null) {
            return;
        }
        connection.getSchedulers().forEach(s -> this.schedulerService.deleteById(s.getId()));
    }

    private void throwIfConnectionNotExists(Long connectionId) {
        if (!this.connectionRepository.existsById((Object)connectionId)) {
            throw new ConnectionNotFoundException(connectionId);
        }
    }
}

