/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.database.mysql.entity.ConnectionHistory;
import com.becon.opencelium.backend.database.mysql.repository.ConnectionHistoryRepository;
import com.becon.opencelium.backend.database.mysql.service.ConnectionHistoryService;
import com.becon.opencelium.backend.enums.Action;
import com.becon.opencelium.backend.security.UserPrincipals;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatch;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ConnectionHistoryServiceImp
implements ConnectionHistoryService {
    @Value(value="${opencelium.version}")
    private String ocVersion;
    private final ObjectMapper mapper;
    private final ConnectionHistoryRepository connectionHistoryRepository;

    public ConnectionHistoryServiceImp(ObjectMapper mapper, ConnectionHistoryRepository connectionHistoryRepository) {
        this.mapper = mapper;
        this.connectionHistoryRepository = connectionHistoryRepository;
    }

    public List<ConnectionHistory> findAllWithInterval(long connectionId, long second) {
        return this.connectionHistoryRepository.findConnectionHistoriesInInterval(connectionId, second);
    }

    public List<ConnectionHistory> findAllWithConnectionId(Long connectionId) {
        return this.connectionHistoryRepository.findAllByConnectionId(connectionId);
    }

    public ConnectionHistory makeHistoryAndSave(Connection connection, JsonPatch jsonPatch, Action action) {
        ConnectionHistory connectionHistory = new ConnectionHistory();
        UserPrincipals details = (UserPrincipals)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        connectionHistory.setUser(details.getUser());
        connectionHistory.setOcVersion(this.ocVersion);
        connectionHistory.setConnection(connection);
        connectionHistory.setAction(action);
        try {
            connectionHistory.setJsonPatch(jsonPatch != null ? this.mapper.writeValueAsString((Object)jsonPatch) : null);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return (ConnectionHistory)this.connectionHistoryRepository.save((Object)connectionHistory);
    }

    public ConnectionHistory makeHistoryAndSave(Long connectionId, JsonPatch jsonPatch, Action action) {
        Connection connection = new Connection();
        connection.setId(connectionId);
        return this.makeHistoryAndSave(connection, jsonPatch, action);
    }
}

