/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.repository;

import com.becon.opencelium.backend.database.mysql.entity.Subscription;
import jakarta.persistence.LockModeType;
import jakarta.transaction.Transactional;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface SubscriptionRepository
extends JpaRepository<Subscription, String> {
    @Modifying
    @Transactional
    @Query(value="UPDATE Subscription s SET s.active = false")
    public void deactivateAll();

    @Transactional
    public void deleteByLicenseId(String var1);

    @Transactional
    public void deleteBySubId(String var1);

    public Optional<Subscription> findFirstByActiveTrue();

    public Optional<Subscription> findBySubId(String var1);

    public boolean existsBySubId(String var1);

    public Optional<Subscription> findByLicenseId(String var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="SELECT o FROM Subscription o WHERE o.id = :subId")
    public Optional<Subscription> findAndLockById(@Param(value="subId") String var1);
}

