/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.repository;

import com.becon.opencelium.backend.database.mysql.entity.ActivationRequest;
import com.becon.opencelium.backend.enums.ActivReqStatus;
import jakarta.transaction.Transactional;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ActivationRequestRepository
extends JpaRepository<ActivationRequest, String> {
    @Modifying
    @Transactional
    @Query(value="UPDATE ActivationRequest ar SET ar.status = com.becon.opencelium.backend.enums.ActivReqStatus.EXPIRED WHERE ar.status = com.becon.opencelium.backend.enums.ActivReqStatus.PENDING")
    public void expireAllActivationRequests();

    @Modifying
    @Transactional
    @Query(value="UPDATE ActivationRequest ar SET ar.active = false")
    public void deactivateAll();

    @Query(value="select * from activation_request ar where ar.active=true limit 1", nativeQuery=true)
    public Optional<ActivationRequest> findActiveAR();

    public Optional<ActivationRequest> findFirstByHmac(String var1);

    @Modifying
    @Transactional
    @Query(value="UPDATE ActivationRequest ar SET ar.status = :newStatus WHERE ar.id = :id AND ar.status != :processedStatus")
    public void updateStatusIfNotProcessed(@Param(value="id") String var1, @Param(value="newStatus") ActivReqStatus var2, @Param(value="processedStatus") ActivReqStatus var3);
}

