/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.entity;

import com.becon.opencelium.backend.database.mysql.entity.Session;
import com.becon.opencelium.backend.database.mysql.entity.UserDetail;
import com.becon.opencelium.backend.database.mysql.entity.UserRole;
import com.becon.opencelium.backend.database.mysql.entity.WidgetSetting;
import com.becon.opencelium.backend.enums.AuthMethod;
import com.becon.opencelium.backend.resource.user.UserResource;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@Table(name="user")
public class User {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private int id;
    @Column(name="email")
    private String email;
    @Column(name="username")
    private String username;
    @Column(name="password")
    private String password;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="user")
    private Session session;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="user")
    private UserDetail userDetail;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="role_id")
    private UserRole userRole;
    @Column(name="auth_method", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private AuthMethod authMethod = AuthMethod.BASIC;
    @Column(name="totp_process_completed", columnDefinition="BOOLEAN DEFAULT FALSE")
    private boolean totpProcessCompleted;
    @Column(name="totp_secret_key")
    private String totpSecretKey;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="user")
    private List<WidgetSetting> widgetSettings = new ArrayList();

    public User() {
    }

    public User(UserResource userResource, List<WidgetSetting> widgetSettings) {
        this.id = userResource.getUserId();
        this.email = userResource.getEmail();
        this.username = userResource.getUsername();
        this.userDetail = new UserDetail(userResource.getUserDetail());
        this.userRole = new UserRole(userResource.getUserGroup());
        this.widgetSettings = widgetSettings;
    }

    public String getPrincipal() {
        return this.email != null ? this.email : this.username;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public UserDetail getUserDetail() {
        return this.userDetail;
    }

    public void setUserDetail(UserDetail userDetail) {
        this.userDetail = userDetail;
    }

    public UserRole getUserRole() {
        return this.userRole;
    }

    public void setUserRole(UserRole userRole) {
        this.userRole = userRole;
    }

    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(AuthMethod authMethod) {
        this.authMethod = authMethod;
    }

    public boolean isTotpProcessCompleted() {
        return this.totpProcessCompleted;
    }

    public void setTotpProcessCompleted(boolean totpProcessCompleted) {
        this.totpProcessCompleted = totpProcessCompleted;
    }

    public String getTotpSecretKey() {
        return this.totpSecretKey;
    }

    public void setTotpSecretKey(String totpSecretKey) {
        this.totpSecretKey = totpSecretKey;
    }

    public List<WidgetSetting> getWidgetSettings() {
        return this.widgetSettings;
    }

    public void setWidgetSettings(List<WidgetSetting> widgetSettings) {
        this.widgetSettings = widgetSettings;
    }
}

