/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.entity;

import com.becon.opencelium.backend.database.mysql.entity.BLarrow;
import com.becon.opencelium.backend.database.mysql.entity.BLsvgItem;
import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.resource.blayout.BusinessLayoutResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.List;
import java.util.stream.Collectors;

@Entity
@Table(name="business_layout")
public class BusinessLayout {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private int id;
    @Column(name="name")
    private String name;
    @JsonIgnore
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="connection_id")
    private Connection connection;
    @OneToMany(mappedBy="bLayout", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BLsvgItem> svgItems;
    @OneToMany(mappedBy="bLayout", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BLarrow> arrows;

    public BusinessLayout() {
    }

    public BusinessLayout(BusinessLayoutResource businessLayoutResource) {
        this.id = businessLayoutResource.getId();
        this.arrows = businessLayoutResource.getArrows().stream().map(ar -> new BLarrow(ar, this)).collect(Collectors.toList());
        this.svgItems = businessLayoutResource.getSvgItems().stream().map(svg -> new BLsvgItem(svg, this)).collect(Collectors.toList());
    }

    public BusinessLayout(BusinessLayoutResource businessLayoutResource, Connection connection) {
        this.id = businessLayoutResource.getId();
        this.arrows = businessLayoutResource.getArrows().stream().map(ar -> new BLarrow(ar, this)).collect(Collectors.toList());
        this.svgItems = businessLayoutResource.getSvgItems().stream().map(svg -> new BLsvgItem(svg, this)).collect(Collectors.toList());
        this.connection = connection;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public List<BLsvgItem> getSvgItems() {
        return this.svgItems;
    }

    public void setSvgItems(List<BLsvgItem> svgItems) {
        this.svgItems = svgItems;
    }

    public List<BLarrow> getArrows() {
        return this.arrows;
    }

    public void setArrows(List<BLarrow> arrows) {
        this.arrows = arrows;
    }
}

