/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mongodb.service;

import com.becon.opencelium.backend.database.mongodb.entity.MethodMng;
import com.becon.opencelium.backend.database.mongodb.repository.MethodMngRepository;
import com.becon.opencelium.backend.database.mongodb.service.MethodMngService;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.resource.PatchConnectionDetails;
import com.becon.opencelium.backend.resource.connection.ConnectorDTO;
import com.becon.opencelium.backend.resource.connection.MethodDTO;
import com.becon.opencelium.backend.utility.patch.PatchHelper;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class MethodMngServiceImp
implements MethodMngService {
    private final MethodMngRepository methodMngRepository;
    private final PatchHelper patchHelper;
    private final Mapper<MethodMng, MethodDTO> methodMngMapper;

    public MethodMngServiceImp(MethodMngRepository methodMngRepository, PatchHelper patchHelper, Mapper<MethodMng, MethodDTO> methodMngMapper) {
        this.methodMngRepository = methodMngRepository;
        this.patchHelper = patchHelper;
        this.methodMngMapper = methodMngMapper;
    }

    public List<MethodMng> saveAll(List<MethodMng> methods) {
        return this.methodMngRepository.saveAll(methods);
    }

    public MethodMng save(MethodMng methodMng) {
        return (MethodMng)this.methodMngRepository.save((Object)methodMng);
    }

    public void deleteById(String id) {
        this.delete(this.getById(id));
    }

    public void delete(MethodMng methodMng) {
        this.methodMngRepository.delete((Object)methodMng);
    }

    public MethodMng getById(String id) {
        return (MethodMng)this.methodMngRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("METHOD_NOT_FOUND"));
    }

    public void deleteAll(List<MethodMng> methods) {
        this.methodMngRepository.deleteAllById(methods.stream().map(MethodMng::getId).toList());
    }

    public String getNameByCode(String methodKey) {
        MethodMng methodMng = (MethodMng)this.methodMngRepository.findByColor(methodKey).orElseThrow(() -> new RuntimeException("METHOD_NOT_FOUND"));
        return methodMng.getName();
    }

    public void doWithPatchedMethod(ConnectorDTO connectorDTO, ConnectorDTO patched, PatchConnectionDetails.PatchOperationDetail opDetail) {
        if (opDetail.isMethodAdded()) {
            int idx = this.patchHelper.getIndexOfList(opDetail.getIndexOfMethod().intValue(), patched.getMethods().size());
            MethodDTO toSave = (MethodDTO)patched.getMethods().get(idx);
            toSave.setId(null);
            MethodMng saved = this.save((MethodMng)this.methodMngMapper.toEntity((Object)toSave));
            ((MethodDTO)patched.getMethods().get(idx)).setId(saved.getId());
        } else if (opDetail.isMethodDeleted()) {
            int idx = this.patchHelper.getIndexOfList(opDetail.getIndexOfMethod().intValue(), connectorDTO.getMethods().size());
            this.deleteById(((MethodDTO)connectorDTO.getMethods().get(idx)).getId());
        } else if (opDetail.isMethodReplaced()) {
            int idx = this.patchHelper.getIndexOfList(opDetail.getIndexOfMethod().intValue(), patched.getMethods().size());
            this.deleteById(((MethodDTO)connectorDTO.getMethods().get(idx)).getId());
            MethodDTO toSave = (MethodDTO)patched.getMethods().get(idx);
            MethodMng saved = this.save((MethodMng)this.methodMngMapper.toEntity((Object)toSave));
            ((MethodDTO)patched.getMethods().get(idx)).setId(saved.getId());
        } else if (opDetail.isMethodModified()) {
            int idx = this.patchHelper.getIndexOfList(opDetail.getIndexOfMethod().intValue(), patched.getMethods().size());
            List methods = patched.getMethods();
            MethodDTO toModify = (MethodDTO)methods.get(idx);
            try {
                this.getById(toModify.getId());
            }
            catch (RuntimeException e) {
                toModify.setId(((MethodDTO)connectorDTO.getMethods().get(idx)).getId());
            }
            this.save((MethodMng)this.methodMngMapper.toEntity((Object)toModify));
        } else {
            if (connectorDTO != null && connectorDTO.getMethods() != null) {
                connectorDTO.getMethods().forEach(m -> this.deleteById(m.getId()));
            }
            if (patched != null && patched.getMethods() != null) {
                patched.getMethods().forEach(m -> {
                    MethodMng saved = this.save((MethodMng)this.methodMngMapper.toEntity(m));
                    m.setId(saved.getId());
                });
            }
        }
    }
}

