/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mongodb.service;

import com.becon.opencelium.backend.database.mongodb.entity.BodyMng;
import com.becon.opencelium.backend.database.mongodb.entity.ConnectionMng;
import com.becon.opencelium.backend.database.mongodb.entity.FieldBindingMng;
import com.becon.opencelium.backend.database.mongodb.entity.LinkedFieldMng;
import com.becon.opencelium.backend.database.mongodb.entity.MethodMng;
import com.becon.opencelium.backend.database.mongodb.repository.FieldBindingRepository;
import com.becon.opencelium.backend.database.mongodb.service.FieldBindingMngService;
import com.becon.opencelium.backend.database.mongodb.service.MethodMngService;
import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.database.mysql.entity.Enhancement;
import com.becon.opencelium.backend.database.mysql.service.EnhancementService;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.mapper.base.MapperUpdatable;
import com.becon.opencelium.backend.resource.PatchConnectionDetails;
import com.becon.opencelium.backend.resource.connection.ConnectionDTO;
import com.becon.opencelium.backend.resource.connection.MethodDTO;
import com.becon.opencelium.backend.resource.connection.binding.EnhancementDTO;
import com.becon.opencelium.backend.resource.connection.binding.FieldBindingDTO;
import com.becon.opencelium.backend.utility.BindingUtility;
import com.becon.opencelium.backend.utility.PathAndReferenceUtility;
import com.becon.opencelium.backend.utility.patch.PatchHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class FieldBindingMngServiceImp
implements FieldBindingMngService {
    private final FieldBindingRepository fieldBindingRepository;
    private final MapperUpdatable<Enhancement, EnhancementDTO> enhancementMapper;
    private final Mapper<FieldBindingMng, FieldBindingDTO> fieldBindingMngMapper;
    private final MapperUpdatable<MethodMng, MethodDTO> methodMngMapper;
    private final EnhancementService enhancementService;
    private final PatchHelper patchHelper;
    private final MethodMngService methodMngService;

    public FieldBindingMngServiceImp(@Qualifier(value="enhancementServiceImp") EnhancementService enhancementService, @Qualifier(value="methodMngServiceImp") MethodMngService methodMngService, FieldBindingRepository fieldBindingRepository, MapperUpdatable<Enhancement, EnhancementDTO> enhancementMapper, Mapper<FieldBindingMng, FieldBindingDTO> fieldBindingMngMapper, MapperUpdatable<MethodMng, MethodDTO> methodMngMapper, PatchHelper patchHelper) {
        this.fieldBindingRepository = fieldBindingRepository;
        this.enhancementMapper = enhancementMapper;
        this.fieldBindingMngMapper = fieldBindingMngMapper;
        this.enhancementService = enhancementService;
        this.methodMngMapper = methodMngMapper;
        this.patchHelper = patchHelper;
        this.methodMngService = methodMngService;
    }

    public List<FieldBindingMng> saveAll(List<FieldBindingMng> fieldBindings) {
        fieldBindings.forEach(e -> e.setEnhancement(null));
        return this.fieldBindingRepository.saveAll(fieldBindings);
    }

    public FieldBindingMng save(FieldBindingMng fieldBindingMng) {
        fieldBindingMng.setEnhancement(null);
        return (FieldBindingMng)this.fieldBindingRepository.save((Object)fieldBindingMng);
    }

    public Optional<FieldBindingMng> findById(String fieldBindingId) {
        return this.fieldBindingRepository.findById((Object)fieldBindingId);
    }

    public FieldBindingMng getById(String id) {
        return (FieldBindingMng)this.fieldBindingRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("ENHANCEMENT_NOT_FOUND"));
    }

    public List<FieldBindingMng> findAllByEnhancementId(List<Integer> ids) {
        return this.fieldBindingRepository.findAllByEnhancementIdIn(ids);
    }

    public void deleteById(String id) {
        this.delete(this.getById(id));
    }

    public void delete(FieldBindingMng fb) {
        this.fieldBindingRepository.delete((Object)fb);
    }

    public void deleteAll(List<FieldBindingMng> fieldBindings) {
        this.fieldBindingRepository.deleteAll(fieldBindings);
    }

    public List<FieldBindingMng> getAllByConnectionId(Long connectionId) {
        ArrayList<FieldBindingMng> fieldBindingMngs = new ArrayList<FieldBindingMng>();
        List enhancements = this.enhancementService.findAllByConnectionId(connectionId);
        if (enhancements != null) {
            for (Enhancement enhancement : enhancements) {
                fieldBindingMngs.add(this.enhancementService.toFieldBinding(enhancement));
            }
        }
        return fieldBindingMngs;
    }

    public void doWithPatchedEnhancement(ConnectionDTO connectionDTO, ConnectionDTO patched, PatchConnectionDetails.PatchOperationDetail opDetail) {
        if (opDetail.isEnhancementAdded()) {
            int idx = this.patchHelper.getIndexOfList(opDetail.getIndexOfEnhancement().intValue(), patched.getFieldBinding().size());
            List fieldBindings = patched.getFieldBinding();
            FieldBindingDTO toSave = (FieldBindingDTO)fieldBindings.get(idx);
            Enhancement enhancement = (Enhancement)this.enhancementMapper.toEntity((Object)toSave.getEnhancement());
            if (enhancement == null) {
                enhancement = new Enhancement();
            }
            enhancement.setConnection(new Connection(connectionDTO.getConnectionId().longValue()));
            this.enhancementService.save(enhancement);
            toSave.setEnhancementId(enhancement.getId());
            toSave.setId(null);
            FieldBindingMng saved = this.save((FieldBindingMng)this.fieldBindingMngMapper.toEntity((Object)toSave));
            ((FieldBindingDTO)patched.getFieldBinding().get(idx)).setId(saved.getId());
            ((FieldBindingDTO)patched.getFieldBinding().get(idx)).setEnhancementId(saved.getEnhancementId());
        } else if (opDetail.isEnhancementDeleted()) {
            int idx = this.patchHelper.getIndexOfList(opDetail.getIndexOfEnhancement().intValue(), connectionDTO.getFieldBinding().size());
            FieldBindingDTO fieldBindingDTO = (FieldBindingDTO)connectionDTO.getFieldBinding().get(idx);
            this.enhancementService.deleteById(fieldBindingDTO.getEnhancementId());
            this.deleteById(fieldBindingDTO.getId());
        } else if (opDetail.isEnhancementModified()) {
            Enhancement enhancement;
            int idx = this.patchHelper.getIndexOfList(opDetail.getIndexOfEnhancement().intValue(), patched.getFieldBinding().size());
            List fieldBindings = patched.getFieldBinding();
            FieldBindingDTO toModify = (FieldBindingDTO)fieldBindings.get(idx);
            try {
                enhancement = this.enhancementService.getById(toModify.getEnhancementId());
            }
            catch (RuntimeException e) {
                enhancement = this.enhancementService.getById(((FieldBindingDTO)connectionDTO.getFieldBinding().get(idx)).getEnhancementId());
                toModify.setEnhancementId(enhancement.getId());
            }
            try {
                this.getById(toModify.getId());
            }
            catch (RuntimeException e) {
                toModify.setId(((FieldBindingDTO)connectionDTO.getFieldBinding().get(idx)).getId());
            }
            this.enhancementMapper.updateEntityFromDto((Object)enhancement, (Object)toModify.getEnhancement());
            this.enhancementService.save(enhancement);
            this.save((FieldBindingMng)this.fieldBindingMngMapper.toEntity((Object)toModify));
        } else if (opDetail.isEnhancementReplaced()) {
            int idx = this.patchHelper.getIndexOfList(opDetail.getIndexOfEnhancement().intValue(), patched.getFieldBinding().size());
            FieldBindingDTO fb2 = (FieldBindingDTO)connectionDTO.getFieldBinding().get(idx);
            this.enhancementService.deleteById(fb2.getEnhancementId());
            this.deleteById(fb2.getId());
            FieldBindingDTO toSave = (FieldBindingDTO)patched.getFieldBinding().get(idx);
            Enhancement enhancement = (Enhancement)this.enhancementMapper.toEntity((Object)toSave.getEnhancement());
            enhancement.setConnection(new Connection(connectionDTO.getConnectionId().longValue()));
            this.enhancementService.save(enhancement);
            toSave.setEnhancementId(enhancement.getId());
            FieldBindingMng saved = this.save((FieldBindingMng)this.fieldBindingMngMapper.toEntity((Object)toSave));
            ((FieldBindingDTO)patched.getFieldBinding().get(idx)).setId(saved.getId());
            ((FieldBindingDTO)patched.getFieldBinding().get(idx)).setEnhancementId(saved.getEnhancementId());
        } else {
            if (connectionDTO.getFieldBinding() != null) {
                connectionDTO.getFieldBinding().forEach(fb -> {
                    this.enhancementService.deleteById(fb.getEnhancementId());
                    this.deleteById(fb.getId());
                });
            }
            if (patched.getFieldBinding() != null) {
                patched.getFieldBinding().forEach(fb -> {
                    Enhancement enhancement = (Enhancement)this.enhancementMapper.toEntity((Object)fb.getEnhancement());
                    enhancement.setConnection(new Connection(patched.getConnectionId().longValue()));
                    this.enhancementService.save(enhancement);
                    fb.setEnhancementId(enhancement.getId());
                    FieldBindingMng saved = this.save((FieldBindingMng)this.fieldBindingMngMapper.toEntity(fb));
                    fb.setId(saved.getId());
                });
            }
        }
    }

    public void bind(ConnectionMng connectionMng) {
        List fieldBindings = connectionMng.getFieldBindings();
        if (fieldBindings == null || fieldBindings.isEmpty()) {
            return;
        }
        ArrayList methods = new ArrayList();
        if (connectionMng.getFromConnector() != null && connectionMng.getFromConnector().getMethods() != null) {
            methods.addAll(connectionMng.getFromConnector().getMethods());
        }
        if (connectionMng.getToConnector() != null && connectionMng.getToConnector().getMethods() != null) {
            methods.addAll(connectionMng.getToConnector().getMethods());
        }
        for (int i = 0; i < fieldBindings.size(); ++i) {
            ((FieldBindingMng)fieldBindings.get(i)).setId(null);
            FieldBindingMng savedFB = this.save((FieldBindingMng)fieldBindings.get(i));
            try {
                this.bindIds(savedFB, methods);
                continue;
            }
            catch (Exception e) {
                for (int i1 = 0; i1 <= i; ++i1) {
                    this.delete((FieldBindingMng)fieldBindings.get(i1));
                }
                throw e;
            }
        }
    }

    public void bindAfterUpdate(ConnectionMng connectionMng) {
        List fieldBindings = connectionMng.getFieldBindings();
        if (fieldBindings == null || fieldBindings.isEmpty()) {
            return;
        }
        ArrayList methods = new ArrayList();
        if (connectionMng.getFromConnector() != null && connectionMng.getFromConnector().getMethods() != null) {
            methods.addAll(connectionMng.getFromConnector().getMethods());
        }
        if (connectionMng.getToConnector() != null && connectionMng.getToConnector().getMethods() != null) {
            methods.addAll(connectionMng.getToConnector().getMethods());
        }
        for (FieldBindingMng fieldBinding : fieldBindings) {
            this.bindIds(fieldBinding, methods);
        }
        this.methodMngService.saveAll(methods);
    }

    public void detach(ConnectionDTO connectionDTO) {
        ArrayList methods = new ArrayList();
        if (connectionDTO.getFromConnector() != null && connectionDTO.getFromConnector().getMethods() != null) {
            methods.addAll(connectionDTO.getFromConnector().getMethods());
        }
        if (connectionDTO.getToConnector() != null && connectionDTO.getToConnector().getMethods() != null) {
            methods.addAll(connectionDTO.getToConnector().getMethods());
        }
        List fbMngs = this.fieldBindingMngMapper.toEntityAll(connectionDTO.getFieldBinding());
        List methodMngs = this.methodMngMapper.toEntityAll(methods);
        BindingUtility.detach((List)methodMngs, (List)fbMngs);
        for (int i = 0; i < methods.size(); ++i) {
            this.methodMngMapper.updateDtoFromEntity((Object)((MethodDTO)methods.get(i)), (Object)((MethodMng)methodMngs.get(i)));
        }
    }

    private void bindIds(FieldBindingMng fb, List<MethodMng> methods) {
        block10: for (LinkedFieldMng toField : fb.getTo()) {
            for (MethodMng method : methods) {
                String type;
                if (!toField.getColor().equals(method.getColor())) continue;
                switch (type = PathAndReferenceUtility.getPlaceTypeOfRef((String)toField.getField())) {
                    case "path": {
                        String endpoint = method.getRequest().getEndpoint();
                        endpoint = BindingUtility.doWithPath((String)endpoint, (String)fb.getId(), (List)fb.getFrom());
                        method.getRequest().setEndpoint(endpoint);
                        break;
                    }
                    case "header": {
                        String fieldName = PathAndReferenceUtility.getHeaderParameterName((String)toField.getField());
                        BindingUtility.doWithHeader((Map)method.getRequest().getHeader(), (String)fieldName, (String)fb.getId(), (List)fb.getFrom());
                        break;
                    }
                    case "body": {
                        String field = PathAndReferenceUtility.getActualPathOfBody((String)toField.getField());
                        List fieldPaths = PathAndReferenceUtility.splitByDelimiter((String)field, (char)'.', (boolean)true, (boolean)true);
                        Map boundFields = BindingUtility.doWithBody((BodyMng)method.getRequest().getBody(), (List)fieldPaths, (String)fb.getId(), (String)method.getRequest().getBody().getFormat());
                        method.getRequest().getBody().setFields(boundFields);
                        break;
                    }
                    default: {
                        throw new RuntimeException("UNSUPPORTED_TYPE: " + type);
                    }
                }
                continue block10;
            }
        }
    }
}

