/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mongodb.service;

import com.becon.opencelium.backend.constant.props.OpenceliumProps;
import com.becon.opencelium.backend.database.mongodb.entity.ConnectionMng;
import com.becon.opencelium.backend.database.mongodb.entity.EnhancementMng;
import com.becon.opencelium.backend.database.mongodb.repository.ConnectionMngRepository;
import com.becon.opencelium.backend.database.mongodb.service.ConnectionMngService;
import com.becon.opencelium.backend.database.mongodb.service.FieldBindingMngService;
import com.becon.opencelium.backend.database.mongodb.service.MethodMngService;
import com.becon.opencelium.backend.database.mongodb.service.OperatorMngService;
import com.becon.opencelium.backend.database.mysql.entity.Enhancement;
import com.becon.opencelium.backend.database.mysql.service.EnhancementService;
import com.becon.opencelium.backend.exception.ConnectionNotFoundException;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.mapper.base.MapperUpdatable;
import com.becon.opencelium.backend.resource.PatchConnectionDetails;
import com.becon.opencelium.backend.resource.connection.ConnectionDTO;
import com.becon.opencelium.backend.resource.connection.binding.EnhancementDTO;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ConnectionMngServiceImp
implements ConnectionMngService {
    private final ConnectionMngRepository connectionMngRepository;
    private final FieldBindingMngService fieldBindingMngService;
    private final MethodMngService methodMngService;
    private final OperatorMngService operatorMngService;
    private final EnhancementService enhancementService;
    private final MapperUpdatable<Enhancement, EnhancementDTO> enhancementMapper;
    private final Mapper<EnhancementMng, EnhancementDTO> enhancementMngMapper;
    private final OpenceliumProps ocProps;

    public ConnectionMngServiceImp(ConnectionMngRepository connectionMngRepository, @Qualifier(value="fieldBindingMngServiceImp") FieldBindingMngService fieldBindingMngService, @Qualifier(value="methodMngServiceImp") MethodMngService methodMngService, @Qualifier(value="operatorMngServiceImp") OperatorMngService operatorMngService, @Qualifier(value="enhancementServiceImp") EnhancementService enhancementService, MapperUpdatable<Enhancement, EnhancementDTO> enhancementMapper, Mapper<EnhancementMng, EnhancementDTO> enhancementMngMapper, OpenceliumProps ocProps) {
        this.connectionMngRepository = connectionMngRepository;
        this.fieldBindingMngService = fieldBindingMngService;
        this.methodMngService = methodMngService;
        this.operatorMngService = operatorMngService;
        this.enhancementService = enhancementService;
        this.enhancementMapper = enhancementMapper;
        this.enhancementMngMapper = enhancementMngMapper;
        this.ocProps = ocProps;
    }

    public boolean existsByConnectionId(Long id) {
        return this.connectionMngRepository.existsByConnectionId(id);
    }

    public ConnectionMng save(ConnectionMng connectionMng) {
        if (Objects.isNull(connectionMng)) {
            return null;
        }
        if (connectionMng.getConnectionId() != null && this.existsByConnectionId(connectionMng.getConnectionId())) {
            throw new RuntimeException("CONNECTION_ALREADY_EXISTS");
        }
        connectionMng.setVersion(this.ocProps.getVersion());
        try {
            this.fieldBindingMngService.bind(connectionMng);
            if (connectionMng.getFromConnector() != null) {
                if (connectionMng.getFromConnector().getMethods() != null) {
                    connectionMng.getFromConnector().getMethods().forEach(method -> method.setId(null));
                    connectionMng.getFromConnector().setMethods(this.methodMngService.saveAll(connectionMng.getFromConnector().getMethods()));
                }
                if (connectionMng.getFromConnector().getOperators() != null) {
                    connectionMng.getFromConnector().getOperators().forEach(op -> op.setId(null));
                    connectionMng.getFromConnector().setOperators(this.operatorMngService.saveAll(connectionMng.getFromConnector().getOperators()));
                }
            }
            if (connectionMng.getToConnector() != null) {
                if (connectionMng.getToConnector().getMethods() != null) {
                    connectionMng.getToConnector().getMethods().forEach(method -> method.setId(null));
                    connectionMng.getToConnector().setMethods(this.methodMngService.saveAll(connectionMng.getToConnector().getMethods()));
                }
                if (connectionMng.getToConnector().getOperators() != null) {
                    connectionMng.getToConnector().getOperators().forEach(op -> op.setId(null));
                    connectionMng.getToConnector().setOperators(this.operatorMngService.saveAll(connectionMng.getToConnector().getOperators()));
                }
            }
        }
        catch (Exception e) {
            this.deleteChildren(connectionMng);
            throw e;
        }
        return (ConnectionMng)this.connectionMngRepository.save((Object)connectionMng);
    }

    public ConnectionMng saveDirectly(ConnectionMng connectionMng) {
        if (Objects.isNull(connectionMng)) {
            return null;
        }
        return (ConnectionMng)this.connectionMngRepository.save((Object)connectionMng);
    }

    public void updateAndBind(ConnectionMng old, ConnectionMng connectionMng) {
        if (Objects.isNull(connectionMng)) {
            return;
        }
        try {
            this.updateWithoutRollback(old, connectionMng);
        }
        catch (Exception e) {
            this.updateWithoutRollback(connectionMng, old);
            throw e;
        }
        try {
            this.fieldBindingMngService.bindAfterUpdate(connectionMng);
        }
        catch (Exception e) {
            this.fieldBindingMngService.bindAfterUpdate(old);
            this.updateWithoutRollback(connectionMng, old);
            throw e;
        }
    }

    public ConnectionMng getByConnectionId(Long connectionId) {
        ConnectionMng connectionMng = (ConnectionMng)this.connectionMngRepository.findByConnectionId(connectionId).orElseThrow(() -> new ConnectionNotFoundException(connectionId));
        this.setEnhancements(connectionMng);
        return connectionMng;
    }

    public List<ConnectionMng> getAll() {
        return this.connectionMngRepository.findAll();
    }

    public void updateWithoutBinding(ConnectionMng connectionMng) {
        if (Objects.isNull(connectionMng)) {
            return;
        }
        if (Objects.isNull(connectionMng.getId()) || !this.connectionMngRepository.existsById((Object)connectionMng.getId())) {
            throw new RuntimeException("CONNECTION_NOT_FOUND");
        }
        try {
            if (Objects.nonNull(connectionMng.getFromConnector())) {
                if (Objects.nonNull(connectionMng.getFromConnector().getMethods())) {
                    connectionMng.getFromConnector().setMethods(this.methodMngService.saveAll(connectionMng.getFromConnector().getMethods()));
                }
                if (Objects.nonNull(connectionMng.getFromConnector().getOperators())) {
                    connectionMng.getFromConnector().setOperators(this.operatorMngService.saveAll(connectionMng.getFromConnector().getOperators()));
                }
            }
            if (Objects.nonNull(connectionMng.getToConnector())) {
                if (Objects.nonNull(connectionMng.getToConnector().getMethods())) {
                    connectionMng.getToConnector().setMethods(this.methodMngService.saveAll(connectionMng.getToConnector().getMethods()));
                }
                if (Objects.nonNull(connectionMng.getToConnector().getOperators())) {
                    connectionMng.getToConnector().setOperators(this.operatorMngService.saveAll(connectionMng.getToConnector().getOperators()));
                }
            }
            if (Objects.nonNull(connectionMng.getFieldBindings())) {
                this.fieldBindingMngService.saveAll(connectionMng.getFieldBindings());
            }
        }
        catch (Exception e) {
            this.deleteChildren(connectionMng);
            throw e;
        }
        this.connectionMngRepository.save((Object)connectionMng);
    }

    public List<ConnectionMng> getAllById(List<Long> ids) {
        return this.connectionMngRepository.findAllByConnectionIdIn(ids);
    }

    public ConnectionMng delete(Long id) {
        ConnectionMng connectionMng = this.getByConnectionId(id);
        this.deleteChildren(connectionMng);
        this.connectionMngRepository.delete((Object)connectionMng);
        return connectionMng;
    }

    public long count() {
        return this.connectionMngRepository.count();
    }

    public void doWithPatchedConnection(ConnectionDTO connectionDTO, ConnectionDTO patched, PatchConnectionDetails details) {
        for (PatchConnectionDetails.PatchOperationDetail opDetail : details.getOpDetails()) {
            if (opDetail.isItEnh()) {
                this.fieldBindingMngService.doWithPatchedEnhancement(connectionDTO, patched, opDetail);
                continue;
            }
            if (opDetail.isItMethod()) {
                if (opDetail.isFrom()) {
                    this.methodMngService.doWithPatchedMethod(connectionDTO.getFromConnector(), patched.getFromConnector(), opDetail);
                    continue;
                }
                this.methodMngService.doWithPatchedMethod(connectionDTO.getToConnector(), patched.getToConnector(), opDetail);
                continue;
            }
            if (!opDetail.isItOperator()) continue;
            if (opDetail.isFrom()) {
                this.operatorMngService.doWithPatchedOperator(connectionDTO.getFromConnector(), patched.getFromConnector(), opDetail);
                continue;
            }
            this.operatorMngService.doWithPatchedOperator(connectionDTO.getToConnector(), patched.getToConnector(), opDetail);
        }
    }

    private void updateWithoutRollback(ConnectionMng old, ConnectionMng connectionMng) {
        if (connectionMng.getFromConnector() != null) {
            if (connectionMng.getFromConnector().getMethods() != null) {
                this.methodMngService.saveAll(connectionMng.getFromConnector().getMethods());
                this.doIfNoneMatch(old.getFromConnector().getMethods(), connectionMng.getFromConnector().getMethods(), (m1, m2) -> m1.getId().equals(m2.getId()), arg_0 -> ((MethodMngService)this.methodMngService).delete(arg_0));
            } else if (old.getFromConnector() != null && old.getFromConnector().getMethods() != null) {
                this.methodMngService.deleteAll(old.getFromConnector().getMethods());
            }
            if (connectionMng.getFromConnector().getOperators() != null) {
                this.operatorMngService.saveAll(connectionMng.getFromConnector().getOperators());
                this.doIfNoneMatch(old.getFromConnector().getOperators(), connectionMng.getFromConnector().getOperators(), (o1, o2) -> o1.getId().equals(o2.getId()), arg_0 -> ((OperatorMngService)this.operatorMngService).delete(arg_0));
            } else if (old.getFromConnector() != null && old.getFromConnector().getOperators() != null) {
                this.operatorMngService.deleteAll(old.getFromConnector().getOperators());
            }
        } else if (old.getFromConnector() != null) {
            if (old.getFromConnector().getMethods() != null) {
                this.methodMngService.deleteAll(old.getFromConnector().getMethods());
            }
            if (old.getFromConnector().getOperators() != null) {
                this.operatorMngService.deleteAll(old.getFromConnector().getOperators());
            }
        }
        if (connectionMng.getToConnector() != null) {
            if (connectionMng.getToConnector().getMethods() != null) {
                this.methodMngService.saveAll(connectionMng.getToConnector().getMethods());
                this.doIfNoneMatch(old.getToConnector().getMethods(), connectionMng.getToConnector().getMethods(), (m1, m2) -> m1.getId().equals(m2.getId()), arg_0 -> ((MethodMngService)this.methodMngService).delete(arg_0));
            } else if (old.getToConnector() != null && old.getToConnector().getMethods() != null) {
                this.methodMngService.deleteAll(old.getToConnector().getMethods());
            }
            if (connectionMng.getToConnector().getOperators() != null) {
                this.operatorMngService.saveAll(connectionMng.getToConnector().getOperators());
                this.doIfNoneMatch(old.getToConnector().getOperators(), connectionMng.getToConnector().getOperators(), (o1, o2) -> o1.getId().equals(o2.getId()), arg_0 -> ((OperatorMngService)this.operatorMngService).delete(arg_0));
            } else if (old.getToConnector() != null && old.getToConnector().getOperators() != null) {
                this.operatorMngService.deleteAll(old.getToConnector().getOperators());
            }
        } else if (old.getToConnector() != null) {
            if (old.getToConnector().getMethods() != null) {
                this.methodMngService.deleteAll(old.getToConnector().getMethods());
            }
            if (old.getToConnector().getOperators() != null) {
                this.operatorMngService.deleteAll(old.getToConnector().getOperators());
            }
        }
        if (connectionMng.getFieldBindings() != null && !connectionMng.getFieldBindings().isEmpty()) {
            this.fieldBindingMngService.saveAll(connectionMng.getFieldBindings());
            this.doIfNoneMatch(old.getFieldBindings(), connectionMng.getFieldBindings(), (f1, f2) -> f1.getId().equals(f2.getId()), arg_0 -> ((FieldBindingMngService)this.fieldBindingMngService).delete(arg_0));
        } else if (old.getFieldBindings() != null) {
            this.fieldBindingMngService.deleteAll(old.getFieldBindings());
        }
        this.connectionMngRepository.save((Object)connectionMng);
    }

    private void deleteChildren(ConnectionMng connectionMng) {
        if (connectionMng.getFromConnector() != null) {
            if (connectionMng.getFromConnector().getMethods() != null) {
                this.methodMngService.deleteAll(connectionMng.getFromConnector().getMethods().stream().filter(m -> m.getId() != null).toList());
            }
            if (connectionMng.getFromConnector().getOperators() != null) {
                this.operatorMngService.deleteAll(connectionMng.getFromConnector().getOperators().stream().filter(o -> o.getId() != null).toList());
            }
        }
        if (connectionMng.getToConnector() != null) {
            if (connectionMng.getToConnector().getMethods() != null) {
                this.methodMngService.deleteAll(connectionMng.getToConnector().getMethods().stream().filter(m -> m.getId() != null).toList());
            }
            if (connectionMng.getToConnector().getOperators() != null) {
                this.operatorMngService.deleteAll(connectionMng.getToConnector().getOperators().stream().filter(o -> o.getId() != null).toList());
            }
        }
        if (connectionMng.getFieldBindings() != null) {
            this.fieldBindingMngService.deleteAll(connectionMng.getFieldBindings().stream().filter(f -> f.getId() != null).toList());
        }
    }

    private void setEnhancements(ConnectionMng connection) {
        if (connection.getFieldBindings() == null || connection.getFieldBindings().isEmpty()) {
            return;
        }
        connection.getFieldBindings().forEach(f -> {
            if (f != null) {
                f.setEnhancement((EnhancementMng)this.enhancementMngMapper.toEntity((Object)((EnhancementDTO)this.enhancementMapper.toDTO((Object)this.enhancementService.getById(f.getEnhancementId())))));
            }
        });
    }

    private <T> void doIfNoneMatch(List<T> olds, List<T> news, BiFunction<T, T, Boolean> f, Consumer<T> c) {
        if (olds != null) {
            for (Object t : olds) {
                if (!news.stream().noneMatch(x -> (Boolean)f.apply(x, t))) continue;
                c.accept(t);
            }
        }
    }
}

