/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.Widget;
import com.becon.opencelium.backend.database.mysql.service.WidgetServiceImp;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.user.WidgetResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@Tag(name="Widget", description="Manages operations related to Widget.")
@RequestMapping(value={"/widget"}, produces={"application/json"})
public class WidgetController {
    @Autowired
    private WidgetServiceImp widgetServiceImp;

    @Operation(summary="Creates a new widget in the system by accepting widget data in the request body")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Widget is successfully created. The 'widgetId' property will include newly created widget's 'id'", content={@Content(schema=@Schema(implementation=WidgetResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<?> save(@RequestBody WidgetResource widgetResource) {
        Widget widget = this.widgetServiceImp.toEntity(widgetResource);
        this.widgetServiceImp.save(widget);
        WidgetResource resource = this.widgetServiceImp.toResource(widget);
        URI uri = MvcUriComponentsBuilder.fromController(this.getClass()).path("/{id}").buildAndExpand(new Object[]{resource.getWidgetId()}).toUri();
        return ResponseEntity.created((URI)uri).body((Object)resource);
    }

    @Operation(summary="Deletes a widget by 'id' ")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Widget is successfully deleted.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable(value="id") int id) {
        this.widgetServiceImp.deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Returns list of all widgets")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Widgets successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=WidgetResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/all"})
    public ResponseEntity<?> viewAll() {
        List widgets = this.widgetServiceImp.findAll();
        List resources = widgets.stream().map(ws -> this.widgetServiceImp.toResource(ws)).collect(Collectors.toList());
        return ResponseEntity.ok().body(resources);
    }

    @Operation(summary="Returns a widget by provided widget id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Widget successfully retrieved", content={@Content(schema=@Schema(implementation=WidgetResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{id}"})
    public ResponseEntity<?> view(@PathVariable(value="id") int id) {
        Widget widget = (Widget)this.widgetServiceImp.findById(id).orElseThrow(() -> new RuntimeException("Widget not found"));
        return ResponseEntity.ok().body((Object)widget);
    }
}

