/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.application.assistant.AssistantServiceImp;
import com.becon.opencelium.backend.application.assistant.UpdatePackageServiceImp;
import com.becon.opencelium.backend.application.entity.AvailableUpdate;
import com.becon.opencelium.backend.application.entity.SystemOverview;
import com.becon.opencelium.backend.exception.StorageFileNotFoundException;
import com.becon.opencelium.backend.resource.application.AvailableUpdateResource;
import com.becon.opencelium.backend.resource.application.MigrateDataResource;
import com.becon.opencelium.backend.resource.application.SystemOverviewResource;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.updateassistant.InstallationDTO;
import com.becon.opencelium.backend.resource.updateassistant.Neo4jConfigResource;
import com.becon.opencelium.backend.resource.updateassistant.VersionDTO;
import com.becon.opencelium.backend.template.service.TemplateServiceImp;
import com.zaxxer.hikari.pool.HikariPool;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.sql.DataSource;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Tag(name="Update Assistant", description="Manages version control operations.")
@RequestMapping(value={"/assistant"}, produces={"application/json"})
public class UpdateAssistantController {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private AssistantServiceImp assistantServiceImp;
    @Autowired
    private UpdatePackageServiceImp packageServiceImp;
    @Autowired
    private TemplateServiceImp templateServiceImp;
    @Autowired
    private UpdatePackageServiceImp updatePackageServiceImp;

    @GetMapping(value={"/all"})
    public List<String> getAll() {
        DataSource dataSource = this.jdbcTemplate.getDataSource();
        assert (dataSource != null);
        HikariPool hikariPool = (HikariPool)new DirectFieldAccessor((Object)dataSource).getPropertyValue("pool");
        assert (hikariPool != null);
        System.out.println(hikariPool.toString());
        return null;
    }

    @Operation(summary="Checks if OpenCelium is up and running.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OpenCelium is up and running"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/oc/test"})
    public ResponseEntity<?> ocTest() {
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Returns current version of OpenCelium")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The version has been successfully retrieved", content={@Content(schema=@Schema(implementation=VersionDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/oc/version"})
    public ResponseEntity<?> ocCurrentVersion() {
        String version = this.assistantServiceImp.getCurrentVersion();
        VersionDTO versionDTO = new VersionDTO(version);
        return ResponseEntity.ok().body((Object)versionDTO);
    }

    @GetMapping(value={"/oc/requirements"})
    public ResponseEntity<?> getSystemRequirement() {
        String version = this.assistantServiceImp.getCurrentVersion();
        String result = "{\"version\": \"" + version + "\"}";
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/oc/installation"})
    public ResponseEntity<?> getInstallation() {
        InstallationDTO installationDTO = this.assistantServiceImp.getInstallation();
        return ResponseEntity.ok((Object)installationDTO);
    }

    @Operation(summary="Returns current versions of tools that are used in OpenCelium")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Overview of tools has been successfully retrieved", content={@Content(schema=@Schema(implementation=SystemOverviewResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/oc/system/overview"})
    public ResponseEntity<?> getSystemOverview() {
        SystemOverview systemOverview = this.assistantServiceImp.getSystemOverview();
        SystemOverviewResource resource = this.assistantServiceImp.toResource(systemOverview);
        return ResponseEntity.ok().body((Object)resource);
    }

    @Operation(summary="Returns list of current offline versions of tools that are used in OpenCelium")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of offline versions has been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=AvailableUpdateResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/oc/offline/version/all"})
    public ResponseEntity<?> getOfflineVersion() {
        List offVersions = this.packageServiceImp.getOffVersions();
        List packageResource = offVersions.stream().map(p -> this.packageServiceImp.toResource(p)).collect(Collectors.toList());
        return ResponseEntity.ok(packageResource);
    }

    @Operation(summary="Returns current versions of tools that are used in OpenCelium from Service Portal")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns response from Service Portal in json format"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/oc/online/version/all"}, produces={"application/json"})
    public ResponseEntity<?> getOnlineVersion() {
        List onVersions_json = this.packageServiceImp.getOnVersions();
        List<AvailableUpdateResource> versions = onVersions_json.stream().map(t -> this.updatePackageServiceImp.toResource(t)).toList();
        return ResponseEntity.ok(versions);
    }

    @Operation(summary="Downloads zip version of OC from remote repository")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="ZIP file was successfully downloaded"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/oc/online/version/{version}/download"}, produces={"application/json"})
    public ResponseEntity<?> downloadVersion(@PathVariable String version) {
        try {
            this.packageServiceImp.downloadPackage(version);
            AvailableUpdate availableUpdate = this.updatePackageServiceImp.getAvailableUpdate(version);
            AvailableUpdateResource availableUpdateResource = this.updatePackageServiceImp.toResource(availableUpdate);
            return ResponseEntity.ok((Object)availableUpdateResource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Operation(summary="Validates weather an oc_service.sh file exists or not")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns response from Service Portal in json format", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/oc/restart/file/exists"})
    public ResponseEntity<?> fileExists() {
        Path currentRelativePath = Paths.get("", new String[0]).toAbsolutePath().getParent().getParent();
        String ocScriptPath = currentRelativePath.toString() + "/scripts/oc_service.sh";
        File file = new File(ocScriptPath);
        ErrorResource errorResource = new ErrorResource();
        errorResource.setMessage("EXISTS");
        errorResource.setStatus(HttpStatus.OK);
        errorResource.setPath(ocScriptPath);
        if (!file.exists()) {
            errorResource.setMessage("NOT_EXISTS");
            errorResource.setStatus(HttpStatus.OK);
            errorResource.setPath(ocScriptPath);
            return ResponseEntity.ok((Object)errorResource);
        }
        return ResponseEntity.ok((Object)errorResource);
    }

    @GetMapping(value={"/oc/template"})
    public ResponseEntity<?> getAssistantTemplateFiles() {
        String path = "runtime/templates/";
        List templates = this.templateServiceImp.findAllByPath(path);
        List templateResources = templates.stream().map(t -> this.templateServiceImp.toResource(t)).collect(Collectors.toList());
        return ResponseEntity.ok(templateResources);
    }

    @Operation(summary="Migrates invokers, templates and connections to a selected version and replacing all files from zip file")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Migration has been done successfully"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(value={"/oc/migrate"}, consumes={"application/json"})
    public ResponseEntity<?> migrate(@RequestBody MigrateDataResource migrateDataResource) {
        try {
            this.assistantServiceImp.updateOff(migrateDataResource.getVersion());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Uploads zip file that contains OpenCelium versions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Migration has been done successfully", content={@Content(schema=@Schema(implementation=AvailableUpdateResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(value={"/zipfile"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> assistantUploadFile(@RequestParam(value="file") MultipartFile file) {
        try {
            String zippedAppVersion = this.assistantServiceImp.getVersion(file.getInputStream());
            Path target = Paths.get("assistant/versions/" + zippedAppVersion, new String[0]);
            this.assistantServiceImp.uploadZipFile(file, target);
            AvailableUpdate availableUpdate = this.updatePackageServiceImp.getAvailableUpdate(zippedAppVersion);
            AvailableUpdateResource availableUpdateResource = this.updatePackageServiceImp.toResource(availableUpdate);
            return ResponseEntity.ok((Object)availableUpdateResource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Operation(summary="Deletes zip file that contains OpenCelium versions")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Deletion has been done successfully", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/zipfile/{filename}"})
    public ResponseEntity<?> assistantDeleteFile(@PathVariable String filename) {
        Path zipPath = Paths.get("assistant/versions/" + filename, new String[0]);
        this.assistantServiceImp.deleteZipFile(zipPath);
        return ResponseEntity.noContent().build();
    }

    private boolean checkJsonExtension(String extension) {
        return extension.equals("json") || extension.equals("JSON");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Operation(summary="Returns changelogs of specified package")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Changelog has been retrieved successfully", content={@Content(schema=@Schema(implementation=Resource.class))}, headers={@Header(name="Content-Disposition", description="Default value - attachment; filename=\"{filename}\"")}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/changelog/file/{packageName}"})
    public ResponseEntity<Resource> download(@PathVariable String packageName) {
        String path = "assistant/versions/" + packageName + "/";
        Path rootLocation = Paths.get(path, new String[0]);
        if (!Files.exists(rootLocation, new LinkOption[0])) {
            throw new StorageFileNotFoundException("Folder not found with name: " + packageName);
        }
        try (Stream<Path> paths = Files.walk(rootLocation, 1, new FileVisitOption[0]);){
            File file = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".zip")).findAny().orElseThrow(() -> new StorageFileNotFoundException("Zip file not found within folder: " + packageName)).toFile();
            try (ZipFile zipFile = new ZipFile(file);){
                String name;
                ZipEntry zipEntry;
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                do {
                    if (!entries.hasMoreElements()) throw new StorageFileNotFoundException("CHANGELOG file is not found");
                    zipEntry = entries.nextElement();
                    name = zipEntry.getName();
                } while (zipEntry.isDirectory() || !name.equals("CHANGELOG.rst"));
                try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                    byte[] content = inputStream.readAllBytes();
                    ByteArrayResource resource = new ByteArrayResource(content);
                    ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"CHANGELOG.rst\""})).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)resource);
                    return responseEntity;
                }
            }
        }
        catch (IOException e) {
            throw new StorageFileNotFoundException("Error accessing files: " + e.getMessage(), (Throwable)e);
        }
    }

    @PostMapping(value={"/db/migrate"})
    public ResponseEntity<?> dbMigrate(@RequestBody Neo4jConfigResource neo4jConfig) {
        this.assistantServiceImp.doMigrate(neo4jConfig);
        return ResponseEntity.ok().build();
    }
}

