/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.UserRole;
import com.becon.opencelium.backend.database.mysql.service.PermissionServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.RoleHasPermissionServiceImp;
import com.becon.opencelium.backend.database.mysql.service.UserRoleServiceImpl;
import com.becon.opencelium.backend.exception.RoleExistsException;
import com.becon.opencelium.backend.exception.RoleNotFoundException;
import com.becon.opencelium.backend.resource.IdentifiersDTO;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.user.UserRoleResource;
import com.becon.opencelium.backend.storage.StorageService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@Tag(name="User Role(Group)", description="Manages operations related to User Roles management")
@RequestMapping(value={"/role"}, produces={"application/json"})
public class RoleController {
    @Autowired
    private UserRoleServiceImpl userRoleService;
    @Autowired
    private RoleHasPermissionServiceImp roleHasPermissionServiceImp;
    @Autowired
    private PermissionServiceImpl permissionService;
    @Autowired
    private StorageService storageService;

    @Operation(summary="Retrieves a user role by provided role ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User Role has been successfully retrieved", content={@Content(schema=@Schema(implementation=UserRoleResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{id}"})
    public ResponseEntity<?> get(@PathVariable(value="id") int id) {
        return this.userRoleService.findById(id).map(p -> ResponseEntity.ok((Object)new UserRoleResource(p))).orElseThrow(() -> new RoleNotFoundException(id));
    }

    @Operation(summary="Retrieves all User Roles")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User Role has been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserRoleResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/all"})
    public ResponseEntity<List<UserRoleResource>> all() {
        List collection = this.userRoleService.findAll().stream().map(UserRoleResource::new).collect(Collectors.toList());
        return ResponseEntity.ok(collection);
    }

    @Operation(summary="Creates new User Role")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User Role has been successfully created", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserRoleResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<UserRoleResource> post(@RequestBody UserRoleResource userRoleResource) {
        UserRole userRole;
        if (this.userRoleService.existsByRole(userRoleResource.getName())) {
            throw new RoleExistsException(userRoleResource.getName());
        }
        UserRole role = new UserRole(userRoleResource);
        try {
            this.userRoleService.save(role);
            userRoleResource.setGroupId(role.getId());
            userRole = this.userRoleService.toEntity(userRoleResource);
            this.userRoleService.save(userRole);
        }
        catch (Exception e) {
            this.userRoleService.deleteById(role.getId());
            throw new RuntimeException(e);
        }
        UserRoleResource resource = this.userRoleService.toResource(userRole);
        URI uri = MvcUriComponentsBuilder.fromController(this.getClass()).path("/{id}").buildAndExpand(new Object[]{userRole.getId()}).toUri();
        return ResponseEntity.created((URI)uri).body((Object)resource);
    }

    @Operation(summary="Modifies components on an existed User Role by provided Role ID and relevant information in the request body")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Components of User Role has been successfully modified", content={@Content(schema=@Schema(implementation=UserRoleResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"{id}/component"}, consumes={"application/json"})
    public ResponseEntity<UserRoleResource> changeComponent(@PathVariable(value="id") int id, @RequestBody UserRoleResource userRoleResource) throws IOException {
        UserRole uRoleBackUp = (UserRole)this.userRoleService.findById(id).orElseThrow(() -> new RuntimeException("UserGroup id: " + id + "not found"));
        boolean isIdenticalName = uRoleBackUp.getName().equals(userRoleResource.getName());
        if (!isIdenticalName && this.userRoleService.existsByRole(userRoleResource.getName())) {
            throw new RoleExistsException(userRoleResource.getName());
        }
        userRoleResource.setGroupId(id);
        this.roleHasPermissionServiceImp.deleteByUserRoleId(uRoleBackUp.getId());
        try {
            UserRole uRole = this.userRoleService.toEntity(userRoleResource);
            this.userRoleService.save(uRole);
        }
        catch (Exception e) {
            this.userRoleService.save(uRoleBackUp);
            throw new RuntimeException(e);
        }
        return this.userRoleService.findById(id).map(p -> ResponseEntity.ok((Object)new UserRoleResource(p))).orElseThrow(() -> new RoleNotFoundException(id));
    }

    @Operation(summary="Modifies existed User Role by provided Role ID and relevant information in the request body")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User Role has been successfully modified", content={@Content(schema=@Schema(implementation=UserRoleResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/{id}"}, consumes={"application/json"})
    public ResponseEntity<UserRoleResource> put(@PathVariable(value="id") int id, @RequestBody UserRoleResource roleResource) throws IOException {
        UserRole userRole = (UserRole)this.userRoleService.findById(id).orElseThrow(() -> new RuntimeException("UserGroup id: " + id + "not found"));
        boolean isIdenticalName = userRole.getName().equals(roleResource.getName());
        if (!isIdenticalName && this.userRoleService.existsByRole(roleResource.getName())) {
            throw new RoleExistsException(roleResource.getName());
        }
        roleResource.setGroupId(id);
        UserRole role = (UserRole)this.userRoleService.findById(id).orElseThrow(() -> new RoleNotFoundException(id));
        UserRoleResource resource = this.userRoleService.toResource(role);
        this.userRoleService.save(role);
        URI uri = MvcUriComponentsBuilder.fromController(this.getClass()).path("/{id}").buildAndExpand(new Object[]{role.getId()}).toUri();
        return ResponseEntity.created((URI)uri).body((Object)resource);
    }

    @Operation(summary="Checks existence of role in OC")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns EXISTS or NOT_EXISTS", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/exists/{role}"})
    public ResponseEntity<?> roleExists(@PathVariable(value="role") String role) throws IOException {
        if (this.userRoleService.existsByRole(role)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.OK, "EXISTS");
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.OK, "NOT_EXISTS");
    }

    @Operation(summary="Deletes an User Role from system by provided role ID")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="User Role has been successfully deleted.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable(value="id") int id) {
        return this.userRoleService.findById(id).map(p -> {
            if (p.getIcon() != null) {
                this.storageService.delete(p.getIcon());
            }
            this.userRoleService.deleteById(id);
            return ResponseEntity.noContent().build();
        }).orElseThrow(() -> new RoleNotFoundException(id));
    }

    @Operation(summary="Deletes a collection of User Roles based on the provided list of their corresponding IDs.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="List of User Roles have been successfully deleted.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"list/delete"}, consumes={"application/json"})
    public ResponseEntity<?> deleteRoleByIdIn(@RequestBody IdentifiersDTO<Integer> ids) {
        ids.getIdentifiers().forEach(id -> {
            UserRole p = (UserRole)this.userRoleService.findById(id.intValue()).get();
            if (p.getIcon() != null) {
                this.storageService.delete(p.getIcon());
            }
            this.userRoleService.deleteById(id.intValue());
        });
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Deletes an icon of User Roles based on the provided role ID.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Icon of User Role has been successfully deleted.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/{id}/icon"})
    public ResponseEntity<?> deleteIcon(@PathVariable(value="id") int id) {
        return this.userRoleService.findById(id).map(p -> {
            if (p.getIcon() != null) {
                this.storageService.delete(p.getIcon());
                p.setIcon(null);
                this.userRoleService.save(p);
            }
            return ResponseEntity.noContent().build();
        }).orElseThrow(() -> new RoleNotFoundException(id));
    }
}

