/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.EventContent;
import com.becon.opencelium.backend.database.mysql.entity.EventMessage;
import com.becon.opencelium.backend.database.mysql.service.ContentServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.MessageServiceImpl;
import com.becon.opencelium.backend.enums.LangEnum;
import com.becon.opencelium.backend.enums.execution.NotifyTool;
import com.becon.opencelium.backend.resource.IdentifiersDTO;
import com.becon.opencelium.backend.resource.application.ResultDTO;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.notification.LanguageDTO;
import com.becon.opencelium.backend.resource.notification.MessageResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Event Message", description="Manages operations related to Event Messages management")
@RequestMapping(value={"/message"}, produces={"application/json"})
public class MessageController {
    @Autowired
    private MessageServiceImpl messageService;
    @Autowired
    private ContentServiceImpl contentService;
    @Autowired
    private Environment env;

    @Operation(summary="Retrieves all event messages from database")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All Event Messages have been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=MessageResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/all"})
    public ResponseEntity<?> getAll() throws Exception {
        List eventMessageList = this.messageService.findAll();
        List messageResources = eventMessageList.stream().map(message -> this.messageService.toResource(message)).collect(Collectors.toList());
        return ResponseEntity.ok(messageResources);
    }

    @Operation(summary="Retrieves an event messages from database by provided Event Message ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Event Message has been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=MessageResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{id}"})
    public ResponseEntity<?> get(@PathVariable int id) throws Exception {
        EventMessage eventMessage = (EventMessage)this.messageService.findById(id).orElseThrow(() -> new RuntimeException("MESSAGE_TEMPLATE_NOT_FOUND"));
        MessageResource messageResource = new MessageResource(eventMessage);
        EntityModel resource = EntityModel.of((Object)messageResource);
        return ResponseEntity.ok((Object)resource);
    }

    @Operation(summary="Creates an event message in the system by accepting event message data in the request body")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Event Message has been successfully created", content={@Content(schema=@Schema(implementation=MessageResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<?> createMessage(@RequestBody MessageResource messageResource) throws Exception {
        EventMessage eventMessage = this.messageService.toEntity(messageResource);
        this.messageService.save(eventMessage);
        List eventContents = eventMessage.getEventContents();
        eventContents.forEach(ec -> LangEnum.valueOf((String)ec.getLanguage().toUpperCase(Locale.ROOT)));
        for (int i = 0; i < eventContents.size(); ++i) {
            this.contentService.save((EventContent)eventContents.get(i));
        }
        EntityModel resource = EntityModel.of((Object)this.messageService.toResource(eventMessage));
        return ResponseEntity.ok((Object)resource);
    }

    @Operation(summary="Deletes an event message in the system by providing ID")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Event Message has been successfully deleted", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<?> deleteMessage(@PathVariable int id) throws Exception {
        this.messageService.deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Deletes an event message in the system by providing ID")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Event Message has been successfully deleted", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"list/delete"}, consumes={"application/json"})
    public ResponseEntity<?> deleteMessageByIdIn(@RequestBody IdentifiersDTO<Integer> ids) throws Exception {
        ids.getIdentifiers().forEach(id -> this.messageService.deleteById(id.intValue()));
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Modifies an event message in the system by providing ID and by accepting event message data in the request body")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Event Message has been successfully deleted", content={@Content(schema=@Schema(implementation=MessageResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/{id}"}, consumes={"application/json"})
    public ResponseEntity<?> updateMessage(@PathVariable int id, @RequestBody MessageResource messageResource) throws Exception {
        messageResource.setTemplateId(id);
        EventMessage eventMessage = this.messageService.toEntity(messageResource);
        eventMessage.setId(id);
        this.messageService.save(eventMessage);
        List eventContents = eventMessage.getEventContents();
        for (int i = 0; i < eventContents.size(); ++i) {
            this.contentService.save((EventContent)eventContents.get(i));
        }
        EntityModel resource = EntityModel.of((Object)this.messageService.toResource(eventMessage));
        return ResponseEntity.ok((Object)resource);
    }

    @Operation(summary="Retrieves list of event messages from database by providing type of message")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Event Messages have been successfully retrieved by message type", content={@Content(schema=@Schema(implementation=MessageResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/all/{type}"})
    public ResponseEntity<List<MessageResource>> getAllTemplatesByNotificationType(@PathVariable String type) throws Exception {
        List eventMessageList = this.messageService.findAllByType(type);
        List messageResources = eventMessageList.stream().map(message -> this.messageService.toResource(message)).collect(Collectors.toList());
        return ResponseEntity.ok(messageResources);
    }

    @Operation(summary="Retrieves a list of supported languages")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Languages has been successfully retrieved", content={@Content(schema=@Schema(implementation=MessageResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/languages"})
    public ResponseEntity<?> getSupportedLanguages() {
        List<LanguageDTO> languages = Stream.of(LangEnum.values()).map(e -> new LanguageDTO(e.getName(), e.getCode())).toList();
        HashMap<String, List<LanguageDTO>> body = new HashMap<String, List<LanguageDTO>>();
        body.put("languages", languages);
        return ResponseEntity.ok().body(body);
    }

    @Operation(summary="Retrieves list of supported tools like email, teams, slack, etc...")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns array that contains string values like \"result\": [\"email\", \"slack\"]", content={@Content(schema=@Schema(implementation=ResultDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/tools/all"})
    public ResponseEntity<?> getTools() throws Exception {
        List<String> notifyTools = Arrays.stream(NotifyTool.values()).map(Enum::toString).toList();
        ResultDTO resultDTO = new ResultDTO(notifyTools);
        return ResponseEntity.ok((Object)resultDTO);
    }

    @GetMapping(value={"/tools/incoming_webhook"})
    public ResponseEntity<?> getSlackWebhook() throws Exception {
        String webhook = this.env.getProperty("opencelium.notification.tools.incoming-webhook.url");
        ResultDTO webhookDto = new ResultDTO((Object)webhook);
        return ResponseEntity.ok((Object)webhookDto);
    }
}

