/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.configuration.LdapProperties;
import com.becon.opencelium.backend.database.mysql.service.LdapVerificationService;
import com.becon.opencelium.backend.resource.LdapConfigDTO;
import com.becon.opencelium.backend.resource.LdapVerificationMessageDTO;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Tag(name="Ldap", description="To retrieve ldap configuration and test connection to ldap server")
@RequestMapping(value={"/ldap"})
public class LdapController {
    @Autowired
    private LdapProperties properties;
    @Autowired
    private LdapVerificationService service;

    @Operation(summary="Returns ldap configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/default/config"})
    public ResponseEntity<LdapConfigDTO> getDefaultConfiguration() {
        LdapConfigDTO result = new LdapConfigDTO();
        result.setUrls(this.properties.getUrls());
        result.setUserDN(this.properties.getUserSearchBase());
        result.setGroupDN(this.properties.getGroupSearchBase());
        result.setUsername(this.properties.getUsername());
        result.setPassword("[PROTECTED]");
        result.setTimeout(this.properties.getTimeout());
        result.setUserSearchFilter(this.properties.getUserSearchFilter());
        result.setGroupSearchFilter(this.properties.getGroupSearchFilter());
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="Tests if connection can be established with given configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(value={"/test"})
    public ResponseEntity<List<LdapVerificationMessageDTO>> testConnection(@RequestBody LdapConfigDTO dto) {
        List messages = this.service.collectMessages(dto);
        if (messages.size() < 4) {
            return ResponseEntity.badRequest().body((Object)messages);
        }
        messages.remove(3);
        return ResponseEntity.ok((Object)messages);
    }
}

