/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.constant.props.OpenceliumProps;
import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.database.mysql.entity.UserDetail;
import com.becon.opencelium.backend.database.mysql.entity.UserRole;
import com.becon.opencelium.backend.database.mysql.service.ConnectorServiceImp;
import com.becon.opencelium.backend.database.mysql.service.InvokerSyncService;
import com.becon.opencelium.backend.database.mysql.service.UserDetailServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.UserRoleServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.UserServiceImpl;
import com.becon.opencelium.backend.exception.StorageException;
import com.becon.opencelium.backend.exception.StorageFileNotFoundException;
import com.becon.opencelium.backend.invoker.service.InvokerServiceImp;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.resource.FileDTO;
import com.becon.opencelium.backend.resource.connector.ConnectorResource;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.storage.UserStorageService;
import com.becon.opencelium.backend.template.entity.Template;
import com.becon.opencelium.backend.template.service.TemplateServiceImp;
import com.becon.opencelium.backend.utility.FileNameUtils;
import com.becon.opencelium.backend.utility.Xml;
import com.becon.opencelium.backend.versionmanager.EntityUpdater;
import com.becon.opencelium.backend.versionmanager.EntityVersionManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.w3c.dom.Document;

@Controller
@Tag(name="File", description="Manages operations related to File management")
@RequestMapping(value={"/storage"})
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    private final UserDetailServiceImpl userDetailService;
    private final UserServiceImpl userService;
    private final UserRoleServiceImpl userRoleService;
    private final TemplateServiceImp templateService;
    private final ConnectorServiceImp connectorService;
    private final InvokerServiceImp invokerServiceImp;
    private final InvokerSyncService invokerSyncService;
    private final UserStorageService storageService;
    private final Mapper<Connector, ConnectorResource> connectorMapper;
    private final EntityUpdater<Template> templateUpdater;
    private final OpenceliumProps ocProps;

    @Autowired
    public FileController(UserDetailServiceImpl userDetailService, UserServiceImpl userService, UserRoleServiceImpl userRoleService, TemplateServiceImp templateService, ConnectorServiceImp connectorService, InvokerServiceImp invokerServiceImp, InvokerSyncService invokerSyncService, UserStorageService storageService, Mapper<Connector, ConnectorResource> connectorMapper, EntityVersionManager versionManager, OpenceliumProps ocProps) {
        this.userDetailService = userDetailService;
        this.userService = userService;
        this.userRoleService = userRoleService;
        this.templateService = templateService;
        this.connectorService = connectorService;
        this.invokerServiceImp = invokerServiceImp;
        this.invokerSyncService = invokerSyncService;
        this.storageService = storageService;
        this.connectorMapper = connectorMapper;
        this.templateUpdater = versionManager.getUpdater(Template.class);
        this.ocProps = ocProps;
    }

    @Operation(summary="Uploads profile picture of a user by provided user email")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Profile picture has been successfully uploaded", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(value={"/profilePicture"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> profilePictureUpload(@RequestParam(value="file") MultipartFile file, @RequestParam(value="email") String email) {
        String extension = FileNameUtils.getExtension((String)file.getOriginalFilename());
        if (!this.checkImageExtension(extension)) {
            throw new StorageException("File should be jpg or png");
        }
        User user = (User)this.userService.findByEmail(email).get();
        String newFilename = UUID.randomUUID().toString() + "." + extension;
        UserDetail userDetail = user.getUserDetail();
        if (userDetail.getProfilePicture() != null) {
            this.storageService.delete(userDetail.getProfilePicture());
        }
        userDetail.setProfilePicture(newFilename);
        this.userDetailService.save(userDetail);
        this.storageService.store(file, newFilename);
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Uploads role's(group) icon by provided user role(group) ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Profile picture has been successfully uploaded", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(path={"/groupIcon"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> groupPictureUpload(@RequestParam(value="file") MultipartFile file, @RequestParam(value="userGroupId") int userGroupId) {
        String extension = FileNameUtils.getExtension((String)file.getOriginalFilename());
        Objects.requireNonNull(extension);
        if (!this.checkImageExtension(extension)) {
            throw new StorageException("File should be jpg or png");
        }
        UserRole userRole = (UserRole)this.userRoleService.findById(userGroupId).orElseThrow(() -> new RuntimeException("Role doesn't exist"));
        String newFilename = UUID.randomUUID() + "." + extension;
        if (userRole.getIcon() != null) {
            this.storageService.delete(userRole.getIcon());
        }
        userRole.setIcon(newFilename);
        this.userRoleService.save(userRole);
        this.storageService.store(file, newFilename);
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Uploads template json file")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Template has been successfully uploaded", content={@Content(schema=@Schema(implementation=FileDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(value={"/template"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> upload(@RequestParam(value="file") MultipartFile file) {
        String extension = FileNameUtils.getExtension((String)file.getOriginalFilename());
        if (extension == null) {
            throw new RuntimeException("Extension not found");
        }
        try {
            String id;
            if (!this.checkJsonExtension(extension)) {
                throw new StorageException("File should be JSON");
            }
            ObjectMapper objectMapper = new ObjectMapper();
            Template template = (Template)objectMapper.readValue(file.getBytes(), Template.class);
            this.updateTemplate(template);
            if (template.getTemplateId() != null && this.templateService.existsById(template.getTemplateId())) {
                this.templateService.deleteById(template.getTemplateId());
                id = template.getTemplateId();
            } else {
                id = UUID.randomUUID().toString();
                template.setTemplateId(id);
            }
            this.templateService.save(template);
            URI uri = this.getUri(id + ".json");
            FileDTO fileDTO = new FileDTO(id, uri.toString());
            return ResponseEntity.ok().body((Object)fileDTO);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Operation(summary="Uploads templates in zip file")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Template has been successfully uploaded", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FileDTO.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(value={"/template/zip"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> uploadZip(@RequestParam(value="file") MultipartFile zip) {
        String extension = FileNameUtils.getExtension((String)zip.getOriginalFilename());
        if (extension == null) {
            throw new RuntimeException("Extension not found");
        }
        ArrayList files = new ArrayList();
        try {
            ArrayList<Template> templates;
            ZipInputStream zis;
            if (extension.equals("zip")) {
                ZipEntry zipEntry;
                InputStream inputStream = zip.getInputStream();
                zis = new ZipInputStream(inputStream);
                ObjectMapper objectMapper = new ObjectMapper();
                templates = new ArrayList<Template>();
                while ((zipEntry = zis.getNextEntry()) != null) {
                    if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".json")) continue;
                    String id = UUID.randomUUID().toString();
                    String jsonContent = new String(zis.readAllBytes(), StandardCharsets.UTF_8);
                    Template template = (Template)objectMapper.readValue(jsonContent, Template.class);
                    template.setTemplateId(id);
                    this.updateTemplate(template);
                    templates.add(template);
                }
            } else {
                throw new RuntimeException("Zip file is required");
            }
            zis.close();
            templates.forEach(tmpl -> {
                this.templateService.save(tmpl);
                URI uri = this.getUri(tmpl.getTemplateId() + ".json");
                FileDTO fileDTO = new FileDTO(tmpl.getTemplateId(), uri.toString());
                files.add(fileDTO);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ResponseEntity.ok().body(files);
    }

    @Operation(summary="Uploads invoker xml file")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Invoker has been successfully uploaded", content={@Content(schema=@Schema(implementation=FileDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(path={"/invoker"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> uploadInvoker(@RequestParam(value="file") MultipartFile file) {
        String filename = file.getOriginalFilename();
        String extension = FileNameUtils.getExtension((String)file.getOriginalFilename());
        try {
            if (file.isEmpty()) {
                throw new StorageException("Failed to store empty file " + filename);
            }
            Objects.requireNonNull(filename);
            if (filename.contains("..")) {
                throw new StorageException("Cannot store file with relative path outside current directory " + filename);
            }
            Objects.requireNonNull(extension);
            Xml xml = this.saveXmlFile(file.getInputStream(), filename);
            String name = xml.getValueByXPath("//invoker/name");
            FileDTO fileDTO = new FileDTO(name);
            this.invokerSyncService.updateSync(name);
            return ResponseEntity.ok((Object)fileDTO);
        }
        catch (Exception e) {
            this.invokerServiceImp.delete(FileNameUtils.removeExtension((String)filename));
            throw new StorageException("Failed to store file " + filename, (Throwable)e);
        }
    }

    @Operation(summary="Uploads zip file that contains invoker files")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Invoker has been successfully uploaded", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FileDTO.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(path={"/invoker/zip"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> uploadInvokerZip(@RequestParam(value="file") MultipartFile file) {
        String filename = file.getOriginalFilename();
        String extension = FileNameUtils.getExtension((String)file.getOriginalFilename());
        ArrayList<FileDTO> fileDTOList = new ArrayList<FileDTO>();
        try {
            ZipInputStream zis;
            if (file.isEmpty()) {
                throw new StorageException("Failed to store empty file " + filename);
            }
            Objects.requireNonNull(filename);
            if (filename.contains("..")) {
                throw new StorageException("Cannot store file with relative path outside current directory " + filename);
            }
            Objects.requireNonNull(extension);
            if (extension.equals("zip")) {
                ZipEntry zipEntry;
                InputStream inputStream = file.getInputStream();
                zis = new ZipInputStream(inputStream);
                while ((zipEntry = zis.getNextEntry()) != null) {
                    if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".xml")) continue;
                    Xml xml = this.saveXmlFile((InputStream)zis, zipEntry.getName());
                    String name = xml.getValueByXPath("//invoker/name");
                    FileDTO fileDTO = new FileDTO(name);
                    fileDTOList.add(fileDTO);
                    this.invokerSyncService.updateSync(name);
                }
            } else {
                throw new RuntimeException("ZIP_FILE_REQUIRED");
            }
            zis.close();
        }
        catch (Exception e) {
            fileDTOList.forEach(f -> this.invokerServiceImp.delete(f.getId()));
            throw new StorageException("Failed to store file " + filename, (Throwable)e);
        }
        return ResponseEntity.ok(fileDTOList);
    }

    private Xml saveXmlFile(InputStream inputStream, String filename) {
        try {
            DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputStream copyIS = this.getInputStreamCopy(inputStream);
            Document doc = dBuilder.parse(copyIS);
            doc.setDocumentURI("runtime/invoker/" + filename);
            Xml xml = new Xml(doc, filename);
            xml.save();
            this.invokerServiceImp.save(doc);
            copyIS.close();
            return xml;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private InputStream getInputStreamCopy(InputStream originInputStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int bytesRead;
            while ((bytesRead = originInputStream.read(buffer)) > -1) {
                baos.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    @Operation(summary="Uploads connector json file")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connector has been successfully uploaded", content={@Content(schema=@Schema(implementation=ConnectorResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(value={"/connector"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> connectorUpload(@RequestParam(value="file") MultipartFile file, @RequestParam(value="connectorId") int connectorId) {
        Connector connector = (Connector)this.connectorService.findById(connectorId).orElseThrow(() -> new RuntimeException("CONNECTOR_NOT_FOUND"));
        String extension = FileNameUtils.getExtension((String)file.getOriginalFilename());
        Objects.requireNonNull(extension);
        if (!this.checkImageExtension(extension)) {
            throw new StorageException("File should be jpg or png");
        }
        try {
            String newFilename = UUID.randomUUID().toString() + "." + extension;
            connector.setIcon(newFilename);
            this.storageService.store(file, newFilename);
            this.connectorService.save(connector);
            ConnectorResource resource = (ConnectorResource)this.connectorMapper.toDTO((Object)connector);
            return ResponseEntity.ok().body((Object)resource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkJsonExtension(String extension) {
        return extension.equals("json") || extension.equals("JSON");
    }

    @GetMapping(value={"/files/{filename:.+}"})
    @ResponseBody
    public ResponseEntity<Resource> serveFile(@PathVariable String filename) {
        Resource file = this.storageService.loadAsResource(filename);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).body((Object)file);
    }

    @ExceptionHandler(value={StorageFileNotFoundException.class})
    public ResponseEntity<?> handleStorageFileNotFound(StorageFileNotFoundException exc) {
        return ResponseEntity.notFound().build();
    }

    private boolean checkImageExtension(String extension) {
        return extension.equals("jpeg") || extension.equals("png") || extension.equals("jpg");
    }

    private static String readJsonContent(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
            String string = content.toString();
            return string;
        }
    }

    private URI getUri(String name) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        UriComponents uriComponents = UriComponentsBuilder.newInstance().scheme(request.getScheme()).host(request.getServerName()).port(request.getServerPort()).path("/api/template/file/" + name).build();
        return uriComponents.toUri();
    }

    private List<Document> getAllInvokers() {
        Path location = Paths.get("runtime/invoker/", new String[0]);
        try {
            Stream<Path> allInvokers = Files.walk(location, 1, new FileVisitOption[0]).filter(path -> !path.equals(location)).map(location::relativize);
            return allInvokers.map(p -> new File(location.toString() + "/" + p.getFileName())).map(file -> {
                try {
                    DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    return dBuilder.parse((File)file);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException("Failed to read stored files", (Throwable)e);
        }
    }

    private void updateTemplate(Template template) {
        try {
            this.templateUpdater.updateToCurrentVersion((Object)template).ifUpdated(temp -> log.info("Template[id={}, name={}] is successfully updated to {} version", new Object[]{template.getTemplateId(), template.getName(), this.ocProps.getVersion()}));
            template.setVersion(this.ocProps.getVersion());
        }
        catch (Exception e) {
            log.error("Failed to update Template[id={}, name={}]", new Object[]{template.getTemplateId(), template.getName(), e});
            throw new RuntimeException("INVALID_TEMPLATE");
        }
    }
}

