/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.Category;
import com.becon.opencelium.backend.database.mysql.service.CategoryService;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.resource.CategoryDTO;
import com.becon.opencelium.backend.resource.CategoryResponseDTO;
import com.becon.opencelium.backend.resource.IdentifiersDTO;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/category"}, produces={"application/json"})
@Tag(name="Category", description="Manages operations related to Category management")
public class CategoryController {
    private final CategoryService categoryService;
    private final Mapper<Category, CategoryResponseDTO> categoryResponseMapper;

    public CategoryController(@Qualifier(value="categoryServiceImp") CategoryService categoryService, Mapper<Category, CategoryResponseDTO> categoryResponseMapper) {
        this.categoryService = categoryService;
        this.categoryResponseMapper = categoryResponseMapper;
    }

    @Operation(summary="Retrieves a category from database by provided category ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Category has been successfully retrieved", content={@Content(schema=@Schema(implementation=CategoryDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(path={"/{id}"})
    public ResponseEntity<?> get(@PathVariable Integer id) {
        Category category = this.categoryService.get(id);
        return ResponseEntity.ok((Object)((CategoryResponseDTO)this.categoryResponseMapper.toDTO((Object)category)));
    }

    @Operation(summary="Retrieves all categories from database")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Categories have been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=CategoryDTO.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(path={"/all"})
    public ResponseEntity<?> getAll() {
        List categories = this.categoryService.getAll();
        return ResponseEntity.ok((Object)this.categoryResponseMapper.toDTOAll(categories));
    }

    @Operation(summary="Creates a category")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Category has been successfully created", content={@Content(schema=@Schema(implementation=CategoryDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<?> add(@RequestBody CategoryDTO dto) {
        Integer id = this.categoryService.add(dto);
        URI uri = MvcUriComponentsBuilder.fromController(this.getClass()).buildAndExpand(new Object[0]).toUri();
        return ResponseEntity.created((URI)uri).body((Object)((CategoryResponseDTO)this.categoryResponseMapper.toDTO((Object)this.categoryService.get(id))));
    }

    @Operation(summary="Modifies a category by provided category ID and accepting category data in request body.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Category has been successfully modified", content={@Content(schema=@Schema(implementation=CategoryDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"/{id}"}, consumes={"application/json"})
    public ResponseEntity<?> update(@PathVariable Integer id, @RequestBody CategoryDTO dto) {
        dto.setId(id);
        this.categoryService.update(dto);
        return ResponseEntity.ok((Object)((CategoryResponseDTO)this.categoryResponseMapper.toDTO((Object)this.categoryService.get(id))));
    }

    @Operation(summary="Deletes: a category with given ID; connections related to this category; sub categories and connections related to them")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Category has been successfully deleted.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/cascade-delete/{id}"})
    public ResponseEntity<?> cascadeDelete(@PathVariable Integer id) {
        this.categoryService.cascadeDelete(id);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="For each id, it deletes: a category with given ID; connections related to this category; sub categories and connections related to them")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="List of categories have been deleted", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/list/cascade-delete"})
    public ResponseEntity<?> cascadeDeleteFromList(@RequestBody IdentifiersDTO<Integer> ids) {
        this.categoryService.cascadeDeleteAll((List)ids.getIdentifiers());
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Deletes only category with given ID ")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Category has been successfully deleted.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable Integer id) {
        this.categoryService.deleteOnly(id);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Deletes list of categories with given ids")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="List of categories have been deleted", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/list/delete"})
    public ResponseEntity<?> deleteFromList(@RequestBody IdentifiersDTO<Integer> ids) {
        this.categoryService.deleteAllOnly((List)ids.getIdentifiers());
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Validates name of category for uniqueness")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Category Name has been successfully validate. Return EXISTS or NOT_EXISTS values in 'message' property.", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/check/{name}"})
    public ResponseEntity<?> existsByName(@PathVariable(value="name") String name) throws IOException {
        RuntimeException ex = this.categoryService.existsByName(name) ? new RuntimeException("EXISTS") : new RuntimeException("NOT_EXISTS");
        String uri = ServletUriComponentsBuilder.fromCurrentRequest().build().toUri().toString();
        ErrorResource errorResource = new ErrorResource((Exception)ex, HttpStatus.OK, uri);
        return ResponseEntity.ok().body((Object)errorResource);
    }
}

