/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.constant.props;

import com.becon.opencelium.backend.constant.props.PolyglotProps;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="opencelium.polyglot")
public class PolyglotProps {
    private static final Logger logger = LoggerFactory.getLogger(PolyglotProps.class);
    private static final String DEFAULT_PROTOCOL = "grpc";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 6566;
    private Boolean enabled = false;
    private String protocol;
    private String host;
    private Integer port;
    private Boolean autoStart = false;
    private LaunchConfig launch = new LaunchConfig();

    @PostConstruct
    public void validate() {
        if (!this.isEnabled()) {
            return;
        }
        try {
            this.applyDefaults();
            this.validateProtocol();
            this.validateHost();
            this.validatePort();
            if (this.isAutoStart()) {
                this.launch.validate();
            }
        }
        catch (IllegalStateException e) {
            logger.error("Polyglot configuration validation failed: {}. Application will use fallback engine.", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void applyDefaults() {
        if (this.protocol == null || this.protocol.trim().isEmpty()) {
            this.protocol = DEFAULT_PROTOCOL;
        }
        if (this.host == null || this.host.trim().isEmpty()) {
            this.host = DEFAULT_HOST;
        }
        if (this.port == null) {
            this.port = 6566;
        }
    }

    private void validateProtocol() {
        if (!this.protocol.matches("^(http|https|grpc)$")) {
            throw new IllegalStateException("opencelium.polyglot.protocol must be http, https, or grpc. Got: " + this.protocol);
        }
    }

    private void validateHost() {
        if (!this.host.matches("^[a-zA-Z0-9.-]+$")) {
            throw new IllegalStateException("opencelium.polyglot.host must be a valid hostname or IP address. Got: " + this.host);
        }
    }

    private void validatePort() {
        if (this.port < 1 || this.port > 65535) {
            throw new IllegalStateException("opencelium.polyglot.port must be between 1 and 65535. Got: " + this.port);
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Boolean getAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(Boolean autoStart) {
        this.autoStart = autoStart;
    }

    public LaunchConfig getLaunch() {
        return this.launch;
    }

    public void setLaunch(LaunchConfig launch) {
        this.launch = launch;
    }

    public boolean isEnabled() {
        return Boolean.TRUE.equals(this.enabled);
    }

    public boolean isAutoStart() {
        return Boolean.TRUE.equals(this.autoStart);
    }

    public String getJarPath() {
        if (this.launch == null) {
            return null;
        }
        return this.launch.jarPath;
    }

    public String getJvmArgs() {
        if (this.launch == null) {
            return null;
        }
        return this.launch.jvmArgs;
    }

    public String getArgs() {
        if (this.launch == null) {
            return null;
        }
        return this.launch.args;
    }

    public int getWaitTimeoutSec() {
        if (this.launch == null) {
            return 30;
        }
        return this.launch.waitTimeoutSec;
    }

    public boolean isExternalLogEnabled() {
        return this.launch != null && Boolean.TRUE.equals(this.launch.externalLogEnabled);
    }
}

