/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.configuration;

import com.becon.opencelium.backend.constant.props.OpenceliumProps;
import com.becon.opencelium.backend.database.mysql.entity.ActivationRequest;
import com.becon.opencelium.backend.database.mysql.entity.Subscription;
import com.becon.opencelium.backend.database.mysql.service.ActivationRequestService;
import com.becon.opencelium.backend.database.mysql.service.ConnectionService;
import com.becon.opencelium.backend.database.mysql.service.ConnectorService;
import com.becon.opencelium.backend.database.mysql.service.RequestDataService;
import com.becon.opencelium.backend.database.mysql.service.SubscriptionService;
import com.becon.opencelium.backend.enums.ActivReqStatus;
import com.becon.opencelium.backend.invoker.InvokerContainer;
import com.becon.opencelium.backend.invoker.entity.RequiredData;
import com.becon.opencelium.backend.storage.UserStorageService;
import com.becon.opencelium.backend.subscription.quartz.OperationUsageReportJob;
import com.becon.opencelium.backend.subscription.quartz.QuartzCronUpdater;
import com.becon.opencelium.backend.subscription.utility.LicenseKeyUtility;
import com.becon.opencelium.backend.template.service.TemplateService;
import com.becon.opencelium.backend.utility.migrate.ChangeSetDao;
import com.becon.opencelium.backend.utility.migrate.YAMLMigrator;
import com.becon.opencelium.backend.versionmanager.backup.FileBackupManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;

@Configuration
public class StorageConfiguration {
    private static final Logger log = LoggerFactory.getLogger(StorageConfiguration.class);
    private final UserStorageService userStorageService;
    private final ConnectorService connectorService;
    private final InvokerContainer invokerContainer;
    private final RequestDataService requestDataService;
    private final ChangeSetDao changeSetDao;
    private final Environment environment;
    private final SubscriptionService subscriptionService;
    private final ActivationRequestService activationRequestService;
    private final ConnectionService connectionService;
    private final TemplateService templateService;
    private final OpenceliumProps ocProps;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private Scheduler quartzScheduler;
    private static final String JAR_PREFIX = "opencelium.backend-";
    private static final String JAR_EXTENSION = ".jar";

    public StorageConfiguration(UserStorageService userStorageService, @Qualifier(value="connectorServiceImp") ConnectorService connectorService, @Qualifier(value="requestDataServiceImp") RequestDataService requestDataService, @Qualifier(value="subscriptionServiceImpl") SubscriptionService subscriptionService, @Qualifier(value="activationRequestServiceImp") ActivationRequestService activationRequestService, InvokerContainer invokerContainer, DataSource dataSource, Environment environment, ConnectionService connectionService, TemplateService templateService, OpenceliumProps ocProps) {
        this.userStorageService = userStorageService;
        this.connectorService = connectorService;
        this.invokerContainer = invokerContainer;
        this.requestDataService = requestDataService;
        this.changeSetDao = new ChangeSetDao(dataSource);
        this.environment = environment;
        this.subscriptionService = subscriptionService;
        this.activationRequestService = activationRequestService;
        this.connectionService = connectionService;
        this.templateService = templateService;
        this.ocProps = ocProps;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void createStorageAfterStartup() {
        this.setInitialLicense();
        this.updateReportSchedule();
        this.createDirectory("runtime/");
        this.createDirectory("runtime/templates/");
        this.createDirectory("assistant/");
        this.createDirectory("assistant/versions/");
        this.createDirectory("assistant/temporary/");
        this.requestDataService.prepare();
        this.updateVisibility();
        this.userStorageService.init();
        FileBackupManager.moveToNewLocation((String)"src/main/resources/backup", (String)"runtime/backup/");
        this.connectionService.updateConnectionsToCurrentVersion();
        this.templateService.updateTemplatesToCurrentVersion();
        if (YAMLMigrator.getChangeSetsToSave() != null) {
            this.changeSetDao.createAll(YAMLMigrator.getChangeSetsToSave());
        }
        this.cleanOldFiles("build/libs/", f -> f.isFile() && f.getName().endsWith(JAR_EXTENSION), JAR_PREFIX);
        this.cleanOldFiles("assistant/versions/", File::isDirectory, "");
    }

    private void updateReportSchedule() {
        String cron = "0 0 23 * * ?";
        this.schedulerReport(cron);
    }

    private void schedulerReport(String cron) {
        String triggerName = "operationUsageReportJobTrigger";
        String triggerGroup = "USAGE_REPORT";
        JobKey jobKey = JobKey.jobKey((String)"operationUsageReportJob", (String)triggerGroup);
        TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroup);
        try {
            if (this.quartzScheduler.checkExists(jobKey)) {
                QuartzCronUpdater quartzCronUpdater = new QuartzCronUpdater(this.quartzScheduler);
                quartzCronUpdater.updateCronExpression(triggerKey.getName(), triggerKey.getGroup(), cron);
                return;
            }
            JobDetail jobDetail = JobBuilder.newJob(OperationUsageReportJob.class).withIdentity(jobKey).storeDurably().build();
            Trigger trigger = TriggerBuilder.newTrigger().forJob(jobDetail).withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
            this.quartzScheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private void setInitialLicense() {
        if (!this.doesFileExist("src/main/resources/license/init-license.txt")) {
            return;
        }
        try {
            ActivationRequest ar = this.activationRequestService.readFreeAR().orElse(null);
            String initLicense = LicenseKeyUtility.readFreeLicense();
            Subscription subscription = this.subscriptionService.convertToSub(initLicense, ar);
            if (!this.subscriptionService.exists(subscription.getSubId())) {
                Objects.requireNonNull(ar).setStatus(ActivReqStatus.PROCESSED);
                ar.setActive(true);
                this.activationRequestService.save(ar);
                this.subscriptionService.save(subscription);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void cleanOldFiles(String folder, Predicate<File> filter, String prefix) {
        Path path = Paths.get(folder, new String[0]);
        Integer majorVersion = this.ocProps.majorVersion();
        if (majorVersion == null) {
            return;
        }
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<File> files = Files.list(path).map(Path::toFile).filter(filter);){
                files.filter(f -> !f.getName().startsWith(prefix + majorVersion + ".")).forEach(f -> {
                    if (this.forceDelete(f)) {
                        log.info("{} - file/folder is deleted", (Object)f.getAbsolutePath());
                    } else {
                        log.warn("{} - file/folder cannot be deleted", (Object)f.getAbsolutePath());
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean forceDelete(File folder) {
        String[] entries;
        if (folder == null || !folder.exists()) {
            return false;
        }
        if (folder.isDirectory() && (entries = folder.list()) != null) {
            for (String entry : entries) {
                File currentFile = new File(folder, entry);
                if (this.forceDelete(currentFile)) continue;
                return false;
            }
        }
        return folder.delete();
    }

    private void updateVisibility() {
        List connectors = this.connectorService.findAll();
        connectors.forEach(c -> {
            List requestData = c.getRequestData();
            if (requestData != null && !requestData.isEmpty()) {
                List requiredData = this.invokerContainer.getByName(c.getInvoker()).getRequiredData();
                requestData.forEach(request -> {
                    RequiredData required = requiredData.stream().filter(rq -> rq.getName().equals(request.getField())).findFirst().orElse(null);
                    if (required == null) {
                        return;
                    }
                    request.setVisibility(required.getVisibility());
                });
            }
        });
        this.connectorService.saveAll(connectors);
    }

    private void createDirectory(String name) {
        Path filePath = Paths.get(name, new String[0]);
        if (Files.notExists(filePath, new LinkOption[0])) {
            File directory = new File(name);
            if (directory.mkdir()) {
                log.info("Directory has been created: {}", (Object)name);
            } else {
                log.warn("Failed to create directory: {}", (Object)name);
            }
        }
    }

    private boolean doesFileExist(String filePath) {
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }
}

