/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.application.health;

import com.becon.opencelium.backend.scriptengine.external.polyglotservice.PolyglotServiceGRPCClient;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Component;

@Component(value="polyglot")
public class PolyglotHealthIndicator
extends AbstractHealthIndicator {
    private final PolyglotServiceGRPCClient polyglotServiceGRPCClient;

    public PolyglotHealthIndicator(PolyglotServiceGRPCClient polyglotServiceGRPCClient) {
        this.polyglotServiceGRPCClient = polyglotServiceGRPCClient;
    }

    protected void doHealthCheck(Health.Builder builder) {
        builder.withDetail("name", (Object)"Polyglot");
        try {
            if (this.polyglotServiceGRPCClient.isUp()) {
                builder.up();
            } else {
                builder.down().withDetail("error", (Object)"Couldn't establish a connection to Polyglot service. Check if it is running.");
            }
        }
        catch (Exception e) {
            builder.down().withDetail("error", (Object)(e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()));
        }
    }
}

