/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.application.health;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Component;

@Component(value="mongoDB")
public class MongoDbHealthIndicator
extends AbstractHealthIndicator {
    private final MongoClient mongoClient;

    public MongoDbHealthIndicator(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            this.mongoClient.listDatabaseNames();
            MongoDatabase database = this.mongoClient.getDatabase("admin");
            Document buildInfo = database.runCommand((Bson)new Document("buildInfo", (Object)1));
            String mongoVersion = buildInfo.getString((Object)"version");
            builder.withDetail("name", (Object)"MongoDB");
            builder.up().withDetail("version", (Object)mongoVersion);
        }
        catch (Exception e) {
            builder.down().withDetail("error", (Object)e.getMessage());
        }
    }
}

