/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.api;

import com.becon.opencelium.backend.api.ApiType;
import com.becon.opencelium.backend.api.factory.ApiFactory;
import com.becon.opencelium.backend.api.module.TemplateModule;
import com.becon.opencelium.backend.api.serviceportal.ServicePortal;
import com.becon.opencelium.backend.constant.props.OpenceliumProps;
import com.becon.opencelium.backend.database.mysql.service.OnlineSyncHistoryService;
import com.becon.opencelium.backend.template.entity.Template;
import com.becon.opencelium.backend.template.service.TemplateService;
import com.becon.opencelium.backend.versionmanager.EntityUpdater;
import com.becon.opencelium.backend.versionmanager.EntityVersionManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateSyncService {
    private final TemplateModule templateModule;
    private final OpenceliumProps ocProps;
    private final EntityUpdater<Template> templateEntityUpdater;
    private final TemplateService templateService;
    private final OnlineSyncHistoryService onlineSyncHistoryService;
    private final ObjectMapper objectMapper;
    private static final String SERVICE = "Template File";
    private static final Logger logger = LoggerFactory.getLogger(TemplateSyncService.class);

    public TemplateSyncService(OpenceliumProps ocProps, EntityVersionManager entityVersionManager, TemplateService templateService, OnlineSyncHistoryService onlineSyncHistoryService, ApiFactory apiFactory, @Qualifier(value="objectMapper") ObjectMapper objectMapper) {
        this.ocProps = ocProps;
        this.templateEntityUpdater = entityVersionManager.getUpdater(Template.class);
        this.templateService = templateService;
        this.onlineSyncHistoryService = onlineSyncHistoryService;
        this.templateModule = ((ServicePortal)apiFactory.get(ApiType.SERVICE_PORTAL).features()).template();
        this.objectMapper = objectMapper;
    }

    @Transactional
    public void syncTemplates() {
        byte[] zipBytes = (byte[])this.templateModule.getAllTemplateFiles().getBody();
        Objects.requireNonNull(zipBytes);
        ArrayList<CallSite> details = new ArrayList<CallSite>();
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zipBytes));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getName().endsWith(".json")) {
                    byte[] jsonBytes = zis.readAllBytes();
                    Template template = (Template)this.objectMapper.readValue(jsonBytes, Template.class);
                    try {
                        this.templateEntityUpdater.updateToCurrentVersion((Object)template).ifUpdated(x -> template.setVersion(this.ocProps.getVersion()));
                        this.templateService.save(template);
                        details.add((CallSite)((Object)(template.getTemplateId() + ".json")));
                    }
                    catch (Exception e) {
                        logger.warn("Failed to sync template file: ", (Throwable)e);
                    }
                }
                zis.closeEntry();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.onlineSyncHistoryService.save(SERVICE, details);
        }
    }
}

