/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.versionmanager.template;

import com.becon.opencelium.backend.database.mongodb.entity.ConditionMng;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.ocel.OCExpressionHelper;
import com.becon.opencelium.backend.resource.connection.ConditionDTO;
import com.becon.opencelium.backend.resource.connection.MethodDTO;
import com.becon.opencelium.backend.resource.connection.OperatorDTO;
import com.becon.opencelium.backend.resource.connection.StatementDTO;
import com.becon.opencelium.backend.resource.connection.old.FieldBindingOldDTO;
import com.becon.opencelium.backend.resource.connector.BodyDTO;
import com.becon.opencelium.backend.resource.template.CtionTemplateResource;
import com.becon.opencelium.backend.template.entity.Template;
import com.becon.opencelium.backend.versionmanager.Wrapper;
import com.becon.opencelium.backend.versionmanager.base.Reference;
import com.becon.opencelium.backend.versionmanager.base.UpdaterVersion;
import com.becon.opencelium.backend.versionmanager.base.Utils;
import com.becon.opencelium.backend.versionmanager.base.Version43Utils;
import com.becon.opencelium.backend.versionmanager.template.Template40Updater;
import com.becon.opencelium.backend.versionmanager.template.TemplateUpdater;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class Template44Updater
implements TemplateUpdater {
    private static final UpdaterVersion currentVersion = UpdaterVersion.VERSION_4_4;
    private final Template40Updater template40Updater;
    private final ObjectMapper objectMapper;
    private final Mapper<ConditionMng, ConditionDTO> conditionMapper;

    public Template44Updater(Template40Updater template40Updater, ObjectMapper objectMapper, Mapper<ConditionMng, ConditionDTO> conditionMapper) {
        this.template40Updater = template40Updater;
        this.objectMapper = objectMapper;
        this.conditionMapper = conditionMapper;
    }

    public Wrapper<Template> updateToCurrentVersion(Template template) {
        return this.updateFromInternal(template, template.getVersion());
    }

    public Wrapper<Template> updateFrom(Template template, String oldVersion) {
        return this.updateFromInternal(template, oldVersion);
    }

    private Wrapper<Template> updateFromInternal(Template template, String oldVersion) {
        if (Objects.isNull(template) || Utils.compare((String)currentVersion.getVersion(), (String)oldVersion) <= 0) {
            return Wrapper.notUpdated((Object)template);
        }
        if (Utils.compare((String)oldVersion, (String)"4.0") < 0) {
            Wrapper updatedTo4_0 = this.template40Updater.updateFrom(template, oldVersion);
            if (!updatedTo4_0.isUpdated()) {
                return updatedTo4_0;
            }
            Wrapper result = this.updateFromGreaterThan4_0((Template)updatedTo4_0.getData(), updatedTo4_0.getNewVersion());
            return Wrapper.updated((Object)((Template)result.getData())).changed(true).withOldVersion(oldVersion).withNewVersion(currentVersion.getVersion());
        }
        if (Utils.compare((String)oldVersion, (String)"4.0") >= 0) {
            return this.updateFromGreaterThan4_0(template, oldVersion);
        }
        return Wrapper.notUpdated((Object)template);
    }

    private Wrapper<Template> updateFromGreaterThan4_0(Template template, String oldVersion) {
        template.setVersion(currentVersion.getVersion());
        CtionTemplateResource connection = template.getConnection();
        Reference changed = new Reference((Object)false);
        if (Objects.nonNull(connection.getFromConnector().getMethods())) {
            List fromMethods = (List)this.objectMapper.convertValue(connection.getFromConnector().getMethods(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            fromMethods.forEach(x -> this.update(x, changed));
            connection.getFromConnector().setMethods((Object)fromMethods);
        }
        if (Objects.nonNull(connection.getFromConnector().getOperators())) {
            List fromOperators = (List)this.objectMapper.convertValue(connection.getFromConnector().getOperators(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            fromOperators.forEach(x -> this.update(x, changed));
            connection.getFromConnector().setOperators((Object)fromOperators);
        }
        if (Objects.nonNull(connection.getToConnector().getMethods())) {
            List toMethods = (List)this.objectMapper.convertValue(connection.getToConnector().getMethods(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            toMethods.forEach(x -> this.update(x, changed));
            connection.getToConnector().setMethods((Object)toMethods);
        }
        if (Objects.nonNull(connection.getToConnector().getOperators())) {
            List toOperators = (List)this.objectMapper.convertValue(connection.getToConnector().getOperators(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            toOperators.forEach(x -> this.update(x, changed));
            connection.getToConnector().setOperators((Object)toOperators);
        }
        if (Objects.nonNull(connection.getFieldBinding())) {
            List fieldBindings = (List)this.objectMapper.convertValue(connection.getFieldBinding(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            fieldBindings.forEach(x -> this.update(x, changed));
            connection.setFieldBinding((Object)fieldBindings);
        }
        return Wrapper.updated((Object)template).changed(((Boolean)changed.getValue()).booleanValue()).withOldVersion(oldVersion).withNewVersion(currentVersion.getVersion());
    }

    private void update(FieldBindingOldDTO fieldBinding, Reference<Boolean> changed) {
        if (Objects.nonNull(fieldBinding)) {
            if (Objects.nonNull(fieldBinding.getFrom())) {
                fieldBinding.getFrom().forEach(x -> {
                    if (Objects.nonNull(x) && !StringUtils.isBlank((CharSequence)x.getType())) {
                        x.setField(Version43Utils.replace((String)x.getField(), (Reference)changed, (boolean)true, (boolean)Objects.equals(x.getType(), "header")));
                    }
                });
            }
            if (Objects.nonNull(fieldBinding.getTo())) {
                fieldBinding.getTo().forEach(x -> {
                    if (Objects.nonNull(x) && !StringUtils.isBlank((CharSequence)x.getType())) {
                        x.setField(Version43Utils.replace((String)x.getField(), (Reference)changed, (boolean)true, (boolean)Objects.equals(x.getType(), "header")));
                    }
                });
            }
            if (Objects.nonNull(fieldBinding.getEnhancement()) && Objects.nonNull(fieldBinding.getEnhancement().getExpertVar())) {
                fieldBinding.getEnhancement().setExpertVar(Version43Utils.replace((String)fieldBinding.getEnhancement().getExpertVar(), changed));
            }
        }
    }

    private void update(OperatorDTO operator, Reference<Boolean> changed) {
        if (!Objects.isNull(operator) && !Objects.isNull(operator.getCondition())) {
            String exp;
            ConditionDTO condition = operator.getCondition();
            StatementDTO leftStatement = condition.getLeftStatement();
            StatementDTO rightStatement = condition.getRightStatement();
            if (Objects.nonNull(leftStatement) && !StringUtils.isBlank((CharSequence)leftStatement.getType())) {
                leftStatement.setField(Version43Utils.replace((String)leftStatement.getField(), changed, (boolean)true, (boolean)Objects.equals(leftStatement.getType(), "header")));
            }
            if (Objects.nonNull(rightStatement) && !StringUtils.isBlank((CharSequence)rightStatement.getType())) {
                rightStatement.setField(Version43Utils.replace((String)rightStatement.getField(), changed, (boolean)true, (boolean)Objects.equals(rightStatement.getType(), "header")));
            }
            if (Objects.nonNull(exp = OCExpressionHelper.buildExp((ConditionMng)((ConditionMng)this.conditionMapper.toEntity((Object)operator.getCondition()))))) {
                operator.setExpression(exp);
                operator.setCondition(null);
            }
        }
    }

    private void update(MethodDTO method, Reference<Boolean> changed) {
        if (Objects.nonNull(method) && Objects.nonNull(method.getRequest())) {
            Map headers = method.getRequest().getHeader();
            BodyDTO body = method.getRequest().getBody();
            if (Objects.nonNull(headers)) {
                headers.entrySet().forEach(entry -> entry.setValue(Version43Utils.replace((String)((String)entry.getValue()), (Reference)changed)));
            }
            method.getRequest().setEndpoint(Version43Utils.replace((String)method.getRequest().getEndpoint(), changed));
            if (Objects.nonNull(body) && Objects.nonNull(body.getFields())) {
                body.setFields(Version43Utils.updateMap((Map)body.getFields(), changed));
            }
        }
    }
}

