/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.versionmanager.enhancement;

import com.becon.opencelium.backend.database.mysql.entity.Enhancement;
import com.becon.opencelium.backend.versionmanager.Wrapper;
import com.becon.opencelium.backend.versionmanager.base.UpdaterVersion;
import com.becon.opencelium.backend.versionmanager.base.Utils;
import com.becon.opencelium.backend.versionmanager.base.Version43Utils;
import com.becon.opencelium.backend.versionmanager.enhancement.EnhancementUpdater;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class Enhancement44Updater
implements EnhancementUpdater {
    private static final UpdaterVersion currentVersion = UpdaterVersion.VERSION_4_4;

    public Wrapper<Enhancement> updateToCurrentVersion(Enhancement enhancement) {
        return this.updateFromInternal(enhancement, null);
    }

    public Wrapper<Enhancement> updateFrom(Enhancement enhancement, String oldVersion) {
        return this.updateFromInternal(enhancement, oldVersion);
    }

    private Wrapper<Enhancement> updateFromInternal(Enhancement enhancement, String oldVersion) {
        if (Objects.isNull(enhancement) || Utils.compare((String)currentVersion.getVersion(), (String)oldVersion) <= 0) {
            return Wrapper.notUpdated((Object)enhancement);
        }
        boolean changed = false;
        if (Objects.nonNull(enhancement.getArgs())) {
            String replaced = Version43Utils.updateRef((String)enhancement.getArgs());
            if (!Objects.equals(replaced, enhancement.getArgs())) {
                changed = true;
            }
            enhancement.setArgs(replaced);
        }
        return Wrapper.updated((Object)enhancement).changed(changed).withOldVersion(oldVersion).withNewVersion(currentVersion.getVersion());
    }
}

