/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.versionmanager.connectionmng;

import com.becon.opencelium.backend.database.mongodb.entity.ConnectionMng;
import com.becon.opencelium.backend.versionmanager.Wrapper;
import com.becon.opencelium.backend.versionmanager.base.UpdaterVersion;
import com.becon.opencelium.backend.versionmanager.base.Utils;
import com.becon.opencelium.backend.versionmanager.connectionmng.Connection44MngUpdater;
import com.becon.opencelium.backend.versionmanager.connectionmng.ConnectionMngUpdater;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class Connection46MngUpdater
implements ConnectionMngUpdater {
    private static final UpdaterVersion currentVersion = UpdaterVersion.VERSION_4_6;
    private final Connection44MngUpdater connection44MngUpdater;

    public Connection46MngUpdater(Connection44MngUpdater connection44MngUpdater) {
        this.connection44MngUpdater = connection44MngUpdater;
    }

    public Wrapper<ConnectionMng> updateToCurrentVersion(ConnectionMng connection) {
        return this.updateFromInternal(connection, connection.getVersion());
    }

    public Wrapper<ConnectionMng> updateFrom(ConnectionMng connection, String oldVersion) {
        return this.updateFromInternal(connection, oldVersion);
    }

    private Wrapper<ConnectionMng> updateFromInternal(ConnectionMng connection, String oldVersion) {
        if (Objects.isNull(connection) || Utils.compare((String)currentVersion.getVersion(), (String)oldVersion) < 0) {
            return Wrapper.notUpdated((Object)connection);
        }
        if (Utils.compare((String)oldVersion, (String)UpdaterVersion.VERSION_4_4.getVersion()) < 0) {
            Wrapper updatedTo4_4 = this.connection44MngUpdater.updateFrom(connection, oldVersion);
            return this.updateFromGreaterThan4_4((ConnectionMng)updatedTo4_4.getData(), oldVersion);
        }
        return this.updateFromGreaterThan4_4(connection, oldVersion);
    }

    private Wrapper<ConnectionMng> updateFromGreaterThan4_4(ConnectionMng connection, String oldVersion) {
        if (Objects.nonNull(connection.getFromConnector()) && StringUtils.isBlank((CharSequence)connection.getFromConnector().getFlowId())) {
            connection.getFromConnector().setFlowId(UUID.randomUUID().toString());
        }
        if (Objects.nonNull(connection.getToConnector()) && StringUtils.isBlank((CharSequence)connection.getToConnector().getFlowId())) {
            connection.getToConnector().setFlowId(UUID.randomUUID().toString());
        }
        connection.setVersion(currentVersion.getVersion());
        return Wrapper.updated((Object)connection).changed(true).withOldVersion(oldVersion).withNewVersion(currentVersion.getVersion());
    }
}

