/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.versionmanager.base;

import com.becon.opencelium.backend.versionmanager.base.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Version43Utils {
    private static final Pattern REFERENCE_REGEX = Pattern.compile("#[a-zA-Z0-9]{6}\\.(\\(response\\)|\\(request\\))\\..*?(?=;|%}|$)");
    private static final Pattern REQUEST_PATTERN = Pattern.compile("^(#\\w+)\\.(\\(request\\))\\.(?!body\\.\\$|header\\.\\$)(.+)$");
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("^(#\\w+)\\.(\\(response\\))\\.(success|fail)\\.(.+)$");

    public static String updateRef(String rawStr) {
        Matcher referenceMatcher = REFERENCE_REGEX.matcher(rawStr);
        StringBuilder result = new StringBuilder();
        while (referenceMatcher.find()) {
            String match = referenceMatcher.group();
            Matcher requestMatcher = REQUEST_PATTERN.matcher(match);
            Matcher responseMatcher = RESPONSE_PATTERN.matcher(match);
            Object replacement = match;
            if (requestMatcher.matches()) {
                replacement = requestMatcher.group(1) + "." + requestMatcher.group(2) + ".body.$." + requestMatcher.group(3);
            } else if (responseMatcher.matches()) {
                replacement = responseMatcher.group(1) + "." + responseMatcher.group(2) + ".body.$." + responseMatcher.group(4);
            }
            referenceMatcher.appendReplacement(result, Matcher.quoteReplacement((String)replacement));
        }
        referenceMatcher.appendTail(result);
        return result.toString();
    }

    public static String updateField(String rawStr, boolean isHeader) {
        if (!(rawStr.startsWith("body.$.") || rawStr.startsWith("header.$.") || rawStr.equals("status"))) {
            if (rawStr.startsWith("success")) {
                rawStr = rawStr.replaceFirst("success.", "");
            } else if (rawStr.startsWith("fail")) {
                rawStr = rawStr.replaceFirst("fail.", "");
            }
            return isHeader ? "header.$." + rawStr : "body.$." + rawStr;
        }
        return rawStr;
    }

    public static Map<String, Object> updateMap(Map<String, Object> obj, Reference<Boolean> changed) {
        for (Map.Entry<String, Object> entry : obj.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof String) {
                String str = (String)object;
                entry.setValue(Version43Utils.replace((String)str, changed));
                continue;
            }
            if (entry.getValue() instanceof Map) {
                Map object2 = (Map)entry.getValue();
                entry.setValue(Version43Utils.updateMap((Map)object2, changed));
                continue;
            }
            object = entry.getValue();
            if (!(object instanceof List)) continue;
            List list = (List)object;
            entry.setValue(Version43Utils.updateList((List)list, changed));
        }
        return obj;
    }

    public static List<?> updateList(List<?> list, Reference<Boolean> changed) {
        ArrayList<Object> responseList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj instanceof String) {
                String str = (String)obj;
                responseList.add(i, Version43Utils.replace((String)str, changed));
                continue;
            }
            if (obj instanceof Map) {
                Map object = (Map)obj;
                responseList.add(Version43Utils.updateMap((Map)object, changed));
                continue;
            }
            if (obj instanceof List) {
                List innerList = (List)obj;
                responseList.add(Version43Utils.updateList((List)innerList, changed));
                continue;
            }
            responseList.add(obj);
        }
        return responseList;
    }

    public static String replace(String rawStr, Reference<Boolean> changed) {
        return Version43Utils.replace((String)rawStr, changed, (boolean)false, (boolean)false);
    }

    public static String replace(String rawStr) {
        return Version43Utils.replace((String)rawStr, (boolean)false, (boolean)false);
    }

    public static String replace(String rawStr, Reference<Boolean> changed, boolean onlyField, boolean isHeader) {
        String replaced = Version43Utils.replace((String)rawStr, (boolean)onlyField, (boolean)isHeader);
        if (!StringUtils.equals((CharSequence)replaced, (CharSequence)rawStr)) {
            changed.setValue((Object)true);
        }
        return replaced;
    }

    public static String replace(String rawStr, boolean onlyField, boolean isHeader) {
        if (Objects.isNull(rawStr)) {
            return null;
        }
        return onlyField ? Version43Utils.updateField((String)rawStr, (boolean)isHeader) : Version43Utils.updateRef((String)rawStr);
    }
}

