/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.versionmanager.backup;

import com.becon.opencelium.backend.template.entity.Template;
import com.becon.opencelium.backend.versionmanager.backup.BackupEntity;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.springframework.util.FileSystemUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileBackupManager {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Path backupDir = Paths.get("runtime/backup/", new String[0]);

    public static void doBackup(Template template, String fromVersion, String toVersion) {
        FileBackupManager.doBackup((Object)template, (String)fromVersion, (String)toVersion, (String)"template", (String)template.getTemplateId());
    }

    public static boolean isPresent(String entity, String fromVersion, String id) {
        File[] matchingFiles = backupDir.resolve(entity).toFile().listFiles((dir, name) -> FileBackupManager.isThisVersion((String)name, (String)entity, (String)fromVersion, (String)id));
        return matchingFiles != null && matchingFiles.length > 0;
    }

    private static boolean isThisVersion(String name, String entity, String fromVersion, String id) {
        return name.startsWith(entity + "_v" + fromVersion + "_") && name.endsWith(id + ".json");
    }

    private static <T> void doBackup(T entity, String fromVersion, String toVersion, String entityType, String id) {
        try {
            fromVersion = fromVersion.replaceAll("[^\\d.]", "");
            BackupEntity backup = new BackupEntity();
            backup.setTimestamp(Instant.now().toEpochMilli());
            backup.setFromVersion(fromVersion);
            backup.setToVersion(toVersion);
            backup.setEntityClass(entity.getClass().getName());
            backup.setData(entity);
            Path entityBackupDir = backupDir.resolve(entityType);
            Files.createDirectories(entityBackupDir, new FileAttribute[0]);
            if (FileBackupManager.isPresent((String)entityType, (String)fromVersion, (String)id)) {
                return;
            }
            String fileName = String.format("%s_v%s_%s_%s.json", entityType, fromVersion.replace('.', '_'), LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd")), id);
            Path filePath = entityBackupDir.resolve(fileName);
            try (BufferedWriter writer = Files.newBufferedWriter(filePath, StandardOpenOption.CREATE);){
                objectMapper.writeValue((Writer)writer, (Object)backup);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void moveToNewLocation(String oldPath, String newPath) {
        Path sourceDir = Paths.get(oldPath, new String[0]);
        Path targetDir = Paths.get(newPath, new String[0]);
        if (!Files.exists(sourceDir, new LinkOption[0])) {
            return;
        }
        if (!Files.exists(targetDir, new LinkOption[0])) {
            targetDir.toFile().mkdirs();
        }
        try {
            FileSystemUtils.copyRecursively((Path)sourceDir, (Path)targetDir);
            FileSystemUtils.deleteRecursively((Path)sourceDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

