/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.utility;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tomcat.util.http.fileupload.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);

    public static void extractZip(InputStream zipInputStream, Path rootPath) throws IOException {
        File f = new File("../frontend");
        FileUtils.deleteDirectory((File)f);
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(zipInputStream));){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                Path targetPath = rootPath.resolve(entryName).normalize();
                if (entryName.contains("src/backend/src/main/resources/license")) continue;
                if (!targetPath.startsWith(rootPath)) {
                    throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
                }
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                String parent = targetPath.getParent().getFileName().toString();
                String file = targetPath.getFileName().toString();
                Files.copy(zis, targetPath, StandardCopyOption.REPLACE_EXISTING);
                log.info("\"" + String.valueOf(targetPath.normalize()) + "\" has been replaced or added successfully");
            }
        }
    }

    public static void saveZip(InputStream inputStream, String zipFileName, Path dir) throws IOException {
        Path zipFilePath = dir.resolve(zipFileName + ".zip").normalize();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectory(dir, new FileAttribute[0]);
        }
        Files.copy(inputStream, zipFilePath, StandardCopyOption.REPLACE_EXISTING);
    }

    private static void clearFolder(Path folder) throws IOException {
        if (Files.exists(folder, new LinkOption[0])) {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
        }
    }
}

