/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.utility;

import com.becon.opencelium.backend.database.mongodb.entity.BodyMng;
import com.becon.opencelium.backend.database.mongodb.entity.ConditionMng;
import com.becon.opencelium.backend.database.mongodb.entity.ConnectionMng;
import com.becon.opencelium.backend.database.mongodb.entity.ConnectorMng;
import com.becon.opencelium.backend.database.mongodb.entity.MethodMng;
import com.becon.opencelium.backend.database.mongodb.entity.OperatorMng;
import com.becon.opencelium.backend.database.mongodb.entity.RequestMng;
import com.becon.opencelium.backend.database.mongodb.entity.ResponseMng;
import com.becon.opencelium.backend.database.mongodb.entity.ResultMng;
import com.becon.opencelium.backend.database.mongodb.entity.StatementMng;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;

/*
 * Exception performing whole class analysis ignored.
 */
public class Neo4jDriverUtility {
    private static final String OC_ATTRIBUTES = "__oc__attributes";

    public static void convertResultToConnection(Result result, ConnectionMng connectionMng) {
        ArrayList<Record> recordsForFromConnector = new ArrayList<Record>();
        ArrayList<Record> recordsForToConnector = new ArrayList<Record>();
        while (result.hasNext()) {
            Record record = result.next();
            Path connectionPath = record.get("p").asPath();
            List relationships = (List)connectionPath.relationships();
            if (relationships.size() < 2 || ((Relationship)relationships.get(relationships.size() - 1)).hasType("linked")) continue;
            if (((Relationship)relationships.get(0)).hasType("from_connector")) {
                recordsForFromConnector.add(record);
                continue;
            }
            recordsForToConnector.add(record);
        }
        Neo4jDriverUtility.setMethodAndOperators(recordsForFromConnector, (ConnectorMng)connectionMng.getFromConnector());
        Neo4jDriverUtility.setMethodAndOperators(recordsForToConnector, (ConnectorMng)connectionMng.getToConnector());
    }

    private static void setMethodAndOperators(List<Record> records, ConnectorMng connectorMng) {
        connectorMng.setMethods(new ArrayList());
        connectorMng.setOperators(new ArrayList());
        Neo4jDriverUtility.crawlMethodAndOperators((List)connectorMng.getMethods(), (List)connectorMng.getOperators(), (int)0, records);
        Neo4jDriverUtility.clearEmptyBodies((List)connectorMng.getMethods());
        Neo4jDriverUtility.correctOperators((List)connectorMng.getOperators());
    }

    private static void correctOperators(List<OperatorMng> operators) {
        operators.forEach(o -> {
            if (o.getType().equals("loop") && (o.getCondition().getRelationalOperator() == null || o.getCondition().getRelationalOperator().isBlank())) {
                o.getCondition().setRelationalOperator("for");
            }
        });
    }

    private static void clearEmptyBodies(List<MethodMng> methods) {
        methods.forEach(m -> {
            if (m.getRequest().getBody().getFields() == null || m.getRequest().getBody().getFormat() == null) {
                m.getRequest().setBody(null);
            }
            if (m.getResponse().getFail().getBody().getFields() == null || m.getResponse().getFail().getBody().getFormat() == null) {
                m.getResponse().getFail().setBody(null);
            }
            if (m.getResponse().getSuccess().getBody().getFields() == null || m.getResponse().getSuccess().getBody().getFormat() == null) {
                m.getResponse().getSuccess().setBody(null);
            }
        });
    }

    private static int crawlMethodAndOperators(List<MethodMng> methods, List<OperatorMng> operators, int y, List<Record> records) {
        for (int i = y; i < records.size(); ++i) {
            Path path = records.get(i).get("p").asPath();
            Node node = path.end();
            if (node.hasLabel("Method")) {
                method = Neo4jDriverUtility.mapMethod((Map)node.asMap());
                methods.add(method);
                if (i + 1 >= records.size()) {
                    return i;
                }
                nextPath = records.get(i + 1).get("p").asPath();
                lastNodeOfNextRecord = nextPath.end();
                if (lastNodeOfNextRecord.hasLabel("Method") || lastNodeOfNextRecord.hasLabel("Statement")) {
                    i = Neo4jDriverUtility.crawlMethodAndOperators(methods, operators, (int)(i + 1), records);
                } else if (lastNodeOfNextRecord.hasLabel("Request")) {
                    prevMethod = Neo4jDriverUtility.findPrevMethod(methods, (Path)nextPath);
                    i = Neo4jDriverUtility.getRequest((MethodMng)prevMethod, (int)(i + 1), records);
                    i = Neo4jDriverUtility.getResponse((MethodMng)prevMethod, (int)(i + 1), records);
                } else if (lastNodeOfNextRecord.hasLabel("Response")) {
                    prevMethod = Neo4jDriverUtility.findPrevMethod(methods, (Path)nextPath);
                    i = Neo4jDriverUtility.getResponse((MethodMng)prevMethod, (int)(i + 1), records);
                    i = Neo4jDriverUtility.getRequest((MethodMng)prevMethod, (int)(i + 1), records);
                }
            } else if (node.hasLabel("Statement")) {
                OperatorMng operator = Neo4jDriverUtility.mapStatement((Map)node.asMap());
                operators.add(operator);
                if (i + 1 >= records.size()) {
                    return i;
                }
                nextPath = records.get(i + 1).get("p").asPath();
                lastNodeOfNextRecord = nextPath.end();
                if (lastNodeOfNextRecord.hasLabel("Method") || lastNodeOfNextRecord.hasLabel("Statement")) {
                    i = Neo4jDriverUtility.crawlMethodAndOperators(methods, operators, (int)(i + 1), records);
                } else if (lastNodeOfNextRecord.hasLabel("Variable")) {
                    List nextRelationships = (List)nextPath.relationships();
                    if (((Relationship)nextRelationships.get(nextRelationships.size() - 1)).hasType("left")) {
                        Neo4jDriverUtility.completeOperator((ConditionMng)operator.getCondition(), (Record)records.get(i + 1), (String)"left");
                    } else {
                        Neo4jDriverUtility.completeOperator((ConditionMng)operator.getCondition(), (Record)records.get(i + 1), (String)"right");
                    }
                }
            } else if (node.hasLabel("Request")) {
                method = Neo4jDriverUtility.findPrevMethod(methods, (Path)path);
                i = Neo4jDriverUtility.getRequest((MethodMng)method, (int)i, records);
            } else if (node.hasLabel("Response")) {
                method = Neo4jDriverUtility.findPrevMethod(methods, (Path)path);
                i = Neo4jDriverUtility.getResponse((MethodMng)method, (int)i, records);
            } else if (node.hasLabel("Variable")) {
                List relationships = (List)path.relationships();
                if (((Relationship)relationships.get(relationships.size() - 1)).hasType("left")) {
                    prevOperator = Neo4jDriverUtility.findPrevOperator(operators, (Path)path);
                    Neo4jDriverUtility.completeOperator((ConditionMng)prevOperator.getCondition(), (Record)records.get(i), (String)"left");
                } else {
                    prevOperator = Neo4jDriverUtility.findPrevOperator(operators, (Path)path);
                    Neo4jDriverUtility.completeOperator((ConditionMng)prevOperator.getCondition(), (Record)records.get(i), (String)"right");
                }
            }
            y = ++i;
        }
        return y;
    }

    private static OperatorMng findPrevOperator(List<OperatorMng> operators, Path path) {
        Node a = null;
        Node b = null;
        for (Node node : path.nodes()) {
            a = b;
            b = node;
        }
        Map map = a.asMap();
        String index = (String)map.get("index");
        String type = (String)map.get("type");
        return operators.stream().filter(o -> o.getIndex().equals(index) && o.getType().equals(type)).findAny().orElseThrow(() -> new RuntimeException("Operator[index: " + index + ", type: " + type + "] not found"));
    }

    private static MethodMng findPrevMethod(List<MethodMng> methods, Path path) {
        Node a = null;
        Node b = null;
        for (Node node : path.nodes()) {
            a = b;
            b = node;
        }
        Map map = a.asMap();
        String color = (String)map.get("color");
        String index = (String)map.get("index");
        String name = (String)map.get("name");
        return methods.stream().filter(m -> m.getColor().equals(color) && m.getName().equals(name) && m.getIndex().equals(index)).findAny().orElseThrow(() -> new RuntimeException("Method not found with color: " + color));
    }

    private static int getResponse(MethodMng method, int y, List<Record> records) {
        if (y >= records.size()) {
            return records.size() - 1;
        }
        if (!records.get(y).get("p").asPath().end().hasLabel("Response")) {
            return y - 1;
        }
        ResponseMng responseMng = new ResponseMng();
        method.setResponse(responseMng);
        y = Neo4jDriverUtility.getResult((ResponseMng)responseMng, (int)(y + 1), records);
        return y;
    }

    private static int getRequest(MethodMng methodMng, int y, List<Record> records) {
        if (y >= records.size()) {
            return records.size() - 1;
        }
        Record record = records.get(y);
        Path path = record.get("p").asPath();
        Node node = path.end();
        if (!node.hasLabel("Request")) {
            return y - 1;
        }
        String method = (String)node.asMap().get("method");
        String endpoint = (String)node.asMap().get("endpoint");
        RequestMng requestMng = new RequestMng();
        requestMng.setMethod(method);
        requestMng.setEndpoint(endpoint);
        requestMng.setBody(new BodyMng());
        requestMng.setHeader(new HashMap());
        methodMng.setRequest(requestMng);
        if (y + 1 >= records.size()) {
            return y;
        }
        Node nextNode = records.get(y + 1).get("p").asPath().end();
        if (nextNode.hasLabel("Header")) {
            y = Neo4jDriverUtility.getHeader((Map)requestMng.getHeader(), (int)(y + 1), records);
            y = Neo4jDriverUtility.getBody((BodyMng)requestMng.getBody(), (int)(y + 1), records);
        } else if (nextNode.hasLabel("Body")) {
            y = Neo4jDriverUtility.getBody((BodyMng)requestMng.getBody(), (int)(y + 1), records);
            y = Neo4jDriverUtility.getHeader((Map)requestMng.getHeader(), (int)(y + 1), records);
        }
        return y;
    }

    private static int getResult(ResponseMng responseMng, int y, List<Record> records) {
        if (y >= records.size()) {
            return records.size() - 1;
        }
        Path path = records.get(y).get("p").asPath();
        Node node = path.end();
        if (!node.hasLabel("Result")) {
            return y - 1;
        }
        String status = node.asMap().getOrDefault("status", "200").toString();
        String name = node.asMap().getOrDefault("name", "success").toString();
        ResultMng resultMng = new ResultMng();
        resultMng.setStatus(status);
        resultMng.setBody(new BodyMng());
        if (name.equals("success")) {
            responseMng.setSuccess(resultMng);
        } else {
            responseMng.setFail(resultMng);
        }
        y = Neo4jDriverUtility.getBody((BodyMng)resultMng.getBody(), (int)(y + 1), records);
        return Neo4jDriverUtility.getResult((ResponseMng)responseMng, (int)(y + 1), records);
    }

    private static int getHeader(Map<String, String> header, int y, List<Record> records) {
        if (y >= records.size()) {
            return records.size() - 1;
        }
        if (!records.get(y).get("p").asPath().end().hasLabel("Header")) {
            return y - 1;
        }
        for (int i = y + 1; i < records.size(); ++i) {
            Node node = records.get(i).get("p").asPath().end();
            if (!node.hasLabel("Item")) {
                return i - 1;
            }
            String name = (String)node.asMap().get("name");
            String value = (String)node.asMap().get("value");
            header.put(name, value);
        }
        return records.size() - 1;
    }

    private static int getBody(BodyMng bodyMng, int y, List<Record> records) {
        if (y >= records.size()) {
            return records.size() - 1;
        }
        Path path = records.get(y).get("p").asPath();
        Node node = path.end();
        if (!node.hasLabel("Body")) {
            return y - 1;
        }
        String data = (String)node.asMap().get("data");
        String type = (String)node.asMap().get("type");
        String format = (String)node.asMap().get("format");
        bodyMng.setData(data);
        bodyMng.setType(type);
        bodyMng.setFormat(format);
        bodyMng.setFields(new HashMap());
        y = Neo4jDriverUtility.getFields((Map)bodyMng.getFields(), records, (int)(y + 1), (int)1);
        return y;
    }

    private static int getFields(Map<String, Object> fields, List<Record> records, int y, int level) {
        int i = y;
        while (i < records.size()) {
            Path path = records.get(i).get("p").asPath();
            Node node = path.end();
            int currLevel = Neo4jDriverUtility.findLevelOfField((Path)path);
            int nextLevel = i + 1 >= records.size() ? -1 : Neo4jDriverUtility.findLevelOfField((Path)records.get(i + 1).get("p").asPath());
            if (level == 0 || !node.hasLabel("Field") || currLevel != level) {
                return i - 1;
            }
            String name = (String)node.asMap().get("name");
            String type = (String)node.asMap().get("type");
            Object value = node.asMap().get("value");
            switch (type) {
                case "object": {
                    String str;
                    if (name.equals("__oc__attributes") && value != null && value.equals("")) {
                        fields.put(name, "");
                        if (nextLevel < currLevel) {
                            return i;
                        }
                        i = Neo4jDriverUtility.getFields(fields, records, (int)(i + 1), (int)nextLevel);
                        break;
                    }
                    if (value instanceof String) {
                        str = (String)value;
                        fields.put(name, str);
                        i = Neo4jDriverUtility.getFields(fields, records, (int)(i + 1), (int)nextLevel);
                        break;
                    }
                    HashMap map = new HashMap();
                    fields.put(name, map);
                    i = Neo4jDriverUtility.getFields(map, records, (int)(i + 1), (int)nextLevel);
                    break;
                }
                case "array": {
                    String str;
                    if (value != null) {
                        if (!(value instanceof String)) break;
                        str = (String)value;
                        if (str.isEmpty()) {
                            fields.put(name, new ArrayList());
                        } else if (str.charAt(0) == '[' && str.charAt(str.length() - 1) == ']') {
                            String[] elements;
                            ArrayList<String> list = new ArrayList<String>();
                            str = str.substring(1, str.length() - 1);
                            for (String element : elements = str.split(",")) {
                                list.add(element.trim());
                            }
                            fields.put(name, list);
                        } else {
                            fields.put(name, value);
                        }
                        if (nextLevel < currLevel) {
                            return i;
                        }
                        i = Neo4jDriverUtility.getFields(fields, records, (int)(i + 1), (int)nextLevel);
                        break;
                    }
                    ArrayList list = new ArrayList();
                    list.add(new HashMap());
                    fields.put(name, list);
                    i = Neo4jDriverUtility.getFields((Map)((Map)list.get(0)), records, (int)(i + 1), (int)nextLevel);
                    break;
                }
                default: {
                    String str;
                    if (value instanceof String) {
                        str = (String)value;
                        if (!str.isEmpty()) {
                            fields.put(name, str);
                        }
                    } else if (value instanceof Boolean) {
                        Boolean b = (Boolean)value;
                        fields.put(name, b);
                    } else if (value instanceof Integer) {
                        Integer in = (Integer)value;
                        fields.put(name, in);
                    } else {
                        fields.put(name, value);
                    }
                    if (nextLevel < currLevel) {
                        return i;
                    }
                    i = Neo4jDriverUtility.getFields(fields, records, (int)(i + 1), (int)nextLevel);
                }
            }
            if (nextLevel == -1) {
                return i - 1;
            }
            y = i++;
        }
        return y;
    }

    private static int findLevelOfField(Path path) {
        Iterable relationships = path.relationships();
        int count = 0;
        for (Relationship r : relationships) {
            if (!r.hasType("has_field")) continue;
            ++count;
        }
        return count;
    }

    private static void completeOperator(ConditionMng conditionMng, Record record, String side) {
        Node node = record.get("p").asPath().end();
        if (side.equals("left")) {
            conditionMng.setLeftStatement(Neo4jDriverUtility.mapSV((Map)node.asMap()));
        } else {
            conditionMng.setRightStatement(Neo4jDriverUtility.mapSV((Map)node.asMap()));
        }
    }

    private static OperatorMng mapStatement(Map<String, Object> fields) {
        String index = (String)fields.get("index");
        String type = (String)fields.get("type");
        String iterator = (String)fields.get("iterator");
        String operand = (String)fields.get("operand");
        OperatorMng operatorMng = new OperatorMng();
        operatorMng.setIndex(index);
        operatorMng.setType(type);
        operatorMng.setIterator(iterator);
        ConditionMng conditionMng = new ConditionMng();
        conditionMng.setRelationalOperator(operand);
        operatorMng.setCondition(conditionMng);
        return operatorMng;
    }

    private static MethodMng mapMethod(Map<String, Object> fields) {
        String color = (String)fields.get("color");
        String name = (String)fields.get("name");
        String index = (String)fields.get("index");
        String label = (String)fields.get("label");
        Object aggregator = fields.getOrDefault("aggregatorId", 0);
        int aggregatorId = 0;
        if (aggregator instanceof Integer) {
            Integer intId = (Integer)aggregator;
            aggregatorId = intId;
        } else if (aggregator instanceof Long) {
            Long longId = (Long)aggregator;
            aggregatorId = Math.toIntExact(longId);
        }
        MethodMng methodMng = new MethodMng();
        methodMng.setColor(color);
        methodMng.setName(name);
        methodMng.setIndex(index);
        methodMng.setLabel(label);
        methodMng.setDataAggregator(Integer.valueOf(aggregatorId));
        return methodMng;
    }

    private static StatementMng mapSV(Map<String, Object> sv) {
        StatementMng statementMng = new StatementMng();
        String color = (String)sv.get("color");
        String filed = (String)sv.get("filed");
        String type = (String)sv.get("type");
        String rightPropertyValue = (String)sv.get("rightPropertyValue");
        statementMng.setColor(color);
        statementMng.setField(filed);
        statementMng.setType(type);
        statementMng.setRightPropertyValue(rightPropertyValue);
        return statementMng;
    }
}

