/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.subscription.utility;

import com.becon.opencelium.backend.subscription.dto.LicenseKey;
import com.becon.opencelium.backend.subscription.utility.MonthPeriod;
import com.becon.opencelium.backend.utility.crypto.CryptoUtil;
import com.becon.opencelium.backend.utility.crypto.HmacValidator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LicenseKeyUtility {
    private static final int MAX_ENCRYPT_BLOCK = 245;
    private static final Logger logger = LoggerFactory.getLogger(LicenseKeyUtility.class);

    public static boolean verify(String licenseKey, HmacValidator hmacValidator) {
        if (licenseKey == null || licenseKey.isEmpty()) {
            return false;
        }
        LicenseKey lk = LicenseKeyUtility.decrypt((String)licenseKey);
        return LicenseKeyUtility.verify((LicenseKey)lk, (HmacValidator)hmacValidator);
    }

    public static boolean verify(LicenseKey licenseKey, HmacValidator hmacValidator) {
        if (!hmacValidator.verify(licenseKey.getHmac())) {
            logger.error("License key is not Valid");
            return false;
        }
        if (licenseKey.getStartDate() > System.currentTimeMillis()) {
            throw new RuntimeException("Subscription will start at " + String.valueOf(Instant.ofEpochMilli(licenseKey.getStartDate())));
        }
        if (licenseKey.getEndDate() != 0L && licenseKey.getEndDate() < System.currentTimeMillis()) {
            throw new RuntimeException("You subscription has been expired at " + String.valueOf(Instant.ofEpochMilli(licenseKey.getEndDate())));
        }
        return true;
    }

    public static LicenseKey decrypt(String encryptedLicense) {
        if (encryptedLicense == null || encryptedLicense.isEmpty()) {
            return null;
        }
        try {
            byte[] decryptedData = CryptoUtil.decrypt((String)encryptedLicense, (String)"MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAnj2andeiYdgRAp1jkLej/xgslVEN+qodRNjguHNBV2gKHim9VXCvakAZveUqXN7/L7R+wlDrlnjLDWV5cN4aWDQFPKK0YcH+A1oSI7m/SbBaeyQSwH5PT/kYG0AU3C1FItoshhDKDhvSMk5iUJc66ZXRg4xBH9x3jOfKHRrvJlLRx8NX+WLPJNLpVog/an2lmDqWw2AsJYgf8p18baCavHKil39e8gDNizAQhQdC1yEK4RLgtsmGFGnrhCjNaZ/+NriYE4D/CK71QT4d//eF4LNgBqIGEPRb4ekt9qUH2T6F5XqiR90BFRLTyMv0ASos+k25GQqHS7WRjUHUOu0F1UL9POtjLCVj39q9U9ip6G3UYTNJ7gF6wUpzwmqQuLID4Bx3YOT7GeaiPc2AdlQlT5MbFSBMqHXcsScHfEQU2IPb2iYowLoKH7nqrCHOtR83/CDbzKKCHm0R072QmFh+67YPL3U1Vg+zrT4emlEYSM3gdOrcb4Wgm85+sUs3aoWmRPsDITUG+vqAbZ2C/gxgEmlVZzbKgH4NpFIO/eh7oW7cWXyJ+2Fc07T/NRs1UBAR6cjpZBFeVKIgIsWay6sFffOyv1lUM0DRvtM53BgaXV2V5TUbOzKlM+d2jBqlrCeq6TpJVG6FCrJsaaOgSq6Zgt5JLtdbtZqZtnYndk3FT78CAwEAAQ==");
            ObjectMapper objectMapper = new ObjectMapper();
            return (LicenseKey)objectMapper.readValue(decryptedData, LicenseKey.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPublicKey(Path path) {
        return "MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAnj2andeiYdgRAp1jkLej/xgslVEN+qodRNjguHNBV2gKHim9VXCvakAZveUqXN7/L7R+wlDrlnjLDWV5cN4aWDQFPKK0YcH+A1oSI7m/SbBaeyQSwH5PT/kYG0AU3C1FItoshhDKDhvSMk5iUJc66ZXRg4xBH9x3jOfKHRrvJlLRx8NX+WLPJNLpVog/an2lmDqWw2AsJYgf8p18baCavHKil39e8gDNizAQhQdC1yEK4RLgtsmGFGnrhCjNaZ/+NriYE4D/CK71QT4d//eF4LNgBqIGEPRb4ekt9qUH2T6F5XqiR90BFRLTyMv0ASos+k25GQqHS7WRjUHUOu0F1UL9POtjLCVj39q9U9ip6G3UYTNJ7gF6wUpzwmqQuLID4Bx3YOT7GeaiPc2AdlQlT5MbFSBMqHXcsScHfEQU2IPb2iYowLoKH7nqrCHOtR83/CDbzKKCHm0R072QmFh+67YPL3U1Vg+zrT4emlEYSM3gdOrcb4Wgm85+sUs3aoWmRPsDITUG+vqAbZ2C/gxgEmlVZzbKgH4NpFIO/eh7oW7cWXyJ+2Fc07T/NRs1UBAR6cjpZBFeVKIgIsWay6sFffOyv1lUM0DRvtM53BgaXV2V5TUbOzKlM+d2jBqlrCeq6TpJVG6FCrJsaaOgSq6Zgt5JLtdbtZqZtnYndk3FT78CAwEAAQ==";
    }

    private static boolean isEndDateValid(long unixTimeEndDate) {
        if (unixTimeEndDate == 0L) {
            return true;
        }
        return Instant.ofEpochSecond(unixTimeEndDate).isAfter(Instant.now());
    }

    private static boolean verifyPublicKey(String licenseKey) {
        return false;
    }

    private static PublicKey loadPublicKey(String publicKeyStr) throws Exception {
        byte[] byteKey = Base64.getDecoder().decode(publicKeyStr);
        X509EncodedKeySpec X509publicKey = new X509EncodedKeySpec(byteKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(X509publicKey);
    }

    private static byte[] concatChunks(ArrayList<byte[]> chunks) {
        int totalLength = 0;
        for (byte[] chunk : chunks) {
            totalLength += chunk.length;
        }
        byte[] result = new byte[totalLength];
        int offset = 0;
        for (byte[] chunk : chunks) {
            System.arraycopy(chunk, 0, result, offset, chunk.length);
            offset += chunk.length;
        }
        return result;
    }

    public static MonthPeriod getCurrentMonthPeriod(long initialDateMillis) {
        LocalDate initialDate = Instant.ofEpochMilli(initialDateMillis).atZone(ZoneOffset.UTC).toLocalDate();
        int anchorDay = initialDate.getDayOfMonth();
        LocalDate today = LocalDate.now(ZoneOffset.UTC);
        int currentMonthDay = Math.min(anchorDay, today.lengthOfMonth());
        LocalDate startDate = LocalDate.of(today.getYear(), today.getMonth(), currentMonthDay);
        LocalDate nextMonth = startDate.plusMonths(1L);
        int nextMonthDay = Math.min(anchorDay, nextMonth.lengthOfMonth());
        LocalDate endDate = LocalDate.of(nextMonth.getYear(), nextMonth.getMonth(), nextMonthDay).minusDays(1L);
        long startMillis = startDate.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
        long endMillis = endDate.atTime(LocalTime.MAX).atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
        return new MonthPeriod(startMillis, endMillis);
    }

    public static String readFreeLicense() {
        return "TYidZve2brv337lPLRaQ7cUM6Xm2ecPTeodbmBjlBURwxhhWwcziT6kiTJgHCpfN6SRfXx+CdK4rhvaSh3BBFqhEhoRhdSWS5BCjMLKZQ2oQVS/kzckvF7igA3kEGjZDmdYBmvv+pFXZk7RZurBS3qUix2arH2nlmYavPqiWPV4UBKPsemMUJilCZ51j3l36UBPq7aX96wQKz5EeKOFQCg8GsNnVMjI4Tk6CYelesrBrlm1B3uULiuSnzxAvrLqi9cgmkIrIbqTagCnM9dgHCRNec7EinvHFSC4ckaLEs9N/XczYF8mBgvIFSXc298oCk6vodU5aKpLT+hJPZb3FlJ94lxHecxwH2b7RaFPNP6d6/RPWbnTJOkSwMO0JurHq5zygqT1tc3R9+7pucRaCCtmYhaGtRYuieH0dBNYGQQuwnpBlq3f8yrVHL0X6aMVvdXHf3kspWvbw/r+zffqbLOYcKWRqz2Zsiz0YMBLaujzTVIBRQiLDOHNqgOR05zJ4qx0U7v6vub4hLdOdqtHAc0WvxSbehrqa8fRa9GYlBG7f8McfgfOgMj+IJAWIuV8Nb6PAJYeElBaXA2MLjusIid5ZbX096nBuNX1hyoG8+Q5i6NWsOwHD7eurfMwU4WwZfTYfu0S+3dOcg9CCoj5lcen1NbCj5dpopjEIFhI9pZo=";
    }
}

